# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
from .bulk_connected_entity import BulkConnectedEntity
import pydantic
from .entity_creation_request import EntityCreationRequest
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BulkEntityCreationFromObject(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.commons import Address, PhoneNumber
    from mercoa.entity_types import (
        BulkConnectedEntity,
        BulkEntityCreationFromObject,
        BusinessProfileRequest,
        Ein,
        EntityCreationRequest,
        ProfileRequest,
        TaxId,
    )

    BulkEntityCreationFromObject(
        connected_entity=BulkConnectedEntity(
            id="ent_a0f6ea94-0761-4a5e-a416-3c453cb7eced",
            link_created_as_payor=False,
            link_created_as_payee=True,
        ),
        entities=[
            EntityCreationRequest(
                is_customer=True,
                is_payor=True,
                is_payee=False,
                account_type="business",
                foreign_id="MY-DB-ID-12345",
                profile=ProfileRequest(
                    business=BusinessProfileRequest(
                        email="customer@acme.com",
                        legal_business_name="Acme Inc.",
                        website="http://www.acme.com",
                        business_type="llc",
                        phone=PhoneNumber(
                            country_code="1",
                            number="4155551234",
                        ),
                        address=Address(
                            address_line_1="123 Main St",
                            address_line_2="Unit 1",
                            city="San Francisco",
                            state_or_province="CA",
                            postal_code="94105",
                            country="US",
                        ),
                        tax_id=TaxId(
                            ein=Ein(
                                number="12-3456789",
                            ),
                        ),
                    ),
                ),
            )
        ],
    )
    """

    connected_entity: typing.Optional[BulkConnectedEntity] = pydantic.Field(alias="connectedEntity", default=None)
    entities: typing.List[EntityCreationRequest]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
