# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .entity_id import EntityId
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class BulkConnectedEntity(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import BulkConnectedEntity

    BulkConnectedEntity(
        id="ent_a0f6ea94-0761-4a5e-a416-3c453cb7eced",
        link_created_as_payor=False,
        link_created_as_payee=True,
    )
    """

    id: EntityId = pydantic.Field()
    """
    The ID of the entity to connect to.
    """

    link_created_as_payor: bool = pydantic.Field(alias="linkCreatedAsPayor")
    """
    If true, the created entities will be linked to the connected entity as a payor (customer).
    """

    link_created_as_payee: bool = pydantic.Field(alias="linkCreatedAsPayee")
    """
    If true, the created entities will be linked to the connected entity as a payee (vendor).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
