# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .entity_id import EntityId
import pydantic
from ...payment_method_types.types.payment_method_id import PaymentMethodId
from .acceleration_funds_balance_response import AccelerationFundsBalanceResponse
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AccelerationFundsResponse(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_types import (
        AccelerationFundsBalanceResponse,
        AccelerationFundsResponse,
    )

    AccelerationFundsResponse(
        entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
        payment_method_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        available_balance=AccelerationFundsBalanceResponse(
            amount=100.0,
            currency="USD",
        ),
        pending_balance=AccelerationFundsBalanceResponse(
            amount=5.0,
            currency="USD",
        ),
    )
    """

    entity_id: EntityId = pydantic.Field(alias="entityId")
    """
    The ID of the entity that these acceleration funds belong to.
    """

    payment_method_id: PaymentMethodId = pydantic.Field(alias="paymentMethodId")
    """
    The ID of the payment method that the acceleration funds were accessed through.
    """

    available_balance: AccelerationFundsBalanceResponse = pydantic.Field(alias="availableBalance")
    pending_balance: AccelerationFundsBalanceResponse = pydantic.Field(alias="pendingBalance")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
