# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .entity_group_user_entity_response import EntityGroupUserEntityResponse
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityGroupUserResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.entity_group_types import (
        EntityGroupUserEntityResponse,
        EntityGroupUserResponse,
    )

    EntityGroupUserResponse(
        foreign_id="MY-DB-ID-12345",
        email="john.doe@acme.com",
        name="John Doe",
        entities=[
            EntityGroupUserEntityResponse(
                id="user_ec3aafc8-ea86-408a-a6c1-545497badbbb",
                roles=["admin", "approver"],
                entity_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
            ),
            EntityGroupUserEntityResponse(
                id="user_3a3aafc8-ea86-408a-a6c1-545497badbbb",
                roles=["viewer"],
                entity_id="ent_9e02a20e-7749-47de-8d8a-f8ff2859fa90",
            ),
        ],
        created_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
        updated_at=datetime.datetime.fromisoformat(
            "2024-01-01 00:00:00+00:00",
        ),
    )
    """

    foreign_id: str = pydantic.Field(alias="foreignId")
    """
    The ID used to identify this user in your system.
    """

    email: typing.Optional[str] = None
    name: typing.Optional[str] = None
    entities: typing.List[EntityGroupUserEntityResponse] = pydantic.Field()
    """
    List of roles per entity.
    """

    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    updated_at: dt.datetime = pydantic.Field(alias="updatedAt")

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
