# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .entity_group_user_entity_request import EntityGroupUserEntityRequest
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityGroupUserRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_group_types import (
        EntityGroupUserEntityRequest,
        EntityGroupUserRequest,
    )

    EntityGroupUserRequest(
        foreign_id="MY-DB-ID-12345",
        email="john.doe@acme.com",
        name="John Doe",
        entities=[
            EntityGroupUserEntityRequest(
                roles=["admin", "approver"],
                entity_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
            ),
            EntityGroupUserEntityRequest(
                roles=["viewer"],
                entity_id="ent_9e02a20e-7749-47de-8d8a-f8ff2859fa90",
            ),
        ],
    )
    """

    foreign_id: str = pydantic.Field(alias="foreignId")
    """
    The ID used to identify this user in your system. This is a required field and needs to be unique for all users in the group.
    """

    email: typing.Optional[str] = None
    name: typing.Optional[str] = None
    entities: typing.Optional[typing.List[EntityGroupUserEntityRequest]] = pydantic.Field(default=None)
    """
    List of roles per entity. By default, the user will have no roles.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
