# This file was auto-generated by Fern from our API Definition.

from .entity_group_update_request import EntityGroupUpdateRequest
import typing
from ...entity_types.types.entity_id import EntityId
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityGroupCreateRequest(EntityGroupUpdateRequest):
    """
    Examples
    --------
    from mercoa.entity_group_types import EntityGroupCreateRequest

    EntityGroupCreateRequest(
        foreign_id="your-group-id",
        name="AcmeConglomerate",
        email_to_name="acmegroup",
        entity_ids=[
            "ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            "ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
        ],
    )
    """

    entity_ids: typing.Optional[typing.List[EntityId]] = pydantic.Field(alias="entityIds", default=None)
    """
    List of entity IDs or foreign IDs
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
