# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
from ...entity_types.types.entity_id import EntityId
import pydantic
from .entity_id_or_boolean import EntityIdOrBoolean
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EntityGroupAddEntitiesRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.entity_group_types import EntityGroupAddEntitiesRequest

    EntityGroupAddEntitiesRequest(
        entity_ids=[
            "ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            "ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
        ],
    )
    """

    entity_ids: typing.List[EntityId] = pydantic.Field(alias="entityIds")
    """
    List of entity IDs or foreign IDs to add to the group
    """

    copy_users_from: typing.Optional[EntityIdOrBoolean] = pydantic.Field(alias="copyUsersFrom", default=None)
    """
    Entity ID / foreign ID of an entity currently in the group to copy users and roles from OR a boolean defining if users should be copied to the new entities.
    
    If not provided or false, users and roles will not be copied.
    If true, users and roles will be copied from the first entity the group.
    If a valid ID is provided, users and roles will be copied from the corresponding provided entity in the group.
    
    Note: If users copied, any preexisting users will be left alone, and users with the same foreign ID will not be copied.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
