# This file was auto-generated by Fern from our API Definition.

import typing
from ...core.client_wrapper import SyncClientWrapper
from .vendor_credit.client import VendorCreditClient
from ...entity_types.types.entity_id import EntityId
from ...entity_types.types.counterparty_network_type import CounterpartyNetworkType
from ...invoice_types.types.metadata_filter import MetadataFilter
from ...core.request_options import RequestOptions
from ...entity_types.types.find_counterparties_response import FindCounterpartiesResponse
from ...core.jsonable_encoder import jsonable_encoder
from json.decoder import JSONDecodeError
from ...core.api_error import ApiError
from ...core.pydantic_utilities import parse_obj_as
from ...commons.errors.bad_request import BadRequest
from ...commons.errors.unauthorized import Unauthorized
from ...commons.errors.forbidden import Forbidden
from ...commons.errors.not_found import NotFound
from ...commons.errors.conflict import Conflict
from ...commons.errors.internal_server_error import InternalServerError
from ...commons.errors.unimplemented import Unimplemented
from ...entity_types.types.entity_add_payees_request import EntityAddPayeesRequest
from ...entity_types.types.entity_hide_payees_request import EntityHidePayeesRequest
from ...entity_types.types.entity_add_payors_request import EntityAddPayorsRequest
from ...entity_types.types.entity_hide_payors_request import EntityHidePayorsRequest
from ...core.client_wrapper import AsyncClientWrapper
from .vendor_credit.client import AsyncVendorCreditClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CounterpartyClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.vendor_credit = VendorCreditClient(client_wrapper=self._client_wrapper)

    def find_payees(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        metadata: typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]] = None,
        return_metadata: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payee counterparties. This endpoint lets you find vendors linked to the entity.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        name : typing.Optional[str]
            Use search instead. Deprecated. Filter counterparties by name. Partial matches are supported.

        search : typing.Optional[str]
            Filter counterparties by name or email. Partial matches are supported.

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids (Foreign ID is supported)

        metadata : typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]]
            Filter counterparties by simple key/value metadata. Each filter will be applied as an AND condition. Duplicate keys will be ignored.

        return_metadata : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            If true, will return simple key/value metadata for the counterparties. For more complex metadata, use the Metadata API.

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        from mercoa import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.find_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            name="Big Box",
            payment_methods=True,
            invoice_metrics=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payees",
            method="GET",
            params={
                "name": name,
                "search": search,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "counterpartyId": counterparty_id,
                "metadata": jsonable_encoder(metadata),
                "returnMetadata": return_metadata,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return typing.cast(
                FindCounterpartiesResponse,
                parse_obj_as(
                    type_=FindCounterpartiesResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def find_payors(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        metadata: typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]] = None,
        return_metadata: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payor counterparties. This endpoint lets you find customers linked to the entity.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        name : typing.Optional[str]
            Use search instead. Deprecated. Filter counterparties by name. Partial matches are supported.

        search : typing.Optional[str]
            Filter counterparties by name or email. Partial matches are supported.

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids (Foreign ID is supported)

        metadata : typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]]
            Filter counterparties by simple key/value metadata. Each filter will be applied as an AND condition. Duplicate keys will be ignored.

        return_metadata : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            If true, will return simple key/value metadata for the counterparties. For more complex metadata, use the Metadata API.

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        from mercoa import Mercoa

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.find_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            name="Big Box",
            payment_methods=True,
            invoice_metrics=True,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payors",
            method="GET",
            params={
                "name": name,
                "search": search,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "counterpartyId": counterparty_id,
                "metadata": jsonable_encoder(metadata),
                "returnMetadata": return_metadata,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return typing.cast(
                FindCounterpartiesResponse,
                parse_obj_as(
                    type_=FindCounterpartiesResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def add_payees(
        self,
        entity_id: EntityId,
        *,
        request: EntityAddPayeesRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payees. If a Payee has previously been archived, unarchive the Payee.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityAddPayeesRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import Mercoa
        from mercoa.entity_types import (
            CounterpartyCustomizationAccount,
            CounterpartyCustomizationRequest,
            EntityAddPayeesRequest,
        )

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.add_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            request=EntityAddPayeesRequest(
                payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
                customizations=[
                    CounterpartyCustomizationRequest(
                        counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                        accounts=[
                            CounterpartyCustomizationAccount(
                                account_id="85866843",
                                postal_code="94105",
                                name_on_account="John Doe",
                            )
                        ],
                    )
                ],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayees",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def hide_payees(
        self,
        entity_id: EntityId,
        *,
        request: EntityHidePayeesRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payees as unsearchable by Entity via Counterparty search. Invoices associated with these Payees will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityHidePayeesRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import Mercoa
        from mercoa.entity_types import EntityHidePayeesRequest

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.hide_payees(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            request=EntityHidePayeesRequest(
                payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayees",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def add_payors(
        self,
        entity_id: EntityId,
        *,
        request: EntityAddPayorsRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payors. If a Payor has previously been archived, unarchive the Payor.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityAddPayorsRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import Mercoa
        from mercoa.entity_types import (
            CounterpartyCustomizationAccount,
            CounterpartyCustomizationRequest,
            EntityAddPayorsRequest,
        )

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.add_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            request=EntityAddPayorsRequest(
                payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
                customizations=[
                    CounterpartyCustomizationRequest(
                        counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                        accounts=[
                            CounterpartyCustomizationAccount(
                                account_id="85866843",
                                postal_code="94105",
                                name_on_account="John Doe",
                            )
                        ],
                    )
                ],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayors",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def hide_payors(
        self,
        entity_id: EntityId,
        *,
        request: EntityHidePayorsRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payors as unsearchable by Entity via Counterparty search. Invoices associated with these Payors will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityHidePayorsRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from mercoa import Mercoa
        from mercoa.entity_types import EntityHidePayorsRequest

        client = Mercoa(
            token="YOUR_TOKEN",
        )
        client.entity.counterparty.hide_payors(
            entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
            request=EntityHidePayorsRequest(
                payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
            ),
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayors",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncCounterpartyClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper
        self.vendor_credit = AsyncVendorCreditClient(client_wrapper=self._client_wrapper)

    async def find_payees(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        metadata: typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]] = None,
        return_metadata: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payee counterparties. This endpoint lets you find vendors linked to the entity.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        name : typing.Optional[str]
            Use search instead. Deprecated. Filter counterparties by name. Partial matches are supported.

        search : typing.Optional[str]
            Filter counterparties by name or email. Partial matches are supported.

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids (Foreign ID is supported)

        metadata : typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]]
            Filter counterparties by simple key/value metadata. Each filter will be applied as an AND condition. Duplicate keys will be ignored.

        return_metadata : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            If true, will return simple key/value metadata for the counterparties. For more complex metadata, use the Metadata API.

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        import asyncio

        from mercoa import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.entity.counterparty.find_payees(
                entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                name="Big Box",
                payment_methods=True,
                invoice_metrics=True,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payees",
            method="GET",
            params={
                "name": name,
                "search": search,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "counterpartyId": counterparty_id,
                "metadata": jsonable_encoder(metadata),
                "returnMetadata": return_metadata,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return typing.cast(
                FindCounterpartiesResponse,
                parse_obj_as(
                    type_=FindCounterpartiesResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def find_payors(
        self,
        entity_id: EntityId,
        *,
        name: typing.Optional[str] = None,
        search: typing.Optional[str] = None,
        network_type: typing.Optional[
            typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]
        ] = None,
        payment_methods: typing.Optional[bool] = None,
        invoice_metrics: typing.Optional[bool] = None,
        counterparty_id: typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]] = None,
        metadata: typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]] = None,
        return_metadata: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        limit: typing.Optional[int] = None,
        starting_after: typing.Optional[EntityId] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FindCounterpartiesResponse:
        """
        Find payor counterparties. This endpoint lets you find customers linked to the entity.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        name : typing.Optional[str]
            Use search instead. Deprecated. Filter counterparties by name. Partial matches are supported.

        search : typing.Optional[str]
            Filter counterparties by name or email. Partial matches are supported.

        network_type : typing.Optional[typing.Union[CounterpartyNetworkType, typing.Sequence[CounterpartyNetworkType]]]
            Filter by network type. By default, only ENTITY counterparties are returned.

        payment_methods : typing.Optional[bool]
            If true, will include counterparty payment methods as part of the response

        invoice_metrics : typing.Optional[bool]
            If true, will include counterparty invoice metrics as part of the response

        counterparty_id : typing.Optional[typing.Union[EntityId, typing.Sequence[EntityId]]]
            Filter by counterparty ids (Foreign ID is supported)

        metadata : typing.Optional[typing.Union[MetadataFilter, typing.Sequence[MetadataFilter]]]
            Filter counterparties by simple key/value metadata. Each filter will be applied as an AND condition. Duplicate keys will be ignored.

        return_metadata : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            If true, will return simple key/value metadata for the counterparties. For more complex metadata, use the Metadata API.

        limit : typing.Optional[int]
            Number of counterparties to return. Limit can range between 1 and 100, and the default is 10.

        starting_after : typing.Optional[EntityId]
            The ID of the counterparties to start after. If not provided, the first page of counterparties will be returned.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FindCounterpartiesResponse

        Examples
        --------
        import asyncio

        from mercoa import AsyncMercoa

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.entity.counterparty.find_payors(
                entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                name="Big Box",
                payment_methods=True,
                invoice_metrics=True,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/counterparties/payors",
            method="GET",
            params={
                "name": name,
                "search": search,
                "networkType": network_type,
                "paymentMethods": payment_methods,
                "invoiceMetrics": invoice_metrics,
                "counterpartyId": counterparty_id,
                "metadata": jsonable_encoder(metadata),
                "returnMetadata": return_metadata,
                "limit": limit,
                "startingAfter": starting_after,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if 200 <= _response.status_code < 300:
            return typing.cast(
                FindCounterpartiesResponse,
                parse_obj_as(
                    type_=FindCounterpartiesResponse,  # type: ignore
                    object_=_response_json,
                ),
            )
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def add_payees(
        self,
        entity_id: EntityId,
        *,
        request: EntityAddPayeesRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payees. If a Payee has previously been archived, unarchive the Payee.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityAddPayeesRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mercoa import AsyncMercoa
        from mercoa.entity_types import (
            CounterpartyCustomizationAccount,
            CounterpartyCustomizationRequest,
            EntityAddPayeesRequest,
        )

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.entity.counterparty.add_payees(
                entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                request=EntityAddPayeesRequest(
                    payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
                    customizations=[
                        CounterpartyCustomizationRequest(
                            counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                            accounts=[
                                CounterpartyCustomizationAccount(
                                    account_id="85866843",
                                    postal_code="94105",
                                    name_on_account="John Doe",
                                )
                            ],
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayees",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def hide_payees(
        self,
        entity_id: EntityId,
        *,
        request: EntityHidePayeesRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payees as unsearchable by Entity via Counterparty search. Invoices associated with these Payees will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityHidePayeesRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mercoa import AsyncMercoa
        from mercoa.entity_types import EntityHidePayeesRequest

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.entity.counterparty.hide_payees(
                entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                request=EntityHidePayeesRequest(
                    payees=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayees",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def add_payors(
        self,
        entity_id: EntityId,
        *,
        request: EntityAddPayorsRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Create association between Entity and a given list of Payors. If a Payor has previously been archived, unarchive the Payor.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityAddPayorsRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mercoa import AsyncMercoa
        from mercoa.entity_types import (
            CounterpartyCustomizationAccount,
            CounterpartyCustomizationRequest,
            EntityAddPayorsRequest,
        )

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.entity.counterparty.add_payors(
                entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                request=EntityAddPayorsRequest(
                    payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
                    customizations=[
                        CounterpartyCustomizationRequest(
                            counterparty_id="ent_21661ac1-a2a8-4465-a6c0-64474ba8181d",
                            accounts=[
                                CounterpartyCustomizationAccount(
                                    account_id="85866843",
                                    postal_code="94105",
                                    name_on_account="John Doe",
                                )
                            ],
                        )
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/addPayors",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def hide_payors(
        self,
        entity_id: EntityId,
        *,
        request: EntityHidePayorsRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Marks Payors as unsearchable by Entity via Counterparty search. Invoices associated with these Payors will still be searchable via Invoice search.

        Parameters
        ----------
        entity_id : EntityId
            Entity ID or Entity ForeignID

        request : EntityHidePayorsRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from mercoa import AsyncMercoa
        from mercoa.entity_types import EntityHidePayorsRequest

        client = AsyncMercoa(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.entity.counterparty.hide_payors(
                entity_id="ent_8545a84e-a45f-41bf-bdf1-33b42a55812c",
                request=EntityHidePayorsRequest(
                    payors=["ent_21661ac1-a2a8-4465-a6c0-64474ba8181d"],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"entity/{jsonable_encoder(entity_id)}/hidePayors",
            method="POST",
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "BadRequest":
                raise BadRequest(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unauthorized":
                raise Unauthorized(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Forbidden":
                raise Forbidden(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "NotFound":
                raise NotFound(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Conflict":
                raise Conflict(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "InternalServerError":
                raise InternalServerError(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
            if _response_json["errorName"] == "Unimplemented":
                raise Unimplemented(
                    typing.cast(
                        str,
                        parse_obj_as(
                            type_=str,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    )
                )
        raise ApiError(status_code=_response.status_code, body=_response_json)
