# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .email_log_id import EmailLogId
import pydantic
import datetime as dt
import typing
from ...invoice_types.types.invoice_id import InvoiceId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EmailLog(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.email_log_types import EmailLog

    EmailLog(
        id="1234",
        subject="Invoice #1234",
        from_="John Doe <john.doe@example.com>",
        to="Jane Doe <jane.doe@example.com>",
        html_body="<html><body><p>Hi Jane,</p><p>Please find attached the invoice for your recent purchase.</p><p>Thanks,</p><p>John</p></body></html>",
        text_body="Hi Jane,\n\nPlease find attached the invoice for your recent purchase.\n\nThanks,\nJohn",
        created_at=datetime.datetime.fromisoformat(
            "2021-01-01 00:00:00+00:00",
        ),
    )
    """

    id: EmailLogId
    subject: str
    from_: str = pydantic.Field(alias="from")
    to: str
    html_body: str = pydantic.Field(alias="htmlBody")
    text_body: str = pydantic.Field(alias="textBody")
    created_at: dt.datetime = pydantic.Field(alias="createdAt")
    invoice_id: typing.Optional[InvoiceId] = pydantic.Field(alias="invoiceId", default=None)

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
