# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Address(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.commons import Address

    Address(
        address_line_1="123 Main St",
        address_line_2="Unit 1",
        city="San Francisco",
        state_or_province="CA",
        postal_code="94105",
        country="US",
    )
    """

    address_line_1: str = pydantic.Field(alias="addressLine1")
    address_line_2: typing.Optional[str] = pydantic.Field(alias="addressLine2", default=None)
    city: str
    state_or_province: str = pydantic.Field(alias="stateOrProvince")
    """
    State or province code. Must be in the format XX.
    """

    postal_code: str = pydantic.Field(alias="postalCode")
    """
    Postal code. Must be in the format XXXXX or XXXXX-XXXX.
    """

    country: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
