# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import datetime as dt
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class CalculatePaymentTimingResponse(UniversalBaseModel):
    """
    Examples
    --------
    import datetime

    from mercoa.calculate import CalculatePaymentTimingResponse

    CalculatePaymentTimingResponse(
        estimated_processing_date=datetime.datetime.fromisoformat(
            "2024-01-02 00:00:00+00:00",
        ),
        business_days=3,
        estimated_processing_time=3,
        estimated_settlement_date=datetime.datetime.fromisoformat(
            "2024-01-05 00:00:00+00:00",
        ),
    )
    """

    estimated_processing_date: dt.datetime = pydantic.Field(alias="estimatedProcessingDate")
    """
    Estimated date the payment will be or was processed.
    """

    business_days: int = pydantic.Field(alias="businessDays")
    """
    Number of business days between the estimated processing date and the estimated settlement date. This does not take into account bank holidays or weekends.
    """

    estimated_processing_time: int = pydantic.Field(alias="estimatedProcessingTime")
    """
    Estimated payment time in days. This time takes into account bank holidays and weekends.
    """

    estimated_settlement_date: dt.datetime = pydantic.Field(alias="estimatedSettlementDate")
    """
    Estimated date the payment will be or was settled. This is the same as the request's deductionDate plus the paymentTiming.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
