# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from ...payment_method_types.types.currency_code import CurrencyCode
from ...payment_method_types.types.payment_method_id import PaymentMethodId
from ...invoice_types.types.payment_destination_options import PaymentDestinationOptions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CalculateFeesRequest(UniversalBaseModel):
    """
    Examples
    --------
    from mercoa.calculate import CalculateFeesRequest

    CalculateFeesRequest(
        amount=100.0,
        payment_source_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
        payment_destination_id="pm_4794d597-70dc-4fec-b6ec-c5988e759769",
    )
    """

    amount: float = pydantic.Field()
    """
    Total amount in major units. If the entered amount has more decimal places than the currency supports, trailing decimals will be truncated.
    """

    currency: typing.Optional[CurrencyCode] = pydantic.Field(default=None)
    """
    Currency code for the amount. Defaults to USD.
    """

    payment_source_id: PaymentMethodId = pydantic.Field(alias="paymentSourceId")
    """
    ID of payment source.
    """

    payment_destination_id: PaymentMethodId = pydantic.Field(alias="paymentDestinationId")
    """
    ID of payment destination.
    """

    payment_destination_options: typing.Optional[PaymentDestinationOptions] = pydantic.Field(
        alias="paymentDestinationOptions", default=None
    )
    """
    Options for the payment destination. Depending on the payment destination, this may include things such as check delivery method.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
