/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import uk.ac.manchester.cs.owl.owlapi.InternalizedEntities;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplPlain
extends OWLObjectImpl
implements OWLLiteral {
    private final String literal;
    private final OWLDatatype datatype;
    private final String lang;

    public OWLLiteralImplPlain(String literal, @Nullable String lang) {
        this.literal = literal;
        if (lang == null || lang.isEmpty()) {
            this.lang = "";
            this.datatype = InternalizedEntities.XSDSTRING;
        } else {
            this.lang = lang.trim();
            this.datatype = InternalizedEntities.LANGSTRING;
        }
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean hasLang() {
        return !this.lang.isEmpty();
    }

    public boolean isRDFPlainLiteral() {
        return false;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean hasLang(@Nullable String l) {
        if (l == null || l.isEmpty()) {
            return this.lang.isEmpty();
        }
        return this.lang.equalsIgnoreCase(l.trim());
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    protected int hashCode(OWLObject object) {
        return OWLLiteralImplPlain.hash(object.hashIndex(), Stream.of(this.getDatatype(), this.specificHash() * 65536, this.getLang()));
    }

    private int specificHash() {
        try {
            if (this.isInteger()) {
                return this.parseInteger();
            }
            if (this.isDouble()) {
                return (int)this.parseDouble();
            }
            if (this.isFloat()) {
                return (int)this.parseFloat();
            }
            if (this.isBoolean()) {
                return this.parseBoolean() ? 1 : 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.getLiteral().hashCode();
    }
}

