/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdflink;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.http.HttpLib;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdflink.RDFLinkHTTPBuilder;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

class LibRDFLink {
    private static String dftName = "default";

    LibRDFLink() {
    }

    static boolean isDefault(Node name) {
        return name == null || Quad.isDefaultGraph((Node)name);
    }

    private static String queryStringForGraph(String ch, Node graphName) {
        return ch + (String)(LibRDFLink.isDefault(graphName) ? "default" : "graph=" + LibRDFLink.encode(graphName));
    }

    private static String encode(Node node) {
        return HttpLib.urlEncodeQueryString((String)node.getURI());
    }

    static String urlForGraph(String graphStoreProtocolService, Node graphName) {
        String ch = "?";
        if (graphStoreProtocolService.contains("?")) {
            ch = "&";
        }
        return graphStoreProtocolService + LibRDFLink.queryStringForGraph(ch, graphName);
    }

    static Model graph2model(Graph graph) {
        return ModelFactory.createModelForGraph((Graph)graph);
    }

    static Graph model2graph(Model model) {
        return model.getGraph();
    }

    static Dataset asDataset(DatasetGraph dsg) {
        return DatasetFactory.wrap((DatasetGraph)dsg);
    }

    static DatasetGraph asDatasetGraph(Dataset dataset) {
        return dataset.asDatasetGraph();
    }

    static Node name(String graphName) {
        if (graphName == null || graphName.equals("default")) {
            return Quad.defaultGraphIRI;
        }
        return NodeFactory.createURI((String)graphName);
    }

    static String formServiceURL(String destination, String srvEndpoint) {
        if (srvEndpoint == null) {
            return null;
        }
        if (srvEndpoint == RDFLinkHTTPBuilder.SameAsDestination) {
            return destination;
        }
        if (destination == null) {
            return srvEndpoint;
        }
        if (srvEndpoint.startsWith("http:/") || srvEndpoint.startsWith("https:/")) {
            return srvEndpoint;
        }
        String queryString = null;
        Object dest = destination;
        if (destination.contains("?")) {
            int i = destination.indexOf(63);
            queryString = destination.substring(i);
            dest = destination.substring(0, i);
        }
        if (((String)dest).endsWith("/")) {
            dest = ((String)dest).substring(0, ((String)dest).length() - 1);
        }
        dest = (String)dest + "/" + srvEndpoint;
        if (queryString != null) {
            dest = (String)dest + queryString;
        }
        return dest;
    }
}

