/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.AStarAdmissibleHeuristic;
import org.jgrapht.alg.shortestpath.BaseShortestPathAlgorithm;
import org.jgrapht.alg.util.ToleranceDoubleComparator;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.util.FibonacciHeap;
import org.jgrapht.util.FibonacciHeapNode;

public class AStarShortestPath<V, E>
extends BaseShortestPathAlgorithm<V, E> {
    protected FibonacciHeap<V> openList;
    protected Map<V, FibonacciHeapNode<V>> vertexToHeapNodeMap;
    protected Set<V> closedList;
    protected Map<V, Double> gScoreMap;
    protected Map<V, E> cameFrom;
    protected AStarAdmissibleHeuristic<V> admissibleHeuristic;
    protected int numberOfExpandedNodes;
    protected Comparator<Double> comparator;

    public AStarShortestPath(Graph<V, E> graph, AStarAdmissibleHeuristic<V> admissibleHeuristic) {
        super(graph);
        this.admissibleHeuristic = Objects.requireNonNull(admissibleHeuristic, "Heuristic function cannot be null!");
        this.comparator = new ToleranceDoubleComparator();
    }

    private void initialize(AStarAdmissibleHeuristic<V> admissibleHeuristic) {
        this.admissibleHeuristic = admissibleHeuristic;
        this.openList = new FibonacciHeap();
        this.vertexToHeapNodeMap = new HashMap<V, FibonacciHeapNode<V>>();
        this.closedList = new HashSet<V>();
        this.gScoreMap = new HashMap<V, Double>();
        this.cameFrom = new HashMap<V, E>();
        this.numberOfExpandedNodes = 0;
    }

    @Override
    public GraphPath<V, E> getPath(V sourceVertex, V targetVertex) {
        if (!this.graph.containsVertex(sourceVertex) || !this.graph.containsVertex(targetVertex)) {
            throw new IllegalArgumentException("Source or target vertex not contained in the graph!");
        }
        if (sourceVertex.equals(targetVertex)) {
            return this.createEmptyPath(sourceVertex, targetVertex);
        }
        this.initialize(this.admissibleHeuristic);
        this.gScoreMap.put((Double)sourceVertex, 0.0);
        FibonacciHeapNode<V> heapNode = new FibonacciHeapNode<V>(sourceVertex);
        this.openList.insert(heapNode, 0.0);
        this.vertexToHeapNodeMap.put((FibonacciHeapNode<V>)sourceVertex, (FibonacciHeapNode<FibonacciHeapNode<V>>)heapNode);
        do {
            FibonacciHeapNode<V> currentNode;
            if ((currentNode = this.openList.removeMin()).getData().equals(targetVertex)) {
                return this.buildGraphPath(sourceVertex, targetVertex, currentNode.getKey());
            }
            this.expandNode(currentNode, targetVertex);
            this.closedList.add(currentNode.getData());
        } while (!this.openList.isEmpty());
        return this.createEmptyPath(sourceVertex, targetVertex);
    }

    public int getNumberOfExpandedNodes() {
        return this.numberOfExpandedNodes;
    }

    public boolean isConsistentHeuristic(AStarAdmissibleHeuristic<V> admissibleHeuristic) {
        for (Object targetVertex : this.graph.vertexSet()) {
            for (Object e : this.graph.edgeSet()) {
                double h_y;
                double weight = this.graph.getEdgeWeight(e);
                Object edgeSource = this.graph.getEdgeSource(e);
                Object edgeTarget = this.graph.getEdgeTarget(e);
                double h_x = admissibleHeuristic.getCostEstimate(edgeSource, targetVertex);
                if (!(h_x > weight + (h_y = admissibleHeuristic.getCostEstimate(edgeTarget, targetVertex)))) continue;
                return false;
            }
        }
        return true;
    }

    private void expandNode(FibonacciHeapNode<V> currentNode, V endVertex) {
        ++this.numberOfExpandedNodes;
        Set outgoingEdges = this.graph.outgoingEdgesOf(currentNode.getData());
        for (Object edge : outgoingEdges) {
            V successor = Graphs.getOppositeVertex(this.graph, edge, currentNode.getData());
            if (successor.equals(currentNode.getData())) continue;
            double gScore_current = this.gScoreMap.get(currentNode.getData());
            double tentativeGScore = gScore_current + this.graph.getEdgeWeight(edge);
            double fScore = tentativeGScore + this.admissibleHeuristic.getCostEstimate(successor, endVertex);
            if (this.vertexToHeapNodeMap.containsKey(successor)) {
                if (tentativeGScore >= this.gScoreMap.get(successor)) continue;
                this.cameFrom.put(successor, edge);
                this.gScoreMap.put((Double)successor, tentativeGScore);
                if (this.closedList.contains(successor)) {
                    this.closedList.remove(successor);
                    this.openList.insert(this.vertexToHeapNodeMap.get(successor), fScore);
                    continue;
                }
                this.openList.decreaseKey(this.vertexToHeapNodeMap.get(successor), fScore);
                continue;
            }
            this.cameFrom.put(successor, edge);
            this.gScoreMap.put((Double)successor, tentativeGScore);
            FibonacciHeapNode<V> heapNode = new FibonacciHeapNode<V>(successor);
            this.openList.insert(heapNode, fScore);
            this.vertexToHeapNodeMap.put((FibonacciHeapNode<V>)successor, (FibonacciHeapNode<FibonacciHeapNode<V>>)heapNode);
        }
    }

    private GraphPath<V, E> buildGraphPath(V startVertex, V targetVertex, double pathLength) {
        ArrayList<E> edgeList = new ArrayList<E>();
        ArrayList<V> vertexList = new ArrayList<V>();
        vertexList.add(targetVertex);
        V v = targetVertex;
        while (!v.equals(startVertex)) {
            edgeList.add(this.cameFrom.get(v));
            v = Graphs.getOppositeVertex(this.graph, this.cameFrom.get(v), v);
            vertexList.add(v);
        }
        Collections.reverse(edgeList);
        Collections.reverse(vertexList);
        return new GraphWalk(this.graph, startVertex, targetVertex, vertexList, edgeList, pathLength);
    }
}

