/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.MultiComparator;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.text.UnicodeSetIterator;
import com.ibm.icu.util.LocaleData;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlphabeticIndex<V>
implements Iterable<Bucket<V>> {
    static final boolean HACK_CODED_FIRSTS = true;
    private static UnicodeSet UNIHAN = new UnicodeSet("[:script=Hani:]");
    private static final char CGJ = '\u034f';
    private static final UnicodeSet ALPHABETIC = new UnicodeSet("[[:alphabetic:]-[:mark:]]");
    private static final UnicodeSet HANGUL = new UnicodeSet("[\uac00 \ub098 \ub2e4 \ub77c \ub9c8 \ubc14  \uc0ac  \uc544 \uc790  \ucc28 \uce74 \ud0c0 \ud30c \ud558]");
    private static final UnicodeSet ETHIOPIC = new UnicodeSet("[[:Block=Ethiopic:]&[:Script=Ethiopic:]]");
    private static final UnicodeSet CORE_LATIN = new UnicodeSet("[a-z]");
    private final RuleBasedCollator collatorOriginal;
    private final RuleBasedCollator collatorPrimaryOnly;
    private RuleBasedCollator collatorExternal;
    private final LinkedHashMap<String, Set<String>> alreadyIn = new LinkedHashMap();
    private final List<String> noDistinctSorting = new ArrayList<String>();
    private final List<String> notAlphabetic = new ArrayList<String>();
    private final UnicodeSet initialLabels = new UnicodeSet();
    private final Collection<Record<V>> inputList = new ArrayList<Record<V>>();
    private BucketList buckets;
    private String overflowLabel = "\u2026";
    private String underflowLabel = "\u2026";
    private String inflowLabel = "\u2026";
    private LangType langType;
    private static final UnicodeSet IGNORE_SCRIPTS = new UnicodeSet("[[:sc=Common:][:sc=inherited:][:script=Unknown:][:script=braille:]]").freeze();
    private static final PreferenceComparator PREFERENCE_COMPARATOR = new PreferenceComparator();
    private int maxLabelCount = 99;
    private static String PINYIN_LOWER_BOUNDS;
    private static String[] HACK_PINYIN_LOOKUP;
    private int probeCharInLong = 167597;
    private static String PINYIN_LOWER_BOUNDS_LONG;
    private static String[] HACK_PINYIN_LOOKUP_LONG;
    private static String PINYIN_LOWER_BOUNDS_SHORT;
    private static String[] HACK_PINYIN_LOOKUP_SHORT;
    private static final List<String> HACK_FIRST_CHARS_IN_SCRIPTS;

    public AlphabeticIndex(ULocale locale) {
        this(locale, null, AlphabeticIndex.getIndexExemplars(locale));
    }

    public AlphabeticIndex(Locale locale) {
        this(ULocale.forLocale(locale));
    }

    public AlphabeticIndex(ULocale locale, RuleBasedCollator collator, UnicodeSet exemplarChars) {
        this.langType = LangType.fromLocale(locale);
        if (this.langType != LangType.NORMAL) {
            locale = locale.setKeywordValue("collation", this.langType == LangType.TRADITIONAL ? "stroke" : "pinyin");
        }
        this.collatorOriginal = collator != null ? collator : (RuleBasedCollator)Collator.getInstance(locale);
        try {
            this.collatorPrimaryOnly = (RuleBasedCollator)this.collatorOriginal.clone();
        }
        catch (Exception e) {
            throw new IllegalStateException("Collator cannot be cloned", e);
        }
        this.collatorPrimaryOnly.setStrength(0);
        this.addLabels(exemplarChars);
    }

    public AlphabeticIndex<V> addLabels(UnicodeSet additions) {
        this.initialLabels.addAll(additions);
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> addLabels(ULocale ... additions) {
        for (ULocale addition : additions) {
            this.initialLabels.addAll(AlphabeticIndex.getIndexExemplars(addition));
        }
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> addLabels(Locale ... additions) {
        for (Locale addition : additions) {
            this.initialLabels.addAll(AlphabeticIndex.getIndexExemplars(ULocale.forLocale(addition)));
        }
        this.buckets = null;
        return this;
    }

    public AlphabeticIndex<V> setOverflowLabel(String overflowLabel) {
        this.overflowLabel = overflowLabel;
        return this;
    }

    public String getUnderflowLabel() {
        return this.underflowLabel;
    }

    public AlphabeticIndex<V> setUnderflowLabel(String underflowLabel) {
        this.underflowLabel = underflowLabel;
        return this;
    }

    public String getOverflowLabel() {
        return this.overflowLabel;
    }

    public AlphabeticIndex<V> setInflowLabel(String inflowLabel) {
        this.inflowLabel = inflowLabel;
        return this;
    }

    public String getInflowLabel() {
        return this.inflowLabel;
    }

    public int getMaxLabelCount() {
        return this.maxLabelCount;
    }

    public AlphabeticIndex<V> setMaxLabelCount(int maxLabelCount) {
        this.maxLabelCount = maxLabelCount;
        return this;
    }

    private ArrayList<String> initLabels() {
        UnicodeSet exemplars = new UnicodeSet(this.initialLabels);
        TreeSet preferenceSorting = new TreeSet(new MultiComparator(this.collatorPrimaryOnly, PREFERENCE_COMPARATOR));
        exemplars.addAllTo(preferenceSorting);
        TreeSet<Object> indexCharacterSet = new TreeSet<Object>(this.collatorPrimaryOnly);
        block0: for (String item : preferenceSorting) {
            if (indexCharacterSet.contains(item)) {
                for (String string : indexCharacterSet) {
                    if (this.collatorPrimaryOnly.compare(item, string) != 0) continue;
                    Set<String> targets = this.alreadyIn.get(string);
                    if (targets == null) {
                        targets = new LinkedHashSet<String>();
                        this.alreadyIn.put(string, targets);
                    }
                    targets.add(item);
                    continue block0;
                }
                continue;
            }
            if (UTF16.countCodePoint(item) > 1 && this.collatorPrimaryOnly.compare(item, this.separated(item)) == 0) {
                this.noDistinctSorting.add(item);
                continue;
            }
            if (!ALPHABETIC.containsSome(item)) {
                this.notAlphabetic.add(item);
                continue;
            }
            indexCharacterSet.add(item);
        }
        int size = indexCharacterSet.size() - 1;
        if (size > this.maxLabelCount) {
            int count = 0;
            int old = -1;
            Iterator<Object> iterator = indexCharacterSet.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                int bump = ++count * this.maxLabelCount / size;
                if (bump == old) {
                    iterator.remove();
                    continue;
                }
                old = bump;
            }
        }
        return new ArrayList<Object>(indexCharacterSet);
    }

    private static UnicodeSet getIndexExemplars(ULocale locale) {
        UnicodeSet exemplars = LocaleData.getExemplarSet(locale, 0, 2);
        if (exemplars != null) {
            return exemplars;
        }
        exemplars = LocaleData.getExemplarSet(locale, 0, 0);
        if ((exemplars = exemplars.cloneAsThawed()).containsSome(CORE_LATIN) || exemplars.size() == 0) {
            exemplars.addAll(CORE_LATIN);
        }
        if (exemplars.containsSome(HANGUL)) {
            exemplars.removeAll(new UnicodeSet("[:block=hangul_syllables:]")).addAll(HANGUL);
        }
        if (exemplars.containsSome(ETHIOPIC)) {
            UnicodeSetIterator it = new UnicodeSetIterator(ETHIOPIC);
            while (it.next()) {
                if ((it.codepoint & 7) == 0) continue;
                exemplars.remove(it.codepoint);
            }
        }
        UnicodeSet uppercased = new UnicodeSet();
        for (String item : exemplars) {
            uppercased.add(UCharacter.toUpperCase(locale, item));
        }
        return uppercased;
    }

    private String separated(String item) {
        StringBuilder result = new StringBuilder();
        char last = item.charAt(0);
        result.append(last);
        for (int i = 1; i < item.length(); ++i) {
            char ch = item.charAt(i);
            if (!UCharacter.isHighSurrogate(last) || !UCharacter.isLowSurrogate(ch)) {
                result.append('\u034f');
            }
            result.append(ch);
            last = ch;
        }
        return result.toString();
    }

    public List<String> getBucketLabels() {
        if (this.buckets == null) {
            this.initBuckets();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Bucket bucket : this.buckets) {
            result.add(bucket.getLabel());
        }
        return result;
    }

    public RuleBasedCollator getCollator() {
        if (this.collatorExternal == null) {
            try {
                this.collatorExternal = (RuleBasedCollator)this.collatorOriginal.clone();
            }
            catch (Exception e) {
                throw new IllegalStateException("Collator cannot be cloned", e);
            }
        }
        return this.collatorExternal;
    }

    public AlphabeticIndex<V> addRecord(CharSequence name, V data) {
        this.buckets = null;
        this.inputList.add(new Record(name, data, this.inputList.size()));
        return this;
    }

    public int getBucketIndex(CharSequence name) {
        String hackPrefix;
        if (this.buckets == null) {
            this.initBuckets();
        }
        if (this.langType == LangType.SIMPLIFIED && (hackPrefix = this.hackName(name, this.collatorPrimaryOnly)) != null) {
            name = hackPrefix + name;
        }
        return this.rawGetBucketIndex(name);
    }

    private int rawGetBucketIndex(CharSequence name) {
        int result = -1;
        for (Bucket bucket : this.buckets) {
            if (bucket.lowerBoundary == null) {
                return result;
            }
            int comp = this.collatorPrimaryOnly.compare(name, (Object)bucket.lowerBoundary);
            if (comp < 0) {
                return result;
            }
            if (comp == 0) {
                return result + 1;
            }
            ++result;
        }
        return result;
    }

    public AlphabeticIndex<V> clearRecords() {
        this.buckets = null;
        this.inputList.clear();
        return this;
    }

    public int getBucketCount() {
        if (this.buckets == null) {
            this.initBuckets();
        }
        return this.buckets.bucketList.size();
    }

    public int getRecordCount() {
        return this.inputList.size();
    }

    @Override
    public Iterator<Bucket<V>> iterator() {
        if (this.buckets == null) {
            this.initBuckets();
        }
        return this.buckets.iterator();
    }

    private void initBuckets() {
        this.buckets = new BucketList();
        Comparator fullComparator = new Comparator<Record<V>>(){

            @Override
            public int compare(Record<V> o1, Record<V> o2) {
                int result = AlphabeticIndex.this.collatorOriginal.compare(o1.name, o2.name);
                if (result != 0) {
                    return result;
                }
                return o1.counter - o2.counter;
            }
        };
        if (this.langType == LangType.SIMPLIFIED) {
            HashMap<String, Bucket> rebucketMap = new HashMap<String, Bucket>();
            for (Record<V> name : this.inputList) {
                String key = this.hackName(((Record)name).name, this.collatorOriginal);
                if (key == null) continue;
                Bucket bucket = (Bucket)rebucketMap.get(key);
                if (bucket == null) {
                    int index = this.rawGetBucketIndex(key);
                    bucket = (Bucket)this.buckets.bucketList.get(index);
                }
                rebucketMap.put(key, bucket);
                ((Record)name).rebucket = bucket;
            }
        }
        TreeSet<Record<V>> sortedInput = new TreeSet<Record<V>>(fullComparator);
        sortedInput.addAll(this.inputList);
        Iterator bucketIterator = this.buckets.iterator();
        Bucket currentBucket = bucketIterator.next();
        Bucket nextBucket = bucketIterator.next();
        String upperBoundary = nextBucket.lowerBoundary;
        boolean atEnd = false;
        for (Record record : sortedInput) {
            if (record.rebucket != null) {
                record.rebucket.records.add(record);
                continue;
            }
            while (!atEnd && this.collatorPrimaryOnly.compare(record.name, (Object)upperBoundary) >= 0) {
                currentBucket = nextBucket;
                if (bucketIterator.hasNext()) {
                    nextBucket = bucketIterator.next();
                    upperBoundary = nextBucket.lowerBoundary;
                    if (upperBoundary != null) continue;
                    atEnd = true;
                    continue;
                }
                atEnd = true;
            }
            currentBucket.records.add(record);
        }
    }

    public String getOverflowComparisonString(String lowerLimit) {
        for (String s : HACK_FIRST_CHARS_IN_SCRIPTS) {
            if (this.collatorPrimaryOnly.compare(s, lowerLimit) <= 0) continue;
            return s;
        }
        return null;
    }

    public List<String> getFirstScriptCharacters() {
        return HACK_FIRST_CHARS_IN_SCRIPTS;
    }

    public Map<String, Set<String>> getAlreadyIn() {
        return this.alreadyIn;
    }

    public List<String> getNoDistinctSorting() {
        return this.noDistinctSorting;
    }

    public List<String> getNotAlphabetic() {
        return this.notAlphabetic;
    }

    private static UnicodeSet getScriptSet(String codePoint) {
        return new UnicodeSet().applyIntPropertyValue(4106, UScript.getScript(codePoint.codePointAt(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hackName(CharSequence name, RuleBasedCollator comparator) {
        if (!UNIHAN.contains(Character.codePointAt(name, 0))) {
            return null;
        }
        String string = PINYIN_LOWER_BOUNDS_LONG;
        synchronized (string) {
            if (PINYIN_LOWER_BOUNDS == null) {
                if (comparator.getTailoredSet().contains(this.probeCharInLong)) {
                    PINYIN_LOWER_BOUNDS = PINYIN_LOWER_BOUNDS_LONG;
                    HACK_PINYIN_LOOKUP = HACK_PINYIN_LOOKUP_LONG;
                } else {
                    PINYIN_LOWER_BOUNDS = PINYIN_LOWER_BOUNDS_SHORT;
                    HACK_PINYIN_LOOKUP = HACK_PINYIN_LOOKUP_SHORT;
                }
            }
        }
        int index = Arrays.binarySearch(HACK_PINYIN_LOOKUP, name, comparator);
        if (index < 0) {
            index = -index - 2;
        }
        return PINYIN_LOWER_BOUNDS.substring(index, index + 1);
    }

    public static List<String> getFirstCharactersInScripts() {
        return HACK_FIRST_CHARS_IN_SCRIPTS;
    }

    static {
        PINYIN_LOWER_BOUNDS_LONG = "\u0101bcd\u0113fghjkl\u1e3f\u0144\u014dpqrstwxyz";
        HACK_PINYIN_LOOKUP_LONG = new String[]{"", "\u516b", "\ud863\udead", "\ud844\ude51", "\u59b8", "\u53d1", "\ud844\ude45", "\u54c8", "\u4e0c", "\u5494", "\u3547", "\u5452", "\u5514", "\u5594", "\ud84f\udc7a", "\u4e03", "\u513f", "\u4ee8", "\u4ed6", "\u7a75", "\u5915", "\u4e2b", "\u5e00"};
        PINYIN_LOWER_BOUNDS_SHORT = "\u0101bcd\u0113fghjkl\u1e3f\u0144\u014dpqrstwxyz";
        HACK_PINYIN_LOOKUP_SHORT = new String[]{"", "\u516b", "\u5693", "\u5491", "\u59b8", "\u53d1", "\u65ee", "\u54c8", "\u4e0c", "\u5494", "\u3547", "\u5452", "\u5514", "\u5594", "\u5991", "\u4e03", "\u513f", "\u4ee8", "\u4ed6", "\u7a75", "\u5915", "\u4e2b", "\u5e00"};
        HACK_FIRST_CHARS_IN_SCRIPTS = Arrays.asList("a", "\u03b1", "\u2c81", "\u0430", "\u2c30", "\u10d0", "\u0561", "\u05d0", "\ud802\udd00", "\u0800", "\u0621", "\u0710", "\u0840", "\u0780", "\u07ca", "\u2d30", "\u1200", "\u0950", "\u0985", "\u0a74", "\u0ad0", "\u0b05", "\u0bd0", "\u0c05", "\u0c85", "\u0d05", "\u0d85", "\uabc0", "\ua800", "\ua882", "\ud804\udc83", "\u1b83", "\ud804\udc05", "\ud802\ude00", "\u0e01", "\u0e81", "\uaa80", "\u0f40", "\u1c00", "\ua840", "\u1900", "\u1700", "\u1720", "\u1740", "\u1760", "\u1a00", "\u1bc0", "\ua930", "\ua90a", "\u1000", "\u1780", "\u1950", "\u1980", "\u1a20", "\uaa00", "\u1b05", "\ua984", "\u1880", "\u1c5a", "\u13a0", "\u1401", "\u1681", "\u16a0", "\ud803\udc00", "\ua500", "\ua6a0", "\u1100", "\u3041", "\u30a1", "\u3105", "\ua000", "\ua4f8", "\ud800\ude80", "\ud800\udea0", "\ud802\udd20", "\ud800\udf00", "\ud800\udf30", "\ud801\udc28", "\ud801\udc50", "\ud801\udc80", "\ud800\udc00", "\ud802\udc00", "\ud802\ude60", "\ud802\udf00", "\ud802\udc40", "\ud802\udf40", "\ud802\udf60", "\ud800\udf80", "\ud800\udfa0", "\ud808\udc00", "\ud80c\udc00", "\u4e00");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BucketList
    implements Iterable<Bucket<V>> {
        private ArrayList<Bucket<V>> bucketList = new ArrayList();

        BucketList() {
            ArrayList indexCharacters = AlphabeticIndex.this.initLabels();
            this.bucketList.add(new Bucket(AlphabeticIndex.this.getUnderflowLabel(), "", Bucket.LabelType.UNDERFLOW));
            String last = (String)indexCharacters.get(0);
            this.bucketList.add(new Bucket(last, last, Bucket.LabelType.NORMAL));
            UnicodeSet lastSet = AlphabeticIndex.getScriptSet(last).removeAll(IGNORE_SCRIPTS);
            for (int i = 1; i < indexCharacters.size(); ++i) {
                String current = (String)indexCharacters.get(i);
                UnicodeSet set = AlphabeticIndex.getScriptSet(current).removeAll(IGNORE_SCRIPTS);
                if (lastSet.containsNone(set)) {
                    String overflowComparisonString = AlphabeticIndex.this.getOverflowComparisonString(last);
                    if (AlphabeticIndex.this.collatorPrimaryOnly.compare(overflowComparisonString, current) < 0) {
                        this.bucketList.add(new Bucket(AlphabeticIndex.this.getInflowLabel(), overflowComparisonString, Bucket.LabelType.INFLOW));
                        ++i;
                        lastSet = set;
                    }
                }
                this.bucketList.add(new Bucket(current, current, Bucket.LabelType.NORMAL));
                last = current;
                lastSet = set;
            }
            String limitString = AlphabeticIndex.this.getOverflowComparisonString(last);
            this.bucketList.add(new Bucket(AlphabeticIndex.this.getOverflowLabel(), limitString, Bucket.LabelType.OVERFLOW));
        }

        @Override
        public Iterator<Bucket<V>> iterator() {
            return this.bucketList.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bucket<V>
    implements Iterable<Record<V>> {
        private final String label;
        private final String lowerBoundary;
        private final LabelType labelType;
        private final List<Record<V>> records = new ArrayList<Record<V>>();

        private Bucket(String label, String lowerBoundary, LabelType labelType) {
            this.label = label;
            this.lowerBoundary = lowerBoundary;
            this.labelType = labelType;
        }

        public String getLabel() {
            return this.label;
        }

        public LabelType getLabelType() {
            return this.labelType;
        }

        public int size() {
            return this.records.size();
        }

        @Override
        public Iterator<Record<V>> iterator() {
            return this.records.iterator();
        }

        public String toString() {
            return "{labelType=" + (Object)((Object)this.labelType) + ", " + "lowerBoundary=" + this.lowerBoundary + ", " + "label=" + this.label + "}";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum LabelType {
            NORMAL,
            UNDERFLOW,
            INFLOW,
            OVERFLOW;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Record<V> {
        private Bucket<V> rebucket = null;
        private CharSequence name;
        private V data;
        private int counter;

        private Record(CharSequence name, V data, int counter) {
            this.name = name;
            this.data = data;
            this.counter = counter;
        }

        public CharSequence getName() {
            return this.name;
        }

        public V getData() {
            return this.data;
        }

        public String toString() {
            return this.name + "=" + this.data + (this.rebucket == null ? "" : "{" + ((Bucket)this.rebucket).label + "}");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PreferenceComparator
    implements Comparator<Object> {
        static final Comparator<String> binary = new UTF16.StringComparator(true, false, 0);

        private PreferenceComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.compare((String)o1, (String)o2);
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == s2) {
                return 0;
            }
            String n1 = Normalizer.decompose(s1, true);
            String n2 = Normalizer.decompose(s2, true);
            int result = n1.length() - n2.length();
            if (result != 0) {
                return result;
            }
            result = binary.compare(n1, n2);
            if (result != 0) {
                return result;
            }
            return binary.compare(s1, s2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LangType {
        NORMAL,
        SIMPLIFIED,
        TRADITIONAL;


        public static LangType fromLocale(ULocale locale) {
            String lang = locale.getLanguage();
            if (lang.equals("zh")) {
                if ("Hant".equals(locale.getScript()) || "TW".equals(locale.getCountry())) {
                    return TRADITIONAL;
                }
                return SIMPLIFIED;
            }
            return NORMAL;
        }
    }
}

