/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.AbstractBooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShort2BooleanMap;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class Short2BooleanOpenHashMap
extends AbstractShort2BooleanMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient short[] key;
    protected transient boolean[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Short2BooleanMap.FastEntrySet entries;
    protected volatile transient ShortSet keys;
    protected volatile transient BooleanCollection values;

    public Short2BooleanOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new short[this.n];
        this.value = new boolean[this.n];
        this.used = new boolean[this.n];
    }

    public Short2BooleanOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Short2BooleanOpenHashMap() {
        this(16, 0.75f);
    }

    public Short2BooleanOpenHashMap(Map<? extends Short, ? extends Boolean> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Short2BooleanOpenHashMap(Map<? extends Short, ? extends Boolean> m) {
        this(m, 0.75f);
    }

    public Short2BooleanOpenHashMap(Short2BooleanMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Short2BooleanOpenHashMap(Short2BooleanMap m) {
        this(m, 0.75f);
    }

    public Short2BooleanOpenHashMap(short[] k, boolean[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Short2BooleanOpenHashMap(short[] k, boolean[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public boolean put(short k, boolean v) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                boolean oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Boolean put(Short ok, Boolean ov) {
        boolean v = ov;
        short k = ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Boolean oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos] ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public boolean remove(short k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                boolean v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Boolean remove(Object ok) {
        short k = (Short)ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                boolean v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public Boolean get(Short ok) {
        short k = ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public boolean get(short k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(short k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(boolean v) {
        boolean[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Short2BooleanMap.FastEntrySet short2BooleanEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ShortSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public BooleanCollection values() {
        if (this.values == null) {
            this.values = new AbstractBooleanCollection(){

                @Override
                public BooleanIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Short2BooleanOpenHashMap.this.size;
                }

                @Override
                public boolean contains(boolean v) {
                    return Short2BooleanOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Short2BooleanOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        short[] key = this.key;
        boolean[] value = this.value;
        int mask = newN - 1;
        short[] newKey = new short[newN];
        boolean[] newValue = new boolean[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            short k = key[i];
            int pos = HashCommon.murmurHash3(k ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Short2BooleanOpenHashMap clone() {
        Short2BooleanOpenHashMap c;
        try {
            c = (Short2BooleanOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (short[])this.key.clone();
        c.value = (boolean[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= this.value[i] ? 1231 : 1237);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        short[] key = this.key;
        boolean[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeShort(key[e]);
            s.writeBoolean(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new short[this.n];
        short[] key = this.key;
        this.value = new boolean[this.n];
        boolean[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            short k = s.readShort();
            boolean v = s.readBoolean();
            pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements BooleanIterator {
        @Override
        public boolean nextBoolean() {
            return Short2BooleanOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Boolean next() {
            return Short2BooleanOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractShortSet {
        private KeySet() {
        }

        @Override
        public ShortIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Short2BooleanOpenHashMap.this.size;
        }

        @Override
        public boolean contains(short k) {
            return Short2BooleanOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(short k) {
            int oldSize = Short2BooleanOpenHashMap.this.size;
            Short2BooleanOpenHashMap.this.remove(k);
            return Short2BooleanOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Short2BooleanOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ShortIterator {
        @Override
        public short nextShort() {
            return Short2BooleanOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Short next() {
            return Short2BooleanOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Short2BooleanMap.Entry>
    implements Short2BooleanMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Short2BooleanMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Short2BooleanMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            int pos = HashCommon.murmurHash3(k ^ Short2BooleanOpenHashMap.this.mask) & Short2BooleanOpenHashMap.this.mask;
            while (Short2BooleanOpenHashMap.this.used[pos]) {
                if (Short2BooleanOpenHashMap.this.key[pos] == k) {
                    return Short2BooleanOpenHashMap.this.value[pos] == (Boolean)e.getValue();
                }
                pos = pos + 1 & Short2BooleanOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            int pos = HashCommon.murmurHash3(k ^ Short2BooleanOpenHashMap.this.mask) & Short2BooleanOpenHashMap.this.mask;
            while (Short2BooleanOpenHashMap.this.used[pos]) {
                if (Short2BooleanOpenHashMap.this.key[pos] == k) {
                    Short2BooleanOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Short2BooleanOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Short2BooleanOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Short2BooleanOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Short2BooleanMap.Entry> {
        final AbstractShort2BooleanMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractShort2BooleanMap.BasicEntry(0, false);
        }

        @Override
        public AbstractShort2BooleanMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Short2BooleanOpenHashMap.this.key[e];
            this.entry.value = Short2BooleanOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Short2BooleanMap.Entry> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Short2BooleanMap.Entry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        ShortArrayList wrapped;

        private MapIterator() {
            this.pos = Short2BooleanOpenHashMap.this.n;
            this.last = -1;
            this.c = Short2BooleanOpenHashMap.this.size;
            boolean[] used = Short2BooleanOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                short k = this.wrapped.getShort(-this.pos - 2);
                int pos = HashCommon.murmurHash3(k ^ Short2BooleanOpenHashMap.this.mask) & Short2BooleanOpenHashMap.this.mask;
                while (Short2BooleanOpenHashMap.this.used[pos]) {
                    if (Short2BooleanOpenHashMap.this.key[pos] == k) {
                        return pos;
                    }
                    pos = pos + 1 & Short2BooleanOpenHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Short2BooleanOpenHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Short2BooleanOpenHashMap.this.mask;
                while (Short2BooleanOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Short2BooleanOpenHashMap.this.key[pos] ^ Short2BooleanOpenHashMap.this.mask) & Short2BooleanOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Short2BooleanOpenHashMap.this.mask;
                }
                if (!Short2BooleanOpenHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ShortArrayList();
                    }
                    this.wrapped.add(Short2BooleanOpenHashMap.this.key[pos]);
                }
                Short2BooleanOpenHashMap.this.key[last] = Short2BooleanOpenHashMap.this.key[pos];
                Short2BooleanOpenHashMap.this.value[last] = Short2BooleanOpenHashMap.this.value[pos];
            }
            Short2BooleanOpenHashMap.this.used[last] = false;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Short2BooleanOpenHashMap.this.remove(this.wrapped.getShort(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Short2BooleanOpenHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Short2BooleanMap.Entry,
    Map.Entry<Short, Boolean> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Short getKey() {
            return Short2BooleanOpenHashMap.this.key[this.index];
        }

        @Override
        public short getShortKey() {
            return Short2BooleanOpenHashMap.this.key[this.index];
        }

        @Override
        public Boolean getValue() {
            return Short2BooleanOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean getBooleanValue() {
            return Short2BooleanOpenHashMap.this.value[this.index];
        }

        @Override
        public boolean setValue(boolean v) {
            boolean oldValue = Short2BooleanOpenHashMap.this.value[this.index];
            Short2BooleanOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Boolean setValue(Boolean v) {
            return this.setValue((boolean)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Short2BooleanOpenHashMap.this.key[this.index] == (Short)e.getKey() && Short2BooleanOpenHashMap.this.value[this.index] == (Boolean)e.getValue();
        }

        @Override
        public int hashCode() {
            return Short2BooleanOpenHashMap.this.key[this.index] ^ (Short2BooleanOpenHashMap.this.value[this.index] ? 1231 : 1237);
        }

        public String toString() {
            return Short2BooleanOpenHashMap.this.key[this.index] + "=>" + Short2BooleanOpenHashMap.this.value[this.index];
        }
    }
}

