/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.util;

import org.apache.log4j.Logger;

public class MillisecondTimestampFactory {
    private static final Logger log = Logger.getLogger(MillisecondTimestampFactory.class);
    private static long _lastTimestamp = System.currentTimeMillis();
    private static boolean _autoIncMode = false;

    public static synchronized boolean isAutoIncMode() {
        return _autoIncMode;
    }

    private MillisecondTimestampFactory() {
    }

    public static synchronized void setLowerBound(long lowerBound) {
        MillisecondTimestampFactory.assertPositive(lowerBound);
        if (_lastTimestamp < lowerBound) {
            log.warn((Object)"Timestamp factory is being set to an earlier time!");
        } else {
            log.info((Object)("Advancing: lowerBound=" + lowerBound));
        }
        _lastTimestamp = lowerBound;
        _autoIncMode = false;
    }

    private static void assertPositive(long t) {
        if (t <= 0L) {
            throw new IllegalStateException("Timestamp is non-positive: " + t);
        }
    }

    public static synchronized long nextMillis() {
        long timestamp = System.currentTimeMillis();
        if (_autoIncMode) {
            if (timestamp < _lastTimestamp) {
                timestamp = _lastTimestamp + 1L;
                MillisecondTimestampFactory.assertPositive(timestamp);
                _lastTimestamp = timestamp;
                return timestamp;
            }
            _autoIncMode = false;
            log.warn((Object)("Leaving auto-increment mode: time is going forward again: lastTimestamp=" + _lastTimestamp + ", millisTime=" + timestamp));
        }
        assert (!_autoIncMode);
        while (timestamp == _lastTimestamp) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timestamp = System.currentTimeMillis();
        }
        if (timestamp < _lastTimestamp) {
            log.warn((Object)("Entering auto-increment mode : milliseconds go backward: lastTimestamp=" + _lastTimestamp + ", millisTime=" + timestamp));
            _autoIncMode = true;
            return MillisecondTimestampFactory.nextMillis();
        }
        MillisecondTimestampFactory.assertPositive(timestamp);
        _lastTimestamp = timestamp;
        return timestamp;
    }
}

