/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.sparql;

import java.util.ArrayList;
import java.util.List;
import uk.ac.cam.cares.jps.base.query.sparql.PrefixToUrlMap;

public class QueryBuilder {
    private static final String BREAK = "\r\n";
    private static final String POINT = " .\r\n";
    StringBuffer select = null;
    List<String> prefixes = new ArrayList<String>();
    List<StringBuffer> wherestatements = new ArrayList<StringBuffer>();

    public StringBuffer select(String ... varNames) {
        this.select = new StringBuffer("SELECT ");
        for (String current : varNames) {
            this.select.append(current).append(" ");
        }
        return this.select;
    }

    public StringBuffer a(String fromVar, String prefix, String classname) {
        this.addPrefix(prefix);
        StringBuffer b = new StringBuffer(fromVar).append(" a ").append(prefix).append(":").append(classname);
        this.wherestatements.add(b);
        return b;
    }

    public StringBuffer prop(String fromVar, String toVar, String ... path) {
        StringBuffer b = new StringBuffer(fromVar).append(" ");
        for (int i = 0; i < path.length; i += 2) {
            if (i > 0) {
                b.append("/");
            }
            String prefix = path[i];
            this.addPrefix(prefix);
            String property = path[i + 1];
            b.append(prefix).append(":").append(property);
        }
        b.append(" ").append(toVar);
        this.wherestatements.add(b);
        return b;
    }

    private void addPrefix(String prefix) {
        if (!this.prefixes.contains(prefix)) {
            this.prefixes.add(prefix);
        }
    }

    public StringBuffer build() {
        StringBuffer b = new StringBuffer();
        for (String string : this.prefixes) {
            String url = PrefixToUrlMap.getPrefixUrl(string);
            b.append("PREFIX ").append(string).append(":<").append(url).append("> ").append(BREAK);
        }
        b.append(this.select).append(BREAK);
        b.append("WHERE {").append(BREAK);
        for (StringBuffer stringBuffer : this.wherestatements) {
            b.append(stringBuffer).append(POINT);
        }
        b.append("}");
        return b;
    }
}

