/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query.sparql;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.query.sparql.PrefixToUrlMap;

public class JenaModelWrapper {
    private OntModel model = null;
    private String iri = null;
    private String startSubject = null;

    public JenaModelWrapper(OntModel model, String iri) {
        this.model = model;
        this.iri = iri;
    }

    public OntModel getModel() {
        return this.model;
    }

    public RDFNode getPropertyValue(String startSubject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        Property currentProp = null;
        RDFNode currentObject = null;
        int i = 0;
        while (i < path.length - 1) {
            List<RDFNode> objects;
            String prefix;
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            boolean noClassRestriction = true;
            String classAsString = null;
            if (i + 2 < path.length && (prefix = PrefixToUrlMap.getPrefixUrl(path[i + 2])) == null) {
                noClassRestriction = false;
                classAsString = path[i + 2];
            }
            if ((objects = this.listProperyValues(currentSubject, currentProp = this.model.getProperty(propAsString))).isEmpty()) {
                currentObject = null;
                break;
            }
            if (noClassRestriction) {
                currentObject = objects.get(0);
            } else {
                OntClass c = this.model.getOntClass(classAsString);
                for (RDFNode current : objects) {
                    if (!((OntResource)current).hasRDFType(c)) continue;
                    currentObject = current;
                    break;
                }
            }
            if (i < path.length - 2) {
                currentSubject = ((OntResource)currentObject).asIndividual();
            }
            if (noClassRestriction) {
                i += 2;
                continue;
            }
            i += 3;
        }
        return currentObject;
    }

    public RDFNode getPropertyValueWithoutType(String startSubject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        Property currentProp = null;
        RDFNode currentObject = null;
        for (int i = 0; i < path.length; i += 2) {
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            currentProp = this.model.getProperty(propAsString);
            currentObject = currentSubject.getPropertyValue(currentProp);
            if (i >= path.length - 2) continue;
            currentSubject = ((OntResource)currentObject).asIndividual();
        }
        return currentObject;
    }

    public RDFNode setPropertyValue(String startSubject, Object destObject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        OntProperty currentProp = null;
        int i = 0;
        while (i < path.length - 1) {
            RDFNode object;
            String prefix;
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            boolean noClassRestriction = true;
            String classAsString = null;
            if (i + 2 < path.length && (prefix = PrefixToUrlMap.getPrefixUrl(path[i + 2])) == null) {
                noClassRestriction = false;
                classAsString = path[i + 2];
            }
            boolean isObjectProp = true;
            currentProp = this.model.getObjectProperty(propAsString);
            if (currentProp == null) {
                currentProp = this.model.getDatatypeProperty(propAsString);
                isObjectProp = false;
            }
            if (currentProp == null) {
                throw new JPSRuntimeException("property not found, property = " + propAsString);
            }
            if (i < path.length - 2) {
                List<RDFNode> objects = this.listProperyValues(currentSubject, currentProp);
                if (!objects.isEmpty()) {
                    object = null;
                    if (noClassRestriction) {
                        object = objects.get(0);
                    } else {
                        OntClass c = this.model.getOntClass(classAsString);
                        for (RDFNode current : objects) {
                            if (!((OntResource)current).hasRDFType(c)) continue;
                            object = current;
                            break;
                        }
                    }
                    currentSubject = ((OntResource)object).asIndividual();
                } else {
                    RDFNode newObject = this.createObject(currentSubject, currentProp, i, path);
                    currentSubject.setPropertyValue(currentProp, newObject);
                    currentSubject = ((OntResource)newObject).asIndividual();
                }
            } else {
                currentSubject.removeAll(currentProp);
                if (isObjectProp) {
                    if (destObject instanceof Individual) {
                        currentSubject.setPropertyValue(currentProp, (Individual)destObject);
                    } else {
                        OntClass c = currentProp.getRange().asClass();
                        object = c.createIndividual((String)destObject);
                        currentSubject.setPropertyValue(currentProp, object);
                    }
                } else {
                    Literal literal = this.model.createTypedLiteral(destObject);
                    currentSubject.setPropertyValue(currentProp, literal);
                }
            }
            if (noClassRestriction) {
                i += 2;
                continue;
            }
            i += 3;
        }
        return currentSubject.getPropertyValue(currentProp);
    }

    private List<RDFNode> listProperyValues(Individual subject, Property property) {
        ArrayList<RDFNode> result = new ArrayList<RDFNode>();
        NodeIterator it = subject.listPropertyValues(property);
        while (it.hasNext()) {
            RDFNode node = it.nextNode();
            result.add(node);
        }
        return result;
    }

    public RDFNode setPropertyValueWithoutTypes(String startSubject, Object destObject, String ... path) {
        this.startSubject = startSubject;
        Individual currentSubject = this.model.getIndividual(startSubject);
        OntProperty currentProp = null;
        for (int i = 0; i < path.length; i += 2) {
            String propAsString = JenaModelWrapper.concat(path[i], path[i + 1]);
            boolean isObjectProp = true;
            currentProp = this.model.getObjectProperty(propAsString);
            if (currentProp == null) {
                currentProp = this.model.getDatatypeProperty(propAsString);
                isObjectProp = false;
            }
            if (currentProp == null) {
                throw new JPSRuntimeException("property not found, property = " + propAsString);
            }
            if (i < path.length - 2) {
                RDFNode object = currentSubject.getPropertyValue(currentProp);
                if (object != null) {
                    currentSubject = ((OntResource)object).asIndividual();
                    continue;
                }
                object = this.createObject(currentSubject, currentProp, i, path);
                currentSubject.setPropertyValue(currentProp, object);
                currentSubject = ((OntResource)object).asIndividual();
                continue;
            }
            currentSubject.removeAll(currentProp);
            if (isObjectProp) {
                if (destObject instanceof Individual) {
                    currentSubject.setPropertyValue(currentProp, (Individual)destObject);
                    continue;
                }
                OntClass c = currentProp.getRange().asClass();
                Individual object = c.createIndividual((String)destObject);
                currentSubject.setPropertyValue(currentProp, object);
                continue;
            }
            Literal literal = this.model.createTypedLiteral(destObject);
            currentSubject.setPropertyValue(currentProp, literal);
        }
        return currentSubject.getPropertyValue(currentProp);
    }

    private RDFNode createObject(Individual subject, Property prop, int position, String[] path) {
        OntResource range;
        if (position < path.length - 2 && "CLASS".equals(path[position + 2])) {
            String className = JenaModelWrapper.concat(path[position + 3], path[position + 4]);
            OntClass c = this.model.getOntClass(className);
            return c.createIndividual(this.newIri());
        }
        if (position < path.length - 2) {
            String propName = JenaModelWrapper.concat(path[position + 2], path[position + 3]);
            OntResource domain = null;
            ObjectProperty succProp = this.model.getObjectProperty(propName);
            if (succProp != null) {
                domain = succProp.getDomain();
            } else {
                DatatypeProperty succdProp = this.model.getDatatypeProperty(propName);
                domain = succdProp.getDomain();
            }
            if (domain != null) {
                OntClass c = domain.asClass();
                return c.createIndividual(this.newIri());
            }
        }
        if ((range = ((ObjectProperty)prop).getRange()) != null) {
            OntClass c = range.asClass();
            return c.createIndividual(this.newIri());
        }
        return null;
    }

    public static String concat(String prefix, String name) {
        return PrefixToUrlMap.getPrefixUrl(prefix) + name;
    }

    public Individual createIndividual(String prefix, String className) {
        String fullIri = JenaModelWrapper.concat(prefix, className);
        return this.model.getOntClass(fullIri).createIndividual();
    }

    private String newIri() {
        if (this.iri != null) {
            return JenaModelWrapper.newIri(this.iri);
        }
        return JenaModelWrapper.newIri(this.startSubject);
    }

    public static String newIri(String iri) {
        String path = "";
        int i = iri.indexOf("#");
        path = i > 0 ? iri.substring(0, i) + "#" : iri + "#";
        return path + UUID.randomUUID().toString();
    }
}

