/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.query;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.update.UpdateRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.query.LocalStoreClient;

public class FileBasedStoreClient
extends LocalStoreClient {
    private static Logger LOGGER = LogManager.getLogger(FileBasedStoreClient.class);
    private ArrayList<GraphData> namedGraphs = new ArrayList();
    private GraphData defaultGraph = new GraphData();
    private boolean autoWrite = true;

    public FileBasedStoreClient() {
    }

    public FileBasedStoreClient(String filePath) {
        this.load(filePath);
    }

    public FileBasedStoreClient(String graph, String filePath) {
        this.load(graph, filePath);
    }

    public void load() {
        if (this.namedGraphs.size() > 0) {
            for (int i = 0; i < this.namedGraphs.size(); ++i) {
                this.loadGraph(this.namedGraphs.get(i));
            }
        }
        if (this.defaultGraph.path != null) {
            this.loadGraph(this.defaultGraph);
        }
    }

    public void load(String filePath) {
        this.load(null, filePath);
    }

    public void load(String graphName, String filePath) {
        GraphData graph = new GraphData(graphName, filePath);
        File f = new File(graph.path);
        if (f.exists()) {
            this.loadGraph(graph);
        } else {
            Lang lang;
            graph.lang = lang = RDFLanguages.filenameToLang(graph.path);
            LOGGER.info(filePath + " does not exist. Creating empty FileBasedStoreClient. File language set to: " + lang);
        }
        if (graph != null) {
            if (graph.name == null) {
                this.defaultGraph = graph;
            } else {
                this.namedGraphs.add(graph);
            }
        }
    }

    public void load(String[] names, String[] filePaths) {
        if (names.length == filePaths.length) {
            for (int i = 0; i < names.length; ++i) {
                this.load(names[i], filePaths[i]);
            }
        } else {
            throw new JPSRuntimeException("FileBasedStoreClient: file path or graph name missing (graphs.length != flePaths.length).");
        }
    }

    private void loadGraph(GraphData graph) {
        File f;
        if (!this.isConnected()) {
            this.init();
        }
        if ((f = new File(graph.path)).exists()) {
            LOGGER.info("Load graph: " + graph.name + " , path=" + graph.path);
            Lang lang = RDFLanguages.filenameToLang(graph.path);
            LOGGER.info("File language is: " + lang);
            graph.lang = lang;
            if (RDFLanguages.isTriples(lang)) {
                if (graph.name == null) {
                    if (!this.dataset.getDefaultModel().isEmpty()) {
                        throw new JPSRuntimeException("FileBasedStoreClient: default graph already exists!");
                    }
                } else if (this.dataset.containsNamedModel(graph.name)) {
                    throw new JPSRuntimeException("FileBasedStoreClient: " + graph.name + " already exists!");
                }
                this.conn.load(graph.name, graph.path);
            } else {
                Dataset tempDataset = RDFDataMgr.loadDataset(graph.path);
                Iterator<String> it = tempDataset.listNames();
                int contextCount = 0;
                while (it.hasNext()) {
                    if (++contextCount > 1) {
                        throw new JPSRuntimeException("FileBasedStoreClient: multiple contexts in file not supported!");
                    }
                    String context = it.next();
                    if (context == null) {
                        if (!this.dataset.getDefaultModel().isEmpty()) {
                            throw new JPSRuntimeException("FileBasedStoreClient: default graph already exists!");
                        }
                    } else if (this.dataset.containsNamedModel(context)) {
                        throw new JPSRuntimeException("FileBasedStoreClient: " + context + " already exists!");
                    }
                    if (context.equals(graph.name)) continue;
                    LOGGER.info(graph.name + " changed to " + context);
                    graph.name = context;
                }
                this.conn.loadDataset(tempDataset);
                tempDataset.asDatasetGraph().clear();
                tempDataset.close();
            }
        } else {
            throw new JPSRuntimeException("FileBasedStoreClient: cannot load " + graph.path + ". File does not exist.");
        }
    }

    public void end() {
        this.writeToFile();
        this.conn.close();
        this.dataset.close();
    }

    public void writeToFile() {
        if (this.namedGraphs.size() > 0) {
            for (int i = 0; i < this.namedGraphs.size(); ++i) {
                this.writeToFile(this.namedGraphs.get(i));
            }
        }
        if (this.defaultGraph.path != null) {
            this.writeToFile(this.defaultGraph);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeToFile(String graphName) {
        if (graphName == null || graphName.equals("default")) {
            if (this.defaultGraph.path == null && this.defaultGraph.lang == null) throw new JPSRuntimeException("FileBasedStoreClient: no file path.");
            this.writeToFile(this.defaultGraph);
            return;
        } else {
            GraphData graph = this.getGraph(graphName);
            if (graph == null) throw new JPSRuntimeException("FileBasedStoreClient: graph not found.");
            this.writeToFile(graph);
        }
    }

    public void writeToFile(String filePath, Lang langOut) {
        this.writeToFile(null, filePath, langOut);
    }

    private void writeToFile(GraphData graph) {
        this.writeToFile(graph.name, graph.path, graph.lang);
    }

    public void writeToFile(String name, String filePath, Lang langOut) {
        block11: {
            LOGGER.info("Writing to file");
            try (FileOutputStream out = new FileOutputStream(filePath);){
                if (name == null || name.equals("default")) {
                    RDFDataMgr.write((OutputStream)out, this.dataset.getDefaultModel(), langOut);
                    out.flush();
                    LOGGER.info("Default graph written to: " + filePath + ". Lang: " + langOut.getName());
                    break block11;
                }
                if (this.dataset.containsNamedModel(name)) {
                    if (RDFLanguages.isTriples(langOut)) {
                        RDFDataMgr.write((OutputStream)out, this.dataset.getNamedModel(name), langOut);
                    } else {
                        Dataset datasetOut = DatasetFactory.create();
                        datasetOut.addNamedModel(name, this.dataset.getNamedModel(name));
                        RDFDataMgr.write((OutputStream)out, datasetOut, langOut);
                    }
                    out.flush();
                    LOGGER.info("Named graph" + name + " written to: " + filePath + ". Lang: " + langOut.getName());
                    break block11;
                }
                throw new JPSRuntimeException("FileBasedStoreClient: " + name + " does not exist.");
            }
            catch (IOException e) {
                throw new JPSRuntimeException(e);
            }
        }
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public void setUser(String userName) {
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public void setPassword(String password) {
    }

    private GraphData getGraph(String name) {
        if (name == null || name.equals("default")) {
            return this.defaultGraph;
        }
        for (int i = 0; i < this.namedGraphs.size(); ++i) {
            if (!this.namedGraphs.get((int)i).name.equals(name)) continue;
            return this.namedGraphs.get(i);
        }
        return null;
    }

    public boolean containsGraph(String name) {
        GraphData graph = this.getGraph(name);
        if (graph != null) {
            return this.dataset.containsNamedModel(name);
        }
        return false;
    }

    public List<String> getGraphNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.namedGraphs.size(); ++i) {
            names.add(this.namedGraphs.get((int)i).name);
        }
        return names;
    }

    public Lang getLang(String name) {
        GraphData graph = this.getGraph(name);
        return graph.lang;
    }

    public String getPath(String name) {
        GraphData graph = this.getGraph(name);
        return graph.path;
    }

    public void setAutoWrite(boolean value) {
        LOGGER.info("Set AutoWrite=" + value);
        this.autoWrite = value;
    }

    public void setOutputLang(Lang langOut) {
        this.defaultGraph.lang = langOut;
    }

    public void setOutputLang(String name, Lang langOut) {
        GraphData graph = this.getGraph(name);
        if (graph != null) {
            graph.lang = langOut;
        }
    }

    @Override
    public String setQuery(String query) {
        this.query = query;
        return this.query;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public void setPath(String filePath) {
        this.setPath(null, filePath);
    }

    public void setPath(String name, String filePath) {
        GraphData graph = this.getGraph(name);
        if (graph != null) {
            graph.path = filePath;
        }
    }

    @Override
    public String setUpdateEndpoint(String updateEndpoint) {
        this.defaultGraph.path = updateEndpoint;
        return this.defaultGraph.path;
    }

    @Override
    public String getUpdateEndpoint() {
        return this.defaultGraph.path;
    }

    @Override
    public String setQueryEndpoint(String queryEndpoint) {
        this.defaultGraph.path = queryEndpoint;
        return this.defaultGraph.path;
    }

    @Override
    public String getQueryEndpoint() {
        return this.getUpdateEndpoint();
    }

    @Override
    public int executeUpdate(String update) {
        LOGGER.debug("Performing SPARQL UPDATE.");
        if (this.conn != null) {
            int result = super.executeUpdate(update);
            if (this.autoWrite) {
                this.writeToFile();
            }
            return result;
        }
        throw new JPSRuntimeException("FileBasedStoreClient: client not initialised.");
    }

    @Override
    public int executeUpdate(UpdateRequest update) {
        return this.executeUpdate(update.toString());
    }

    @Override
    protected boolean executeAsk(String sparql) {
        LOGGER.debug("Performing SPARQL ASK QUERY.");
        if (this.isEmpty()) {
            this.load();
        }
        if (this.conn != null) {
            return super.executeAsk(sparql);
        }
        throw new JPSRuntimeException("FileBasedStoreClient: client not initialised.");
    }

    @Override
    protected ResultSet executeSelect(String sparql) {
        LOGGER.debug("Performing SPARQL SELECT QUERY.");
        if (this.isEmpty()) {
            this.load();
        }
        if (this.conn != null) {
            return super.executeSelect(sparql);
        }
        throw new JPSRuntimeException("FileBasedStoreClient: client not initialised.");
    }

    @Override
    public Model executeConstruct(String sparql) {
        if (this.isEmpty()) {
            this.load();
        }
        if (this.conn != null) {
            return super.executeConstruct(sparql);
        }
        throw new JPSRuntimeException("FileBasedStoreClient: client not initialised.");
    }

    class GraphData {
        String name = null;
        String path = null;
        Lang lang = Lang.RDFXML;

        GraphData() {
        }

        GraphData(String name, String filePath) {
            this.name = name;
            this.path = filePath;
        }
    }
}

