/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.OBODocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;

public enum Extensions {
    RDFXML(RDFXMLDocumentFormat.class, ".owl", ".rdf", ".rdfs"),
    OWLXML(OWLXMLDocumentFormat.class, ".xml", ".owl", ".rdf"),
    TURTLE(TurtleDocumentFormat.class, ".ttl", ".owl"),
    OBO(OBODocumentFormat.class, ".obo"),
    MANCHESTERSYNTAX(ManchesterSyntaxDocumentFormat.class, ".omn", ".owl"),
    FUNCTIONALSYNTAX(FunctionalSyntaxDocumentFormat.class, ".fss", ".owl");

    private List<String> extensions;
    private Class<? extends OWLDocumentFormat> documentFormat;

    private Extensions(Class<? extends OWLDocumentFormat> d, String ... knownExtensions) {
        this.documentFormat = d;
        this.extensions = Arrays.asList(knownExtensions);
    }

    public static Iterable<String> getCommonExtensions(Class<? extends OWLDocumentFormat> format) {
        for (Extensions e : Extensions.values()) {
            if (!e.documentFormat.equals(format)) continue;
            return e.getCommonExtensions();
        }
        return Collections.emptyList();
    }

    public Iterable<String> getCommonExtensions() {
        return this.extensions;
    }
}

