/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.profiles.OWLProfileViolationVisitor;
import org.semanticweb.owlapi.profiles.OWLProfileViolationVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLProfileViolation {
    protected final OWLOntology ontology;
    protected final OWLDataFactory df;
    @Nullable
    protected final OWLAxiom axiom;
    @Nullable
    protected final Object expression;

    public OWLProfileViolation(OWLOntology ontology, @Nullable OWLAxiom axiom, @Nullable Object o) {
        this.axiom = axiom;
        this.ontology = ontology;
        this.df = ontology.getOWLOntologyManager().getOWLDataFactory();
        this.expression = o;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontology.getOntologyID();
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public Object getExpression() {
        return OWLAPIPreconditions.verifyNotNull(this.expression);
    }

    public OWLAxiom getAxiom() {
        return OWLAPIPreconditions.verifyNotNull(this.axiom);
    }

    public List<OWLOntologyChange> repair() {
        if (this.axiom != null) {
            return this.list(new RemoveAxiom(this.ontology, this.getAxiom()));
        }
        return Collections.emptyList();
    }

    protected AddAxiom addDeclaration(OWLEntity e) {
        return new AddAxiom(this.ontology, this.df.getOWLDeclarationAxiom(e));
    }

    public abstract void accept(OWLProfileViolationVisitor var1);

    public abstract <O> Optional<O> accept(OWLProfileViolationVisitorEx<O> var1);

    protected String toString(String template) {
        return String.format(template + " [%s in %s]", this.axiom, this.ontology.getOntologyID());
    }

    protected String toString(String template, Object object) {
        return String.format(template + " [%s in %s]", object, this.axiom, this.ontology.getOntologyID());
    }

    protected String toString(String template, Object object1, Object object2) {
        return String.format(template + " [%s in %s]", object1, object2, this.axiom, this.ontology.getOntologyID());
    }

    protected List<OWLOntologyChange> list(OWLOntologyChange ... changes) {
        return CollectionFactory.list(changes);
    }
}

