/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model.providers;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

@FunctionalInterface
public interface DataPropertyProvider
extends Serializable {
    public OWLDataProperty getOWLDataProperty(IRI var1);

    default public OWLDataProperty getOWLDataProperty(HasIRI iri) {
        return this.getOWLDataProperty(iri.getIRI());
    }

    default public OWLDataProperty getOWLDataProperty(String iri) {
        return this.getOWLDataProperty(IRI.create(iri));
    }

    default public OWLDataProperty getOWLDataProperty(String namespace, @Nullable String remainder) {
        return this.getOWLDataProperty(IRI.create(namespace, remainder));
    }

    default public OWLDataProperty getOWLDataProperty(String abbreviatedIRI, PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull(abbreviatedIRI, "curi canno be null");
        OWLAPIPreconditions.checkNotNull(prefixManager, "prefixManager cannot be null");
        return this.getOWLDataProperty(prefixManager.getIRI(abbreviatedIRI));
    }
}

