/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.OwlStringTools;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatException;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAPIObo2Owl {
    public static final String IRI_PROP_ISREVERSIBLEPROPERTYCHAIN = "http://purl.obolibrary.org/obo/IAO_isReversiblePropertyChain";
    protected static final Map<String, IRI> ANNOTATIONPROPERTYMAP = OWLAPIObo2Owl.initAnnotationPropertyMap();
    private static final Logger LOG = LoggerFactory.getLogger(OWLAPIObo2Owl.class);
    private static final Set<String> SKIPPED_QUALIFIERS = Sets.newHashSet((Object[])new String[]{"gci_relation", "gci_filler", "cardinality", "minCardinality", "maxCardinality", "all_some", "all_only"});
    protected final Map<String, String> idSpaceMap;
    protected final Set<OWLAnnotationProperty> apToDeclare;
    protected final Map<String, OWLClass> clsToDeclare;
    protected final Map<String, OWLAnnotationProperty> typedefToAnnotationProperty;
    protected String defaultIDSpace = "";
    protected OWLOntologyManager manager;
    protected OWLOntology owlOntology;
    protected OWLDataFactory fac;
    protected OBODoc obodoc;
    private final LoadingCache<String, IRI> idToIRICache = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new CacheLoader<String, IRI>(){

        public IRI load(String key) {
            return OWLAPIObo2Owl.this.loadOboToIRI(key);
        }
    });

    public OWLAPIObo2Owl(OWLOntologyManager manager) {
        this.idSpaceMap = new HashMap<String, String>();
        this.apToDeclare = new HashSet<OWLAnnotationProperty>();
        this.clsToDeclare = new HashMap<String, OWLClass>();
        this.typedefToAnnotationProperty = new HashMap<String, OWLAnnotationProperty>();
        this.init(manager);
    }

    public static void convertURL(String iri, String outFile, OWLOntologyManager manager) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(manager);
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create(outFile);
        RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
        LOG.info("saving to {} fmt={}", (Object)outputStream, (Object)format);
        manager.saveOntology(ontology, (OWLDocumentFormat)format, outputStream);
    }

    public static void convertURL(String iri, String outFile, String defaultOnt, OWLOntologyManager manager) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(manager);
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        obodoc.addDefaultOntologyHeader(defaultOnt);
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create(outFile);
        RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
        LOG.info("saving to {} fmt={}", (Object)outputStream, (Object)format);
        manager.saveOntology(ontology, (OWLDocumentFormat)format, outputStream);
    }

    protected static Map<String, IRI> initAnnotationPropertyMap() {
        HashMap<String, IRI> map = new HashMap<String, IRI>();
        map.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
        map.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        map.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        for (Obo2OWLConstants.Obo2OWLVocabulary vac : Obo2OWLConstants.Obo2OWLVocabulary.values()) {
            map.put(vac.getMappedTag(), vac.getIRI());
        }
        return map;
    }

    protected static String getURI(String path) {
        if (path.startsWith("http://") || path.startsWith("https://") || path.startsWith("file:")) {
            return path;
        }
        File f = new File(path);
        return f.toURI().toString();
    }

    @Nullable
    protected static OWLAxiom trRelationUnionOf(String id, OWLProperty p, Collection<Clause> clauses) {
        LOG.error("The relation union_of for {} is currently non-translatable to OWL. Ignoring clauses: {}", (Object)id, clauses);
        return null;
    }

    @Nullable
    protected static OWLAxiom trRelationIntersectionOf(String id, OWLProperty p, Collection<Clause> clauses) {
        LOG.error("The relation intersection_of for {} is currently non-translatable to OWL. Ignoring clauses: {}", (Object)id, clauses);
        return null;
    }

    protected static String getQVString(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            return qv.getValue();
        }
        return "";
    }

    protected static boolean getQVBoolean(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            String v = qv.getValue();
            return Boolean.parseBoolean(v);
        }
        return false;
    }

    @Nullable
    protected static Integer getQVInt(String q, Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            String v = qv.getValue();
            return Integer.valueOf(v);
        }
        return null;
    }

    protected static String getIdPrefix(String x) {
        String[] parts = x.split(":", 2);
        return parts[0];
    }

    public static IRI trTagToIRI(String tag) {
        IRI iri = ANNOTATIONPROPERTYMAP.get(tag);
        if (iri == null) {
            iri = IRI.create("http://www.geneontology.org/formats/oboInOwl#", tag);
        }
        return iri;
    }

    protected void init(OWLOntologyManager m) {
        this.manager = m;
        this.fac = this.manager.getOWLDataFactory();
        this.idSpaceMap.clear();
        this.apToDeclare.clear();
        this.clsToDeclare.clear();
        this.typedefToAnnotationProperty.clear();
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OBODoc getObodoc() {
        return this.obodoc;
    }

    public void setObodoc(OBODoc obodoc) {
        this.obodoc = obodoc;
    }

    protected OWLOntology getOwlOntology() {
        return OWLAPIPreconditions.verifyNotNull(this.owlOntology);
    }

    protected void setOwlOntology(OWLOntology owlOntology) {
        this.owlOntology = owlOntology;
    }

    public OWLOntology convert(String oboFile) throws OWLOntologyCreationException {
        try {
            OBOFormatParser p = new OBOFormatParser();
            return this.convert(p.parse(oboFile));
        }
        catch (IOException ex) {
            throw new OWLOntologyCreationException("Error Occured while parsing OBO '" + oboFile + '\'', ex);
        }
        catch (OBOFormatParserException ex) {
            throw new OWLOntologyCreationException("Syntax error occured while parsing OBO '" + oboFile + '\'', ex);
        }
    }

    public OWLOntology convert(OBODoc doc) throws OWLOntologyCreationException {
        this.obodoc = doc;
        this.init(this.manager);
        return this.tr(this.manager.createOntology());
    }

    public OWLOntology convert(OBODoc doc, OWLOntology in) {
        this.obodoc = doc;
        this.init(in.getOWLOntologyManager());
        return this.tr(in);
    }

    protected OWLOntology tr(OWLOntology in) {
        this.setOwlOntology(in);
        Frame hf = OWLAPIPreconditions.verifyNotNull(this.obodoc.getHeaderFrame());
        Clause ontClause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY);
        if (ontClause != null) {
            String ontOboId;
            this.defaultIDSpace = ontOboId = (String)ontClause.getValue();
            IRI ontIRI = ontOboId.contains(":") ? IRI.create(ontOboId) : IRI.create("http://purl.obolibrary.org/obo/" + ontOboId + ".owl");
            Clause dvclause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION);
            if (dvclause != null) {
                String dv = dvclause.getValue().toString();
                IRI vIRI = IRI.create("http://purl.obolibrary.org/obo/" + ontOboId + '/' + dv + '/' + ontOboId + ".owl");
                OWLOntologyID oid = new OWLOntologyID(OWLAPIPreconditions.optional(ontIRI), OWLAPIPreconditions.optional(vIRI));
                if (!oid.equals(in.getOntologyID())) {
                    this.manager.applyChange(new SetOntologyID(in, oid));
                }
            } else if (!ontIRI.equals(in.getOntologyID().getOntologyIRI().orElse(null))) {
                this.manager.applyChange(new SetOntologyID(in, new OWLOntologyID(OWLAPIPreconditions.optional(ontIRI), OWLAPIPreconditions.emptyOptional())));
            }
        } else {
            this.defaultIDSpace = "TEMP";
            this.manager.applyChange(new SetOntologyID(in, new OWLOntologyID(OWLAPIPreconditions.optional(IRI.create("http://purl.obolibrary.org/obo/", this.defaultIDSpace)), OWLAPIPreconditions.emptyOptional())));
        }
        this.trHeaderFrame(hf);
        this.obodoc.getTypedefFrames().forEach(this::trTypedefToAnnotationProperty);
        this.obodoc.getTypedefFrames().forEach(this::trTypedefFrame);
        this.obodoc.getTermFrames().forEach(this::trTermFrame);
        for (Clause cl : hf.getClauses(OBOFormatConstants.OboFormatTag.TAG_IMPORT)) {
            String path = OWLAPIObo2Owl.getURI(cl.getValue().toString());
            IRI importIRI = IRI.create(path);
            OWLImportsDeclaration owlImportsDeclaration = this.fac.getOWLImportsDeclaration(importIRI);
            this.manager.makeLoadImportRequest(owlImportsDeclaration, new OWLOntologyLoaderConfiguration());
        }
        this.postProcess(in);
        return in;
    }

    protected void postProcess(OWLOntology ontology) {
        OWLAnnotationProperty p = this.fac.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_LogicalDefinitionViewRelation);
        Optional<String> findAny = ontology.annotations().filter(a -> a.getProperty().equals(p)).map(a -> a.getValue().asLiteral()).filter(Optional::isPresent).map(x -> ((OWLLiteral)x.get()).getLiteral()).findAny();
        if (!findAny.isPresent()) {
            return;
        }
        IRI pIRI = this.oboIdToIRI(findAny.get());
        OWLObjectProperty vp = this.fac.getOWLObjectProperty(pIRI);
        HashSet rmAxioms = new HashSet();
        HashSet newAxioms = new HashSet();
        ontology.axioms(AxiomType.EQUIVALENT_CLASSES).forEach(eca -> {
            AtomicInteger numNamed = new AtomicInteger();
            HashSet xs = new HashSet();
            eca.classExpressions().forEach(x -> {
                if (x instanceof OWLClass) {
                    xs.add(x);
                    numNamed.incrementAndGet();
                } else {
                    xs.add(this.fac.getOWLObjectSomeValuesFrom(vp, (OWLClassExpression)x));
                }
            });
            if (numNamed.get() == 1) {
                rmAxioms.add(eca);
                newAxioms.add(this.fac.getOWLEquivalentClassesAxiom(xs));
            }
        });
        ontology.remove(rmAxioms);
        ontology.add(newAxioms);
    }

    public void trHeaderFrame(Frame headerFrame) {
        for (String t : headerFrame.getTags()) {
            OWLAnnotationProperty parentAnnotProp;
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY || tag == OBOFormatConstants.OboFormatTag.TAG_IMPORT) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(clause.getValue(String.class));
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add(this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag());
                    this.add(this.fac.getOWLAnnotationAssertionAxiom(ap, childAnnotProp.getIRI(), this.trLiteral(clause.getValue2())));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    Object[] values = clause.getValues().toArray();
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(values[0].toString());
                    IRI childIRI = childAnnotProp.getIRI();
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add(this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag());
                    this.add(this.fac.getOWLAnnotationAssertionAxiom(ap, childIRI, this.trLiteral(values[1])));
                    if (values.length <= 2 || values[2].toString().isEmpty()) continue;
                    ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag());
                    this.add(this.fac.getOWLAnnotationAssertionAxiom(ap, childIRI, this.trTagToAnnotationProp(values[2].toString()).getIRI()));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
                this.handleDate(t, headerFrame.getClause(tag));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
                this.addPropertyValueHeaders(headerFrame.getClauses(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_REMARK) {
                headerFrame.getClauses(t).forEach(c -> this.addOntologyAnnotation(this.fac.getRDFSComment(), this.trLiteral(c.getValue()), this.trAnnotations((Clause)c)));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_IDSPACE) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS) {
                headerFrame.getTagValues(tag, String.class).forEach(s -> this.getOwlOntology().add(OwlStringTools.translate(s, this.manager)));
                continue;
            }
            headerFrame.getClauses(t).forEach(c -> this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(c.getValue()), this.trAnnotations((Clause)c)));
        }
    }

    protected void handleDate(String t, @Nullable Clause clause) {
        if (clause != null) {
            Object value = clause.getValue();
            String dateString = null;
            if (value instanceof Date) {
                dateString = OBOFormatConstants.headerDateFormat().format((Date)value);
            } else if (value instanceof String) {
                dateString = (String)value;
            }
            if (dateString != null) {
                this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(dateString), this.trAnnotations(clause));
            } else {
                OBOFormatException e = new OBOFormatException("Cannot translate clause \u00ab" + clause + '\u00bb');
                LOG.error("Cannot translate: {}", (Object)clause, (Object)e);
            }
        }
    }

    protected void addPropertyValueHeaders(Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            Set<OWLAnnotation> annotations = this.trAnnotations(clause);
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (values.size() == 2) {
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                IRI value = this.trAnnotationProp(v2.toString()).getIRI();
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, (OWLAnnotationValue)value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.getOwlOntology(), ontAnn);
                this.apply(addAnn);
                continue;
            }
            if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create(Namespaces.XSD.getPrefixIRI(), v3String.substring(4)) : IRI.create(v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype(valueIRI));
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, (OWLAnnotationValue)value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.getOwlOntology(), ontAnn);
                this.apply(addAnn);
                continue;
            }
            LOG.error("Cannot translate: {}", (Object)clause);
        }
    }

    protected void addOntologyAnnotation(OWLAnnotationProperty ap, OWLAnnotationValue v, Set<OWLAnnotation> annotations) {
        OWLAnnotation ontAnn = this.fac.getOWLAnnotation(ap, v, annotations);
        AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.getOwlOntology(), ontAnn);
        this.apply(addAnn);
    }

    public OWLClassExpression trTermFrame(Frame termFrame) {
        OWLClass cls = this.trClass(OWLAPIPreconditions.checkNotNull(termFrame.getId()));
        this.add(this.fac.getOWLDeclarationAxiom(cls));
        termFrame.getTags().stream().filter(OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag()::equals).forEach(t -> this.add(this.translateAltIds(termFrame.getClauses((String)t), cls.getIRI(), true)));
        termFrame.getTags().forEach(t -> this.add(this.trTermFrameClauses(cls, (Collection<Clause>)termFrame.getClauses((String)t), (String)t)));
        return cls;
    }

    protected Set<OWLAxiom> translateAltIds(Collection<Clause> clauses, IRI replacedBy, boolean isClass) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (Clause clause : clauses) {
            SWRLPredicate altIdEntity;
            String altId = clause.getValue(String.class);
            if (isClass) {
                altIdEntity = this.trClass(altId);
            } else {
                IRI altIdIRI = this.oboIdToIRI(altId);
                altIdEntity = this.fac.getOWLObjectProperty(altIdIRI);
            }
            axioms.add(this.fac.getOWLDeclarationAxiom((OWLEntity)((Object)altIdEntity)));
            axioms.add(this.fac.getOWLAnnotationAssertionAxiom(altIdEntity.getIRI(), this.fac.getOWLAnnotation(this.fac.getOWLDeprecated(), this.fac.getOWLLiteral(true))));
            axioms.add(this.fac.getOWLAnnotationAssertionAxiom(altIdEntity.getIRI(), this.fac.getOWLAnnotation(this.fac.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0100001.iri), replacedBy)));
            axioms.add(this.fac.getOWLAnnotationAssertionAxiom(altIdEntity.getIRI(), this.fac.getOWLAnnotation(this.fac.getOWLAnnotationProperty(Obo2OWLConstants.IRI_IAO_0000231), Obo2OWLConstants.IRI_IAO_0000227)));
        }
        return axioms;
    }

    public Set<OWLAxiom> trTermFrameClauses(OWLClass cls, Collection<Clause> clauses, String t) {
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
            axioms.add(this.trIntersectionOf(cls, clauses));
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
            axioms.add(this.trUnionOf(cls, clauses));
        } else {
            clauses.forEach(c -> axioms.add(this.trTermClause(cls, t, (Clause)c)));
        }
        return axioms;
    }

    @Nullable
    protected OWLNamedObject trTypedefToAnnotationProperty(Frame typedefFrame) {
        Object tagValue = typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG);
        if (Boolean.TRUE.equals(tagValue)) {
            String id = OWLAPIPreconditions.checkNotNull(typedefFrame.getId());
            OWLAnnotationProperty p = this.trAnnotationProp(id);
            this.add(this.fac.getOWLDeclarationAxiom(p));
            String xid = this.translateShorthandIdToExpandedId(id);
            if (!id.equals(xid)) {
                OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), p.getIRI(), this.trLiteral(id), new HashSet<OWLAnnotation>());
                this.add(ax);
            }
            this.typedefToAnnotationProperty.put(p.getIRI().toString(), p);
            for (String tag : typedefFrame.getTags()) {
                OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
                if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_A) continue;
                typedefFrame.getClauses(tag).forEach(c -> this.add(this.trGenericClause(p, tag, (Clause)c)));
            }
            return p;
        }
        return null;
    }

    @Nullable
    public OWLNamedObject trTypedefFrame(Frame typedefFrame) {
        Object tagValue = typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG);
        if (Boolean.TRUE.equals(tagValue)) {
            return null;
        }
        String id = OWLAPIPreconditions.checkNotNull(typedefFrame.getId());
        OWLObjectProperty p = this.trObjectProp(id);
        this.add(this.fac.getOWLDeclarationAxiom(p));
        String xid = this.translateShorthandIdToExpandedId(id);
        if (!xid.equals(id)) {
            OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), p.getIRI(), this.trLiteral(id), new HashSet<OWLAnnotation>());
            this.add(ax);
        }
        for (String tag : typedefFrame.getTags()) {
            OWLAxiom axiom;
            List<Clause> clauses = typedefFrame.getClauses(tag);
            OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
                axiom = OWLAPIObo2Owl.trRelationIntersectionOf(id, p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
                axiom = OWLAPIObo2Owl.trRelationUnionOf(id, p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_ALT_ID) {
                this.add(this.translateAltIds(clauses, p.getIRI(), false));
                continue;
            }
            clauses.forEach(c -> this.add(this.trTypedefClause(p, tag, (Clause)c)));
        }
        return p;
    }

    protected OWLAxiom trUnionOf(OWLClass cls, Collection<Clause> clauses) {
        Set<OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<OWLClassExpression> eSet = new HashSet<OWLClassExpression>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            LOG.error("union_of n-ary slots not is standard - converting anyway");
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectUnionOf(iSet));
        if (annotations.isEmpty()) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    protected OWLAxiom trIntersectionOf(OWLClass cls, Collection<Clause> clauses) {
        Set<OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<OWLClassExpression> eSet = new HashSet<OWLClassExpression>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectIntersectionOf(iSet));
        if (annotations.isEmpty()) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    protected void add(@Nullable OWLAxiom axiom) {
        if (axiom == null) {
            LOG.error("no axiom");
            return;
        }
        this.add(Collections.singleton(axiom));
    }

    protected void add(@Nullable Set<OWLAxiom> axioms) {
        if (axioms == null || axioms.isEmpty()) {
            LOG.error("no axiom");
            return;
        }
        this.getOwlOntology().add(axioms);
    }

    protected void apply(OWLOntologyChange change) {
        this.apply(CollectionFactory.list(change));
    }

    protected void apply(List<OWLOntologyChange> changes) {
        try {
            this.manager.applyChanges(changes);
        }
        catch (Exception e) {
            LOG.error("COULD NOT TRANSLATE AXIOM", (Throwable)e);
        }
    }

    @Nullable
    protected OWLAxiom trTermClause(OWLClass cls, String tag, Clause clause) {
        OWLAxiom ax;
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
        OWLClassExpression clsx = cls;
        String gciRel = OWLAPIObo2Owl.getQVString("gci_relation", qvs);
        String gciFiller = OWLAPIObo2Owl.getQVString("gci_filler", qvs);
        if (!gciRel.isEmpty() && !gciFiller.isEmpty()) {
            OWLClassExpression r = this.trRel(gciRel, gciFiller, Collections.emptySet());
            clsx = this.fac.getOWLObjectIntersectionOf(cls, r);
        }
        if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubClassOfAxiom(clsx, this.trClass((String)clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)clause.getValue());
            OWLAnnotationProperty prop = this.typedefToAnnotationProperty.get(relId.toString());
            ax = prop != null ? this.fac.getOWLAnnotationAssertionAxiom(prop, cls.getIRI(), this.oboIdToIRI((String)clause.getValue2()), annotations) : this.fac.getOWLSubClassOfAxiom(clsx, this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            HashSet<OWLClass> cSet = new HashSet<OWLClass>();
            cSet.add((OWLClass)clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLDisjointClassesAxiom(cSet, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            HashSet<OWLClass> cSet = new HashSet<OWLClass>();
            cSet.add((OWLClass)clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLEquivalentClassesAxiom(cSet, annotations);
        } else {
            return this.trGenericClause(cls, tag, clause);
        }
        return ax;
    }

    @Nullable
    protected OWLAxiom trTypedefClause(OWLObjectProperty p, String tag, Clause clause) {
        OWLAxiom ax = null;
        Object v = clause.getValue();
        assert (v != null);
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
        if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubObjectPropertyOfAxiom(p, this.trObjectProp((String)v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)v);
            OWLAnnotationProperty metaProp = this.typedefToAnnotationProperty.get(relId.toString());
            if (metaProp != null) {
                ax = this.fac.getOWLAnnotationAssertionAxiom(metaProp, p.getIRI(), this.oboIdToIRI((String)clause.getValue2()), annotations);
            }
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLDisjointObjectPropertiesAxiom(cSet, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF) {
            ax = this.fac.getOWLInverseObjectPropertiesAxiom(p, this.trObjectProp((String)v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLEquivalentObjectPropertiesAxiom(cSet, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DOMAIN) {
            ax = this.fac.getOWLObjectPropertyDomainAxiom(p, this.trClass(v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_RANGE) {
            ax = this.fac.getOWLObjectPropertyRangeAxiom(p, this.trClass(v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER) {
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(2);
            chain.add(p);
            chain.add(this.trObjectProp(v));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN || tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
                OWLAnnotation ann = this.fac.getOWLAnnotation(this.trAnnotationProp(IRI_PROP_ISREVERSIBLEPROPERTYCHAIN), this.trLiteral("true"));
                annotations.add(ann);
            }
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
            chain.add(this.trObjectProp(v));
            chain.add(this.trObjectProp(clause.getValue2()));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLTransitiveObjectPropertyAxiom(p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLReflexiveObjectPropertyAxiom(p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLSymmetricObjectPropertyAxiom(p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLAsymmetricObjectPropertyAxiom(p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLFunctionalObjectPropertyAxiom(p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLInverseFunctionalObjectPropertyAxiom(p, annotations);
        } else {
            return this.trGenericClause(p, tag, clause);
        }
        return ax;
    }

    @Nullable
    protected OWLAxiom trGenericClause(OWLNamedObject e, String tag, Clause clause) {
        return this.trGenericClause(e.getIRI(), tag, clause);
    }

    @Nullable
    protected OWLAxiom trGenericClause(OWLAnnotationSubject sub, String tag, Clause clause) {
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OWLAnnotationAssertionAxiom ax = null;
        OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
        if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_NAME) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DEF) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_SUBSET) {
            String v = clause.getValue(String.class);
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trAnnotationProp(v).getIRI(), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (values.size() == 2) {
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, this.trAnnotationProp(v2.toString()).getIRI(), annotations);
            } else if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create(Namespaces.XSD.getPrefixIRI(), v3String.substring(4)) : IRI.create(v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype(valueIRI));
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, value, annotations);
            } else {
                LOG.error("Cannot translate: {}", (Object)clause);
            }
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
            String synType;
            Object[] values = clause.getValues().toArray();
            if (values.length > 1) {
                synType = values[1].toString();
                if (values.length > 2) {
                    OWLAnnotation ann = this.fac.getOWLAnnotation(this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag()), this.trAnnotationProp(values[2].toString()).getIRI());
                    annotations.add(ann);
                }
            } else {
                LOG.warn("Assume 'RELATED'for missing scope in synonym clause: {}", (Object)clause);
                synType = OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag();
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trSynonymType(synType), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_XREF) {
            Xref xref = (Xref)clause.getValue();
            String xrefAnnotation = xref.getAnnotation();
            if (xrefAnnotation != null) {
                annotations.add(this.fac.getRDFSLabel(xrefAnnotation));
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        }
        return ax;
    }

    protected OWLAnnotationProperty trSynonymType(String type) {
        if (type.equals(OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_EXACT.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_NARROW.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_BROAD.getTag())) {
            return this.trTagToAnnotationProp(type);
        }
        return this.trAnnotationProp(type);
    }

    protected Set<OWLAnnotation> trAnnotations(Clause clause) {
        if (clause.hasNoAnnotations()) {
            return CollectionFactory.createSet();
        }
        HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
        this.trAnnotations(clause, anns);
        return anns;
    }

    protected void trAnnotations(Clause clause, Set<OWLAnnotation> anns) {
        Collection<Xref> xrefs = clause.getXrefs();
        for (Xref x : xrefs) {
            if (x.getIdref().isEmpty()) continue;
            OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag());
            OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(x));
            anns.add(ann);
        }
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        for (QualifierValue qv : qvs) {
            String qTag = qv.getQualifier();
            if (SKIPPED_QUALIFIERS.contains(qTag)) continue;
            OWLAnnotationProperty ap = this.trTagToAnnotationProp(qTag);
            OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(qv.getValue()));
            anns.add(ann);
        }
    }

    protected Set<OWLAnnotation> trAnnotations(Collection<Clause> clauses) {
        HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
        clauses.forEach(c -> this.trAnnotations((Clause)c, (Set<OWLAnnotation>)anns));
        return anns;
    }

    public OWLClassExpression trRel(String relId, String classId, Collection<QualifierValue> quals) {
        Object ex;
        Frame relFrame = this.obodoc.getTypedefFrame(relId);
        OWLObjectProperty pe = this.trObjectProp(relId);
        OWLClass ce = this.trClass(classId);
        Integer exact = OWLAPIObo2Owl.getQVInt("cardinality", quals);
        Integer min = OWLAPIObo2Owl.getQVInt("minCardinality", quals);
        Integer max = OWLAPIObo2Owl.getQVInt("maxCardinality", quals);
        boolean allSome = OWLAPIObo2Owl.getQVBoolean("all_some", quals);
        boolean allOnly = OWLAPIObo2Owl.getQVBoolean("all_only", quals);
        if (ce instanceof OWLClass) {
            this.add(this.fac.getOWLDeclarationAxiom(ce));
        }
        if (exact != null && exact > 0) {
            ex = this.fac.getOWLObjectExactCardinality(exact, pe, ce);
        } else if (exact != null && exact == 0 || max != null && max == 0) {
            OWLObjectComplementOf ceCompl = this.fac.getOWLObjectComplementOf(ce);
            ex = this.fac.getOWLObjectAllValuesFrom(pe, ceCompl);
        } else {
            ex = max != null && min != null ? this.fac.getOWLObjectIntersectionOf(this.fac.getOWLObjectMinCardinality(min, pe, ce), this.fac.getOWLObjectMaxCardinality(max, pe, ce)) : (min != null ? this.fac.getOWLObjectMinCardinality(min, pe, ce) : (max != null ? this.fac.getOWLObjectMaxCardinality(max, pe, ce) : (allSome && allOnly ? this.fac.getOWLObjectIntersectionOf(this.fac.getOWLObjectSomeValuesFrom(pe, ce), this.fac.getOWLObjectAllValuesFrom(pe, ce)) : (allOnly ? this.fac.getOWLObjectAllValuesFrom(pe, ce) : (relFrame != null && Boolean.TRUE.equals(relFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG)) ? this.fac.getOWLObjectHasValue(pe, this.trIndividual(classId)) : this.fac.getOWLObjectSomeValuesFrom(pe, ce))))));
        }
        return ex;
    }

    protected OWLClass trClass(String classId) {
        return this.fac.getOWLClass(this.oboIdToIRI(classId));
    }

    protected OWLClassExpression trClass(Object v) {
        return this.trClass((String)v);
    }

    protected String mapPropId(String id) {
        Frame f = this.obodoc.getTypedefFrame(id);
        if (f != null) {
            Collection<Xref> xrefs = f.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
            for (Xref x : xrefs) {
                String xid = x.getIdref();
                if (!OBODoc.isTreatXrefsAsEquivalent(OWLAPIObo2Owl.getIdPrefix(xid))) continue;
                return xid;
            }
        }
        return id;
    }

    protected OWLIndividual trIndividual(String instId) {
        IRI iri = this.oboIdToIRI(instId);
        return this.fac.getOWLNamedIndividual(iri);
    }

    protected OWLAnnotationProperty trTagToAnnotationProp(String tag) {
        IRI iri = OWLAPIObo2Owl.trTagToIRI(tag);
        OWLAnnotationProperty ap = this.fac.getOWLAnnotationProperty(iri);
        if (!this.apToDeclare.contains(ap)) {
            this.apToDeclare.add(ap);
            this.add(this.fac.getOWLDeclarationAxiom(ap));
            Obo2OWLConstants.Obo2OWLVocabulary vocab = Obo2OWLConstants.getVocabularyObj(tag);
            if (vocab != null) {
                this.add(this.fac.getOWLAnnotationAssertionAxiom(iri, this.fac.getRDFSLabel(vocab.getLabel())));
            }
        }
        return ap;
    }

    protected void addDeclaredAnnotationProperties(@Nullable Collection<OWLAnnotationProperty> declaredProperties) {
        if (declaredProperties != null) {
            this.apToDeclare.addAll(declaredProperties);
        }
    }

    protected OWLAnnotationProperty trAnnotationProp(String relId) {
        return this.fac.getOWLAnnotationProperty(this.oboIdToIRI(this.mapPropId(relId)));
    }

    protected OWLObjectProperty trObjectProp(String relId) {
        return this.fac.getOWLObjectProperty(this.oboIdToIRI(this.mapPropId(relId)));
    }

    protected OWLObjectPropertyExpression trObjectProp(Object v) {
        return this.fac.getOWLObjectProperty(this.oboIdToIRI(this.mapPropId((String)v)));
    }

    protected OWLAnnotationValue trLiteral(Object inputValue) {
        Object value = inputValue;
        if (value instanceof Xref) {
            value = ((Xref)value).getIdref();
        } else {
            if (value instanceof Date) {
                String lexicalValue = OBOFormatConstants.headerDateFormat().format((Date)value);
                return this.fac.getOWLLiteral(lexicalValue, OWL2Datatype.XSD_DATE_TIME);
            }
            if (value instanceof Boolean) {
                return this.fac.getOWLLiteral((Boolean)value);
            }
            if (!(value instanceof String)) {
                value = value.toString();
            }
        }
        String value2 = (String)value;
        return this.fac.getOWLLiteral(value2);
    }

    public IRI oboIdToIRI(String id) {
        return (IRI)this.idToIRICache.getUnchecked((Object)id);
    }

    public IRI loadOboToIRI(String id) {
        String safeId;
        String localId;
        String db;
        String xid;
        if (id.contains(" ")) {
            LOG.error("id contains space: \"{}\"", (Object)id);
            throw new OWLParserException("spaces not allowed: '" + id + '\'');
        }
        if (id.startsWith("http:")) {
            return IRI.create(id);
        }
        if (id.startsWith("https:")) {
            return IRI.create(id);
        }
        if (id.startsWith("ftp:")) {
            return IRI.create(id);
        }
        if (id.startsWith("urn:")) {
            return IRI.create(id);
        }
        if (!id.contains(":") && !(xid = this.translateShorthandIdToExpandedId(id)).equals(id)) {
            return this.oboIdToIRI(xid);
        }
        String[] idParts = id.split(":", 2);
        if (idParts.length > 1) {
            db = idParts[0];
            localId = idParts[1];
            db = localId.contains("_") ? db + "#_" : db + "_";
        } else if (idParts.length == 0) {
            db = this.getDefaultIDSpace() + '#';
            localId = id;
        } else {
            db = this.getDefaultIDSpace() + '#';
            localId = idParts[0];
        }
        String uriPrefix = "http://purl.obolibrary.org/obo/" + db;
        if (this.idSpaceMap.containsKey(db)) {
            uriPrefix = this.idSpaceMap.get(db);
        }
        try {
            safeId = URLEncoder.encode(localId, "US-ASCII");
        }
        catch (UnsupportedEncodingException e1) {
            throw new OWLRuntimeException(e1);
        }
        if (safeId.contains(" ")) {
            safeId = safeId.replace(" ", "_");
        }
        IRI iri = null;
        try {
            iri = IRI.create(uriPrefix + safeId);
        }
        catch (IllegalArgumentException e) {
            throw new OWLRuntimeException(e);
        }
        return iri;
    }

    protected String translateShorthandIdToExpandedId(String id) {
        if (id.contains(":")) {
            return id;
        }
        Frame tdf = this.obodoc.getTypedefFrame(id);
        if (tdf == null) {
            return id;
        }
        Collection<Xref> xrefs = tdf.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
        String matchingExpandedId = null;
        for (Xref xref : xrefs) {
            matchingExpandedId = this.handleXref(id, matchingExpandedId, xref);
        }
        if (matchingExpandedId == null) {
            return id;
        }
        return matchingExpandedId;
    }

    @Nullable
    protected String handleXref(String id, @Nullable String matchingExpandedId, @Nullable Xref xref) {
        if (xref != null) {
            String xid = xref.getIdref();
            if (xid.equals(id)) {
                return matchingExpandedId;
            }
            if (matchingExpandedId == null) {
                return xid;
            }
            if (xid.startsWith("RO") || xid.startsWith("BFO")) {
                return xid;
            }
        }
        return matchingExpandedId;
    }

    protected String getDefaultIDSpace() {
        return this.defaultIDSpace;
    }
}

