/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.limited.iterator;

import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.Iteration;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;

public class LimitedSizeDistinctIteration
extends DistinctIteration<BindingSet, QueryEvaluationException> {
    private final AtomicLong used;
    private final long maxSize;

    public LimitedSizeDistinctIteration(Iteration<? extends BindingSet, ? extends QueryEvaluationException> iter, AtomicLong used, long maxSize) {
        super(iter);
        this.used = used;
        this.maxSize = maxSize;
    }

    protected boolean add(BindingSet object) throws QueryEvaluationException {
        boolean add = super.add((Object)object);
        if (add && this.used.incrementAndGet() > this.maxSize) {
            throw new QueryEvaluationException("Size limited reached inside query operator.");
        }
        return add;
    }
}

