/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.statements.metadata;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ParameterizedSparqlString;

public class JenaParameterMetadata
implements ParameterMetaData {
    private ParameterizedSparqlString sparqlStr;
    private int paramCount;

    public JenaParameterMetadata(ParameterizedSparqlString sparqlStr) throws SQLException {
        if (sparqlStr == null) {
            throw new SQLException("Parameterized SPARQL String cannot be null");
        }
        this.sparqlStr = sparqlStr;
        this.paramCount = (int)Iter.count((Iterator)this.sparqlStr.getEligiblePositionalParameters());
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return Node.class.getCanonicalName();
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return 1;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return 2000;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return Node.class.getCanonicalName();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return 0;
    }

    @Override
    public int isNullable(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        if (param < 1 || param > this.paramCount) {
            throw new SQLException("Parameter Index is out of bounds");
        }
        return false;
    }
}

