/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.jena.jdbc.results.QueryExecutionResults;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.QueryExecution;

public abstract class MaterializedResults<T>
extends QueryExecutionResults {
    private T currItem;
    private int currRow = 0;

    public MaterializedResults(JenaStatement statement, QueryExecution qe, boolean commit) throws SQLException {
        super(statement, qe, commit);
    }

    protected T getCurrentRow() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result set is closed");
        }
        return this.currItem;
    }

    protected abstract boolean hasNext() throws SQLException;

    protected abstract boolean hasPrevious() throws SQLException;

    protected abstract T moveNext() throws SQLException;

    protected abstract T movePrevious() throws SQLException;

    protected abstract int getTotalRows() throws SQLException;

    @Override
    public final boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        if (row == 1) {
            return this.first();
        }
        if (row == -1) {
            return this.last();
        }
        if (row == 0) {
            this.beforeFirst();
            return false;
        }
        if (row > this.getTotalRows()) {
            this.afterLast();
            return false;
        }
        if (row <= 0) {
            int destRow = this.getTotalRows() + 1 + row;
            if (destRow < 1) {
                this.beforeFirst();
                return false;
            }
            return this.absolute(destRow);
        }
        if (row == this.currRow) {
            return true;
        }
        if (row < this.currRow) {
            while (this.hasPrevious() && row < this.currRow) {
                this.currItem = this.movePrevious();
                --this.currRow;
            }
            return true;
        }
        while (this.hasNext() && this.currRow < row) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        return true;
    }

    @Override
    public final void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        while (this.hasNext()) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        this.currItem = null;
        this.currRow = this.getTotalRows() + 1;
    }

    @Override
    public final void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.isAfterLast()) {
            this.currRow = this.getTotalRows();
        }
        while (this.hasPrevious()) {
            this.currItem = this.movePrevious();
            --this.currRow;
        }
        this.currItem = null;
        this.currRow = 0;
    }

    @Override
    protected final void closeInternal() throws SQLException {
        this.currItem = null;
        this.closeStreamInternal();
    }

    protected abstract void closeStreamInternal() throws SQLException;

    @Override
    public final boolean first() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.getTotalRows() == 0) {
            return false;
        }
        if (this.currRow == 1) {
            return true;
        }
        if (this.isAfterLast()) {
            this.currRow = this.getTotalRows();
        }
        if (this.isBeforeFirst()) {
            if (this.hasNext()) {
                this.currItem = this.moveNext();
                this.currRow = 1;
                return true;
            }
            return false;
        }
        while (this.hasPrevious()) {
            this.currItem = this.movePrevious();
            --this.currRow;
        }
        return true;
    }

    @Override
    public final int getFetchDirection() {
        return 1000;
    }

    @Override
    public final int getFetchSize() {
        return 0;
    }

    @Override
    public final int getRow() {
        return this.currRow;
    }

    @Override
    public final int getType() {
        return 1004;
    }

    @Override
    public final boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow > this.getTotalRows();
    }

    @Override
    public final boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 0;
    }

    @Override
    public final boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == 1;
    }

    @Override
    public final boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        return this.currRow == this.getTotalRows();
    }

    @Override
    public final boolean last() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.getTotalRows() == 0) {
            return false;
        }
        if (this.currRow == this.getTotalRows()) {
            return true;
        }
        if (this.isAfterLast()) {
            this.currRow = this.getTotalRows();
            if (this.hasPrevious()) {
                this.currItem = this.movePrevious();
                this.currRow = this.getTotalRows();
                return true;
            }
            return false;
        }
        while (this.hasNext()) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        return true;
    }

    @Override
    public final boolean next() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to the next row in a closed result set");
        }
        if (this.hasNext()) {
            this.currItem = this.moveNext();
            ++this.currRow;
            return true;
        }
        this.currItem = null;
        this.currRow = this.getTotalRows() + 1;
        return false;
    }

    @Override
    public final boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot mvoe to the previous row in a closed result set");
        }
        if (this.hasPrevious()) {
            this.currItem = this.movePrevious();
            --this.currRow;
            return true;
        }
        this.currItem = null;
        this.currRow = 0;
        return false;
    }

    @Override
    public final boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot move to a row after the result set has been closed");
        }
        if (rows == 0) {
            return true;
        }
        if (rows < 0) {
            int destRow = this.currRow + rows;
            if (destRow < 0) {
                destRow = 0;
            }
            return this.absolute(destRow);
        }
        if (this.currRow + rows > this.getTotalRows()) {
            this.afterLast();
            return false;
        }
        for (int moved = 0; this.hasNext() && moved < rows; ++moved) {
            this.currItem = this.moveNext();
            ++this.currRow;
        }
        return true;
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets only support forward fetch");
        }
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

