/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import java.io.File;
import java.io.Serializable;

public class EventResource
implements Serializable {
    private static final long serialVersionUID = -4809586705672043577L;
    public final String indexName;
    public final String partitionId;
    public final String file;
    private static final transient String BLANK = "";

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.indexName != null && this.indexName.length() != 0) {
            sb.append(this.indexName);
            if (this.partitionId != null && this.partitionId.length() != 0) {
                sb.append("#" + this.partitionId);
            }
        } else if (this.partitionId != null && this.partitionId.length() != 0) {
            sb.append(this.partitionId);
        }
        if (this.file != null && this.file.length() != 0) {
            if (sb.length() != 0) {
                sb.append(":");
            }
            sb.append(this.file);
        }
        return sb.toString();
    }

    public EventResource() {
        this.indexName = BLANK;
        this.partitionId = BLANK;
        this.file = BLANK;
    }

    public EventResource(String indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException();
        }
        this.indexName = indexName;
        this.partitionId = BLANK;
        this.file = BLANK;
    }

    public EventResource(IndexMetadata md) {
        if (md == null) {
            this.indexName = BLANK;
            this.partitionId = BLANK;
            this.file = BLANK;
        } else {
            this.indexName = md.getName();
            LocalPartitionMetadata pmd = md.getPartitionMetadata();
            this.partitionId = pmd == null ? BLANK : Integer.toString(pmd.getPartitionId());
            this.file = BLANK;
        }
    }

    public EventResource(String indexName, int partitionId) {
        if (indexName == null) {
            throw new IllegalArgumentException();
        }
        this.indexName = indexName;
        this.partitionId = BLANK;
        this.file = BLANK;
    }

    public EventResource(IndexMetadata md, File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (md == null) {
            this.indexName = BLANK;
            this.partitionId = BLANK;
        } else {
            this.indexName = md.getName();
            LocalPartitionMetadata pmd = md.getPartitionMetadata();
            this.partitionId = pmd == null ? BLANK : Integer.toString(pmd.getPartitionId());
        }
        this.file = file.toString();
    }

    public EventResource(String indexName, int partitionId, File file) {
        if (indexName == null) {
            throw new IllegalArgumentException();
        }
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.indexName = indexName;
        this.partitionId = Integer.toString(partitionId);
        this.file = file.toString();
    }

    public EventResource(String indexName, String partitionId, String file) {
        this.indexName = indexName;
        this.partitionId = partitionId;
        this.file = file;
    }
}

