/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service;

import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.config.LongValidator;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.Instrument;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.ITx;
import com.bigdata.journal.RunState;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.journal.ValidationError;
import com.bigdata.service.AbstractService;
import com.bigdata.service.IServiceShutdown;
import com.bigdata.service.ITxState;
import com.bigdata.service.ITxState0;
import com.bigdata.service.TxId2CommitTimeIndex;
import com.bigdata.service.TxServiceRunState;
import com.bigdata.util.MillisecondTimestampFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class AbstractTransactionService
extends AbstractService
implements ITransactionService,
IServiceShutdown,
ICounterSetAccess {
    protected static final Logger log = Logger.getLogger(AbstractTransactionService.class);
    protected static final transient String ERR_READ_ONLY = "Read-only";
    protected static final transient String ERR_NO_SUCH = "Unknown transaction";
    protected static final transient String ERR_NOT_ACTIVE = "Not active";
    protected static final transient String ERR_SERVICE_NOT_AVAIL = "Service not available";
    private volatile TxServiceRunState runState;
    private final Properties properties;
    private final long minReleaseAge;
    private final ConcurrentHashMap<Long, TxState> activeTx = new ConcurrentHashMap();
    private volatile long lastTimestamp;
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition txDeactivate = this.lock.newCondition();
    private long startCount = 0L;
    private long abortCount = 0L;
    private long commitCount = 0L;
    private final AtomicLong readWriteActiveCount = new AtomicLong(0L);
    private final AtomicLong readOnlyActiveCount = new AtomicLong(0L);
    private volatile TxState earliestOpenTx = null;
    private volatile long releaseTime = 0L;
    private final TxId2CommitTimeIndex startTimeIndex = TxId2CommitTimeIndex.createTransient();
    private static final transient String[] EMPTY = new String[0];

    protected Properties getProperties() {
        return new Properties(this.properties);
    }

    protected TxState getTxState(long tx) {
        return this.activeTx.get(tx);
    }

    public final int getActiveCount() {
        return this.activeTx.size();
    }

    public AbstractTransactionService(Properties properties) {
        this.properties = (Properties)properties.clone();
        this.minReleaseAge = LongValidator.GTE_ZERO.parse(Options.MIN_RELEASE_AGE, properties.getProperty(Options.MIN_RELEASE_AGE, "1"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.MIN_RELEASE_AGE + "=" + this.minReleaseAge));
        }
        this.runState = TxServiceRunState.Starting;
    }

    @Override
    public boolean isOpen() {
        return this.runState != TxServiceRunState.Halted;
    }

    protected void assertOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
    }

    public TxServiceRunState getRunState() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.runState;
    }

    protected synchronized void setRunState(TxServiceRunState newval) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!this.runState.isTransitionLegal(newval)) {
            throw new IllegalStateException("runState=" + (Object)((Object)this.runState) + ", but newval=" + (Object)((Object)newval));
        }
        this.runState = newval;
        if (log.isInfoEnabled()) {
            log.info((Object)("runState=" + (Object)((Object)this.runState)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.lock.lock();
        try {
            switch (this.getRunState()) {
                case Shutdown: 
                case ShutdownNow: 
                case Halted: {
                    return;
                }
            }
            this.setRunState(TxServiceRunState.Shutdown);
            try {
                this.awaitRunningTx(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                log.warn((Object)("Interrupted during shutdown - will do fast shutdown: " + ex), (Throwable)ex);
                this.shutdownNow();
                this.lock.unlock();
                return;
            }
            super.shutdown();
            this.setRunState(TxServiceRunState.Halted);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitRunningTx(long logTimeout, TimeUnit unit) throws InterruptedException {
        long begin;
        long lastLogTime = begin = System.nanoTime();
        logTimeout = unit.toNanos(logTimeout);
        long elapsed = 0L;
        if (log.isInfoEnabled()) {
            log.info((Object)("activeCount=" + this.getActiveCount()));
        }
        while (this.getActiveCount() > 0) {
            if (this.txDeactivate.await(logTimeout, TimeUnit.NANOSECONDS) && this.getActiveCount() == 0) {
                elapsed = System.nanoTime() - begin;
                if (log.isInfoEnabled()) {
                    log.info((Object)("No transactions remaining: elapsed=" + elapsed));
                }
                return;
            }
            elapsed = System.nanoTime() - begin;
            long now = System.nanoTime();
            long elapsedLogTime = now - lastLogTime;
            if (elapsedLogTime >= logTimeout) {
                try {
                    this.logTimeout(elapsed, TimeUnit.NANOSECONDS);
                }
                catch (Throwable t) {
                    log.error((Object)"Ignored", t);
                }
            }
            lastLogTime = now;
        }
    }

    private void logTimeout(long elapsed, TimeUnit unit) {
        log.warn((Object)("Waiting on task(s): elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed) + "ms, #active=" + this.getActiveCount() + ", #readWrite=" + this.getReadWriteActiveCount() + ", #readOnly=" + this.getReadOnlyActiveCount()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNow() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.lock.lock();
        try {
            switch (this.getRunState()) {
                case ShutdownNow: 
                case Halted: {
                    return;
                }
            }
            this.setRunState(TxServiceRunState.ShutdownNow);
            this.abortAllTx();
            super.shutdownNow();
            this.setRunState(TxServiceRunState.Halted);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAllTx() {
        this.lock.lock();
        try {
            Iterator i$ = this.activeTx.keySet().iterator();
            while (i$.hasNext()) {
                long tx = (Long)i$.next();
                TxState state = this.activeTx.get(tx);
                if (state == null) continue;
                state.lock.lock();
                try {
                    if (!state.isActive()) continue;
                    try {
                        this.abortImpl(state);
                        assert (state.isAborted()) : state.toString();
                    }
                    catch (Throwable t) {
                        log.error((Object)state.toString(), t);
                    }
                    finally {
                        this.deactivateTx(state);
                    }
                }
                finally {
                    state.lock.unlock();
                    this.updateReleaseTime(Math.abs(state.tx), null);
                }
            }
            this.txDeactivate.signalAll();
            int activeCount = this.getActiveCount();
            if (activeCount != 0) {
                log.warn((Object)("Service shutdown with active transactions: #nactive=" + this.activeTx.size()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        log.warn((Object)"");
        this.lock.lock();
        try {
            this.shutdownNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long nextTimestamp() {
        switch (this.runState) {
            case Starting: {
                throw new IllegalStateException(ERR_SERVICE_NOT_AVAIL);
            }
        }
        return this._nextTimestamp();
    }

    private final synchronized long _nextTimestamp() {
        this.lastTimestamp = MillisecondTimestampFactory.nextMillis();
        return this.lastTimestamp;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long newTx(long timestamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long getStartCount() {
        return this.startCount;
    }

    public long getAbortCount() {
        return this.abortCount;
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getReadOnlyActiveCount() {
        return this.readOnlyActiveCount.get();
    }

    public long getReadWriteActiveCount() {
        return this.readWriteActiveCount.get();
    }

    protected TxState getEarliestActiveTx() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.earliestOpenTx;
    }

    @Override
    public long getReleaseTime() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("releaseTime=" + this.releaseTime + ", lastKnownCommitTime=" + this.getLastCommitTime()));
        }
        return this.releaseTime;
    }

    protected void setReleaseTime(long newValue) {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        long oldValue = this.releaseTime;
        if (newValue < oldValue) {
            String msg = "oldValue=" + oldValue + ", newValue=" + newValue;
            log.error((Object)msg, (Throwable)new RuntimeException(msg));
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("newValue=" + newValue));
        }
        this.releaseTime = newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getEffectiveReleaseTimeForHA() {
        if (this.minReleaseAge == Long.MAX_VALUE) {
            return 0L;
        }
        long lastCommitTime = this.getLastCommitTime();
        this.lock.lock();
        try {
            long now = this._nextTimestamp();
            TxState txState = this.getEarliestActiveTx();
            long earliestTxReadsOnCommitTime = txState == null ? now : txState.readsOnCommitTime;
            long effectiveReleaseTimeForHA = Math.min(lastCommitTime - 1L, Math.min(earliestTxReadsOnCommitTime - 1L, now - this.minReleaseAge));
            if (log.isDebugEnabled()) {
                log.debug((Object)("releaseTime=" + this.releaseTime + ", lastCommitTime=" + lastCommitTime + ", earliestActiveTx=" + txState + ", readsOnCommitTime=" + earliestTxReadsOnCommitTime + ", (now-minReleaseAge)=" + (now - this.minReleaseAge) + ": effectiveReleaseTimeForHA=" + effectiveReleaseTimeForHA));
            }
            long l = effectiveReleaseTimeForHA;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activateTx(TxState state) {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        state.lock.lock();
        try {
            if (!state.isActive()) {
                throw new IllegalArgumentException();
            }
            if (this.earliestOpenTx == null || Math.abs(state.tx) < Math.abs(this.earliestOpenTx.tx)) {
                this.earliestOpenTx = state;
            }
            this.activeTx.put(state.tx, state);
            TxId2CommitTimeIndex txId2CommitTimeIndex = this.startTimeIndex;
            synchronized (txId2CommitTimeIndex) {
                this.startTimeIndex.add(state);
            }
            ++this.startCount;
            if (state.isReadOnly()) {
                this.readOnlyActiveCount.incrementAndGet();
            } else {
                this.readWriteActiveCount.incrementAndGet();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(state.toString() + ", releaseTime=" + this.releaseTime + ", earliestActiveTx=" + this.earliestOpenTx + ", startCount=" + this.startCount + ", abortCount=" + this.abortCount + ", commitCount=" + this.commitCount + ", readOnlyActiveCount=" + this.readOnlyActiveCount + ", readWriteActiveCount=" + this.readWriteActiveCount));
            }
        }
        finally {
            state.lock.unlock();
        }
    }

    protected long getReadsOnTime(long txId) {
        TxState state = this.activeTx.get(txId);
        if (state == null) {
            throw new IllegalArgumentException();
        }
        return state.readsOnCommitTime;
    }

    protected void deactivateTx(TxState state) {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        if (!state.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!state.isComplete()) {
            throw new IllegalArgumentException();
        }
        if (state.isAborted()) {
            ++this.abortCount;
        } else {
            ++this.commitCount;
        }
        if (state.isReadOnly()) {
            this.readOnlyActiveCount.decrementAndGet();
        } else {
            this.readWriteActiveCount.decrementAndGet();
        }
        if (this.activeTx.remove(state.tx) == null) {
            log.warn((Object)("Transaction not in table: " + state));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(state.toString() + ", startCount=" + this.startCount + ", abortCount=" + this.abortCount + ", commitCount=" + this.commitCount + ", readOnlyActiveCount=" + this.readOnlyActiveCount + ", readWriteActiveCount=" + this.readWriteActiveCount));
        }
    }

    protected boolean isReleaseTimeConsensusProtocol() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateReleaseTime(long timestamp, TxState deactivatedTx) {
        boolean isEarliestTx;
        if (timestamp <= 0L) {
            throw new IllegalArgumentException();
        }
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        long now = this._nextTimestamp();
        long oldReleaseTime = this.releaseTime;
        TxState earliestActiveTx = null;
        TxId2CommitTimeIndex txId2CommitTimeIndex = this.startTimeIndex;
        synchronized (txId2CommitTimeIndex) {
            long indexOf = this.startTimeIndex.findIndexOf(timestamp);
            boolean bl = isEarliestTx = indexOf == 0L;
            if (indexOf != -1L) {
                this.startTimeIndex.remove(timestamp);
            }
            if (this.startTimeIndex.getEntryCount() > 0L) {
                ITupleIterator titr = this.startTimeIndex.rangeIterator();
                while (titr.hasNext()) {
                    ITuple t = titr.next();
                    ITxState0 x = (ITxState0)t.getObject();
                    TxState tmp = this.getTxState(x.getStartTimestamp());
                    if (tmp == null || !tmp.isActive()) continue;
                    assert (tmp != deactivatedTx);
                    earliestActiveTx = tmp;
                    break;
                }
            } else {
                earliestActiveTx = null;
            }
            this.earliestOpenTx = earliestActiveTx;
            if (log.isTraceEnabled()) {
                log.trace((Object)("earliestActiveTx=" + earliestActiveTx));
            }
        }
        if (this.minReleaseAge == Long.MAX_VALUE) {
            return;
        }
        if (isEarliestTx && !this.isReleaseTimeConsensusProtocol()) {
            long minReleaseAge;
            long earliestTxStartTime = earliestActiveTx == null ? now : earliestActiveTx.tx;
            long earliestTxReadsOnCommitTime = earliestActiveTx == null ? now : earliestActiveTx.readsOnCommitTime;
            long lastCommitTime = this.getLastCommitTime();
            long releaseTime = Math.min(lastCommitTime - 1L, Math.min(earliestTxReadsOnCommitTime - 1L, now - (minReleaseAge = this.getMinReleaseAge())));
            if (this.releaseTime < releaseTime) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("lastCommitTime=" + lastCommitTime + ", earliestTxStartTime=" + earliestTxStartTime + ", minReleaseAge=" + minReleaseAge + ", now=" + now + ", releaseTime(" + oldReleaseTime + "->" + releaseTime + ")"));
                }
                this.setReleaseTime(releaseTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCommit(long commitTime) {
        this.lock.lock();
        try {
            this.updateReleaseTimeForBareCommit(commitTime);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateReleaseTimeForBareCommit(long commitTime) {
        this.lock.lock();
        try {
            TxId2CommitTimeIndex txId2CommitTimeIndex = this.startTimeIndex;
            synchronized (txId2CommitTimeIndex) {
                long now;
                long lastCommitTime;
                long releaseTime;
                if (!this.isReleaseTimeConsensusProtocol() && this.releaseTime < commitTime - 1L && this.startTimeIndex.getEntryCount() == 0L && this.releaseTime < (releaseTime = Math.min((lastCommitTime = commitTime) - 1L, (now = this._nextTimestamp()) - this.minReleaseAge))) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Advancing releaseTime (no active tx): lastCommitTime=" + lastCommitTime + ", minReleaseAge=" + this.minReleaseAge + ", now=" + now + ", releaseTime(" + this.releaseTime + "->" + releaseTime + ")"));
                    }
                    this.setReleaseTime(releaseTime);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public final long getMinReleaseAge() {
        return this.minReleaseAge;
    }

    protected final TxState assignTransactionIdentifier(long timestamp) throws InterruptedException, TimeoutException {
        long lastCommitTime = this.getLastCommitTime();
        if (timestamp == 0L) {
            return new TxState(-this.nextTimestamp(), lastCommitTime);
        }
        if (timestamp == lastCommitTime) {
            return new TxState(this.nextTimestamp(), lastCommitTime);
        }
        if (timestamp == -1L) {
            return new TxState(this.nextTimestamp(), lastCommitTime);
        }
        long releaseTime = this.getReleaseTime();
        if (timestamp <= releaseTime) {
            throw new IllegalStateException("Timestamp is less than or equal to the release time: timestamp=" + timestamp + ", releaseTime=" + releaseTime);
        }
        return this.getStartTime(timestamp);
    }

    private final TxState getStartTime(long timestamp) throws InterruptedException, TimeoutException {
        long readsOnCommitTime;
        long commitTime = this.findCommitTime(timestamp);
        long l = readsOnCommitTime = commitTime == -1L ? 0L : commitTime;
        if (commitTime == -1L) {
            return new TxState(this.nextTimestamp(), readsOnCommitTime);
        }
        long nextCommitTime = this.findNextCommitTime(commitTime);
        if (nextCommitTime == -1L) {
            return new TxState(this.nextTimestamp(), readsOnCommitTime);
        }
        long txId = this.findUnusedTimestamp(commitTime, nextCommitTime, 1000L, TimeUnit.MILLISECONDS);
        return new TxState(txId, readsOnCommitTime);
    }

    protected abstract long findCommitTime(long var1);

    protected abstract long findNextCommitTime(long var1);

    protected long findUnusedTimestamp(long commitTime, long nextCommitTime, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long nanos;
        long begin = System.nanoTime();
        long remaining = nanos = unit.toNanos(timeout);
        while (remaining >= 0L) {
            for (long t = commitTime; t < nextCommitTime; ++t) {
                if (this.activeTx.containsKey(t) || this.activeTx.containsKey(-t)) continue;
                return t;
            }
            remaining = nanos - (System.nanoTime() - begin);
            if (!this.txDeactivate.await(remaining, TimeUnit.NANOSECONDS)) {
                throw new TimeoutException();
            }
            remaining = nanos - (System.nanoTime() - begin);
        }
        throw new TimeoutException();
    }

    @Override
    public abstract long getLastCommitTime();

    protected abstract void abortImpl(TxState var1) throws Exception;

    protected abstract long commitImpl(TxState var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(long tx) {
        this.setupLoggingContext();
        try {
            switch (this.runState) {
                case Shutdown: 
                case Running: {
                    break;
                }
                default: {
                    throw new IllegalStateException(ERR_SERVICE_NOT_AVAIL);
                }
            }
            TxState state = this.activeTx.get(tx);
            if (state == null) {
                throw new IllegalStateException(ERR_NO_SUCH);
            }
            boolean wasActive = false;
            state.lock.lock();
            try {
                if (!state.isActive()) {
                    throw new IllegalStateException(ERR_NOT_ACTIVE);
                }
                wasActive = true;
                try {
                    this.abortImpl(state);
                    assert (state.isAborted()) : state.toString();
                }
                catch (Throwable t) {
                    log.error((Object)state.toString(), t);
                }
            }
            finally {
                try {
                    if (wasActive) {
                        this.deactivateTx(state);
                    }
                }
                finally {
                    state.lock.unlock();
                    if (wasActive) {
                        this.lock.lock();
                        try {
                            this.updateReleaseTime(Math.abs(state.tx), state);
                            this.txDeactivate.signalAll();
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                }
            }
        }
        finally {
            this.clearLoggingContext();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long commit(long tx) throws ValidationError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractTransactionService start() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.lock.lock();
        try {
            switch (this.getRunState()) {
                case Starting: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            long timestamp = this._nextTimestamp();
            long lastCommitTime = this.getLastCommitTime();
            if (timestamp < lastCommitTime) {
                throw new RuntimeException("Clock reporting timestamps before lastCommitTime: now=" + new Date(timestamp) + ", lastCommitTime=" + new Date(lastCommitTime));
            }
            this.updateReleaseTime(timestamp, null);
            this.setRunState(TxServiceRunState.Running);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    @Override
    public Class getServiceIface() {
        return ITransactionService.class;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet countersRoot = new CounterSet();
        countersRoot.addCounter("runState", new Instrument<String>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.runState.toString());
            }
        });
        countersRoot.addCounter("#active", new Instrument<Integer>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getActiveCount());
            }
        });
        countersRoot.addCounter("lastCommitTime", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getLastCommitTime());
            }
        });
        countersRoot.addCounter("minReleaseAge", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getMinReleaseAge());
            }
        });
        countersRoot.addCounter("releaseTime", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getReleaseTime());
            }
        });
        countersRoot.addCounter("startCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getStartCount());
            }
        });
        countersRoot.addCounter("abortCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getAbortCount());
            }
        });
        countersRoot.addCounter("commitCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getCommitCount());
            }
        });
        countersRoot.addCounter("readOnlyActiveCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getReadOnlyActiveCount());
            }
        });
        countersRoot.addCounter("readWriteActiveCount", new Instrument<Long>(){

            @Override
            protected void sample() {
                this.setValue(AbstractTransactionService.this.getReadWriteActiveCount());
            }
        });
        countersRoot.addCounter("earliestReadsOnCommitTime", new Instrument<Long>(){

            @Override
            protected void sample() {
                TxState tmp = AbstractTransactionService.this.earliestOpenTx;
                if (tmp != null) {
                    this.setValue(tmp.readsOnCommitTime);
                }
            }
        });
        return countersRoot;
    }

    public class TxState
    implements ITxState {
        public final long tx;
        private final long readsOnCommitTime;
        private final boolean readOnly;
        private volatile RunState runState = RunState.Active;
        private long commitTime = 0L;
        private final Set<UUID> dataServices;
        private final Set<String> resources;
        protected final ReentrantLock lock = new ReentrantLock();
        private final int hashCode;

        public void setRunState(RunState newval) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (newval == null) {
                throw new IllegalArgumentException();
            }
            if (!this.runState.isTransitionAllowed(newval)) {
                throw new IllegalStateException("runState=" + (Object)((Object)this.runState) + ", newValue=" + (Object)((Object)newval));
            }
            this.runState = newval;
        }

        @Override
        public final long getStartTimestamp() {
            return this.tx;
        }

        @Override
        public final long getReadsOnCommitTime() {
            return this.readsOnCommitTime;
        }

        public long getCommitTime() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.commitTime == 0L) {
                throw new IllegalStateException();
            }
            return this.commitTime;
        }

        protected void setCommitTime(long commitTime) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (commitTime == 0L) {
                throw new IllegalArgumentException();
            }
            if (this.commitTime != 0L) {
                throw new IllegalStateException();
            }
            this.commitTime = commitTime;
        }

        public String[] getResources() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.resources == null) {
                return EMPTY;
            }
            return this.resources.toArray(new String[0]);
        }

        public boolean isStartedOn(UUID dataServiceUUID) {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (dataServiceUUID == null) {
                throw new IllegalArgumentException();
            }
            if (this.dataServices == null) {
                return false;
            }
            return this.dataServices.contains(dataServiceUUID);
        }

        protected UUID[] getDataServiceUUIDs() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.dataServices == null) {
                throw new IllegalStateException();
            }
            return this.dataServices.toArray(new UUID[0]);
        }

        protected TxState(long tx, long readCommitTime) {
            if (tx == 0L) {
                throw new IllegalArgumentException();
            }
            if (tx == -1L) {
                throw new IllegalArgumentException();
            }
            if (readCommitTime < 0L) {
                throw new IllegalArgumentException();
            }
            this.tx = tx;
            this.readsOnCommitTime = readCommitTime;
            this.readOnly = TimestampUtility.isReadOnly(tx);
            this.hashCode = Long.valueOf(tx).hashCode();
            this.dataServices = this.readOnly ? null : new LinkedHashSet();
            this.resources = this.readOnly ? null : new LinkedHashSet();
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ITx)) {
                return false;
            }
            ITx t = (ITx)o;
            return this.tx == t.getStartTimestamp();
        }

        public final void declareResources(UUID dataService, String[] resource) {
            if (dataService == null) {
                throw new IllegalArgumentException();
            }
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.readOnly) {
                throw new IllegalStateException(AbstractTransactionService.ERR_READ_ONLY);
            }
            if (!this.isActive()) {
                throw new IllegalStateException(AbstractTransactionService.ERR_NOT_ACTIVE);
            }
            this.dataServices.add(dataService);
            this.resources.addAll(Arrays.asList(resource));
            if (log.isInfoEnabled()) {
                log.info((Object)("dataService=" + dataService + ", resource=" + Arrays.toString(resource)));
            }
        }

        public final int getDataServiceCount() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (this.readOnly) {
                throw new IllegalStateException(AbstractTransactionService.ERR_READ_ONLY);
            }
            return this.dataServices.size();
        }

        final boolean isDistributedTx() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            return !this.readOnly && this.dataServices.size() > 1;
        }

        public final String toString() {
            return "GlobalTxState{tx=" + this.tx + ",readsOnCommitTime=" + this.readsOnCommitTime + ",readOnly=" + this.readOnly + ",runState=" + (Object)((Object)this.runState) + "}";
        }

        @Override
        public final boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public final boolean isActive() {
            return this.runState == RunState.Active;
        }

        @Override
        public final boolean isPrepared() {
            return this.runState == RunState.Prepared;
        }

        @Override
        public final boolean isComplete() {
            RunState tmp = this.runState;
            return tmp == RunState.Committed || tmp == RunState.Aborted;
        }

        @Override
        public final boolean isCommitted() {
            return this.runState == RunState.Committed;
        }

        @Override
        public final boolean isAborted() {
            return this.runState == RunState.Aborted;
        }
    }

    public static interface Options {
        public static final String MIN_RELEASE_AGE = AbstractTransactionService.class.getName() + ".minReleaseAge";
        public static final String MIN_RELEASE_AGE_NO_HISTORY = "0";
        public static final String MIN_RELEASE_AGE_1M = "60000";
        public static final String MIN_RELEASE_AGE_5M = "300000";
        public static final String MIN_RELEASE_AGE_1H = "3600000";
        public static final String MIN_RELEASE_AGE_1D = "86400000";
        public static final String MIN_RELEASE_AGE_1W = "604800000";
        public static final String MIN_RELEASE_AGE_NEVER = "9223372036854775807";
        public static final String DEFAULT_MIN_RELEASE_AGE = "1";
    }
}

