/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.ITermDocRecord;

public class ReadOnlyTermDocRecord<V extends Comparable<V>>
implements ITermDocRecord<V> {
    private final String text;
    private final V docId;
    private final Integer fieldId;
    private final double termWeight;

    public ReadOnlyTermDocRecord(String text, V docId, int fieldId, double termWeight) {
        if (docId == null) {
            throw new IllegalArgumentException();
        }
        this.text = text;
        this.docId = docId;
        this.fieldId = fieldId;
        this.termWeight = termWeight;
    }

    public String toString() {
        return this.getClass().getName() + "{text=" + this.text + ", docId=" + this.docId + ", fieldId=" + this.fieldId + ", termWeight=" + this.termWeight + "}";
    }

    @Override
    public String getToken() {
        if (this.text == null) {
            throw new UnsupportedOperationException();
        }
        return this.text;
    }

    @Override
    public V getDocId() {
        return this.docId;
    }

    @Override
    public int getFieldId() throws UnsupportedOperationException {
        if (this.fieldId == Integer.MIN_VALUE) {
            throw new UnsupportedOperationException();
        }
        return this.fieldId;
    }

    @Override
    public double getLocalTermWeight() {
        return this.termWeight;
    }
}

