/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.BTree;
import com.bigdata.btree.BTreeCounters;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentBuilder;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.view.FusedView;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.cache.LRUCache;
import com.bigdata.concurrent.NamedLock;
import com.bigdata.counters.CounterSet;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.rawstore.IRawStore;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.IndexCache;
import com.bigdata.resources.NoSuchStoreException;
import com.bigdata.resources.StaleLocatorException;
import com.bigdata.resources.StaleLocatorReason;
import com.bigdata.resources.StoreManager;
import com.bigdata.service.Event;
import com.bigdata.service.EventType;
import com.bigdata.util.NT;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public abstract class IndexManager
extends StoreManager {
    private static final Logger log = Logger.getLogger(IndexManager.class);
    private final ConcurrentHashMap<String, Void> disabledShards = new ConcurrentHashMap();
    private final IndexCache<ILocalBTreeView> indexCache;
    private final ConcurrentWeakValueCacheWithTimeout<UUID, IndexSegment> indexSegmentCache;
    private final transient NamedLock<NT> namedLock = new NamedLock();
    private final transient NamedLock<UUID> segmentLock = new NamedLock();
    protected final LRUCache<String, StaleLocatorReason> staleLocatorCache = new LRUCache(1000);
    protected final ConcurrentHashMap<File, IndexSegmentBuilder> buildTasks = new ConcurrentHashMap();
    protected final AtomicInteger concurrentBuildTaskCount = new AtomicInteger();
    protected final AtomicInteger concurrentMergeTaskCount = new AtomicInteger();
    private final ConcurrentHashMap<String, BTreeCounters> indexCounters = new ConcurrentHashMap();
    private Map<String, BTreeCounters> mark = new HashMap<String, BTreeCounters>();

    public void disableWrites(String name) {
        this.disabledShards.putIfAbsent(name, null);
    }

    public void enableWrites(String name) {
        this.disabledShards.remove(name);
    }

    public boolean isDisabledWrites(String name) {
        return this.disabledShards.contains(name);
    }

    @Override
    protected long getIndexRetentionTime() {
        long t = this.indexCache.getRetentionTime();
        assert (t > 0L) : "t=" + t;
        return t;
    }

    public int getIndexCacheSize() {
        return this.indexCache.size();
    }

    public int getIndexCacheCapacity() {
        return this.indexCache.capacity();
    }

    public int getIndexSegmentCacheSize() {
        return this.indexSegmentCache.size();
    }

    public int getIndexSegmentCacheCapacity() {
        return this.indexSegmentCache.capacity();
    }

    @Override
    public StaleLocatorReason getIndexPartitionGone(String name) {
        return (StaleLocatorReason)((Object)this.staleLocatorCache.get((Object)name));
    }

    protected void setIndexPartitionGone(String name, StaleLocatorReason reason) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (reason == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("name=" + name + ", reason=" + (Object)((Object)reason)));
        }
        this.staleLocatorCache.put((Object)name, (Object)reason, true);
        this.indexCounters.remove(name);
    }

    protected int getStaleLocatorCount() {
        return this.staleLocatorCache.size();
    }

    protected IndexManager(Properties properties) {
        super(properties);
        int indexCacheCapacity = Integer.parseInt(properties.getProperty(Options.INDEX_CACHE_CAPACITY, "20"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.INDEX_CACHE_CAPACITY + "=" + indexCacheCapacity));
        }
        if (indexCacheCapacity <= 0) {
            throw new RuntimeException(Options.INDEX_CACHE_CAPACITY + " must be positive");
        }
        long indexCacheTimeout = Long.parseLong(properties.getProperty(Options.INDEX_CACHE_TIMEOUT, "60000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.INDEX_CACHE_TIMEOUT + "=" + indexCacheTimeout));
        }
        if (indexCacheTimeout < 0L) {
            throw new RuntimeException(Options.INDEX_CACHE_TIMEOUT + " must be non-negative");
        }
        this.indexCache = new IndexCache(indexCacheCapacity, indexCacheTimeout);
        int indexSegmentCacheCapacity = Integer.parseInt(properties.getProperty(Options.INDEX_SEGMENT_CACHE_CAPACITY, "60"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.INDEX_SEGMENT_CACHE_CAPACITY + "=" + indexSegmentCacheCapacity));
        }
        if (indexSegmentCacheCapacity <= 0) {
            throw new RuntimeException(Options.INDEX_SEGMENT_CACHE_CAPACITY + " must be positive");
        }
        long indexSegmentCacheTimeout = Long.parseLong(properties.getProperty(Options.INDEX_SEGMENT_CACHE_TIMEOUT, "60000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.INDEX_SEGMENT_CACHE_TIMEOUT + "=" + indexSegmentCacheTimeout));
        }
        if (indexSegmentCacheTimeout < 0L) {
            throw new RuntimeException(Options.INDEX_SEGMENT_CACHE_TIMEOUT + " must be non-negative");
        }
        this.indexSegmentCache = new ConcurrentWeakValueCacheWithTimeout(indexSegmentCacheCapacity, TimeUnit.MILLISECONDS.toNanos(indexSegmentCacheTimeout));
    }

    public AbstractBTree getIndexOnStore(String name, long timestamp, IRawStore store) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (store == null) {
            throw new IllegalArgumentException();
        }
        AbstractBTree btree = store instanceof IJournal ? this.getIndexOnJournal(name, timestamp, (AbstractJournal)store) : this.getIndexOnSegment(name, timestamp, (IndexSegmentStore)store);
        if (btree != null) {
            btree.setBTreeCounters(this.getIndexCounters(name));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("name=" + name + ", timestamp=" + timestamp + ", found=" + (btree != null) + ", store=" + store + " : " + btree));
        }
        return btree;
    }

    private final AbstractBTree getIndexOnJournal(String name, long timestamp, AbstractJournal journal) {
        BTree btree;
        if (timestamp == 0L) {
            btree = journal.getIndex(name);
        } else if (timestamp == -1L) {
            ICommitRecord commitRecord = journal.getCommitRecord();
            long ts = commitRecord.getTimestamp();
            if (ts == 0L) {
                log.warn((Object)"Nothing committed: read-committed operation.");
                return null;
            }
            btree = (BTree)journal.getIndexWithCommitRecord(name, commitRecord);
            if (btree != null) assert (btree.getLastCommitTime() != 0L);
        } else {
            long ts = Math.abs(timestamp);
            ICommitRecord commitRecord = journal.getCommitRecord(ts);
            if (commitRecord == null) {
                log.warn((Object)("Resource has no data for timestamp: name=" + name + ", timestamp=" + timestamp + ", resource=" + journal.getResourceMetadata()));
                return null;
            }
            btree = (BTree)journal.getIndexWithCommitRecord(name, commitRecord);
            if (btree == null) {
                log.warn((Object)("Index not found: name=" + name + ", timestamp=" + TimestampUtility.toString(timestamp) + ", ts=" + ts + ", commitRecord=" + commitRecord + ", ds=" + this.getDataServiceUUID()));
            }
            if (btree != null) assert (btree.getLastCommitTime() != 0L);
        }
        return btree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IndexSegment getIndexOnSegment(String name, long timestamp, IndexSegmentStore segStore) {
        IndexSegment btree;
        long ts;
        if (timestamp != -1L && timestamp != 0L && segStore.getCheckpoint().commitTime > (ts = Math.abs(timestamp))) {
            log.warn((Object)("Resource has no data for timestamp: name=" + name + ", timestamp=" + timestamp + ", store=" + segStore));
            return null;
        }
        IResourceMetadata resourceMetadata = segStore.getResourceMetadata();
        UUID storeUUID = resourceMetadata.getUUID();
        Lock lock = this.segmentLock.acquireLock(storeUUID);
        try {
            IndexSegment seg = (IndexSegment)this.indexSegmentCache.get((Object)storeUUID);
            if (seg == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading index segment from store: name=" + name + ", file=" + resourceMetadata.getFile()));
                }
                seg = segStore.loadIndexSegment();
                this.indexSegmentCache.put((Object)storeUUID, (Object)seg);
            }
            btree = seg;
        }
        finally {
            lock.unlock();
        }
        return btree;
    }

    @Override
    public AbstractBTree[] getIndexSources(String name, long timestamp) {
        AbstractJournal journal;
        if (log.isInfoEnabled()) {
            log.info((Object)("name=" + name + ", timestamp=" + timestamp));
        }
        if ((journal = this.getJournal(timestamp)) == null) {
            log.warn((Object)("No journal with data for timestamp: name=" + name + ", timestamp=" + timestamp));
            return null;
        }
        BTree btree = (BTree)this.getIndexOnStore(name, timestamp, journal);
        if (btree == null) {
            log.warn((Object)("No such index: name=" + name + ", timestamp=" + TimestampUtility.toString(timestamp)));
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("name=" + name + ", timestamp=" + timestamp + ", counter=" + btree.getCounter().get() + ", journal=" + journal.getResourceMetadata()));
        }
        return this.getIndexSources(name, timestamp, btree);
    }

    @Override
    public AbstractBTree[] getIndexSources(String name, long timestamp, BTree btree) {
        LocalPartitionMetadata pmd = btree.getIndexMetadata().getPartitionMetadata();
        if (pmd == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unpartitioned index: name=" + name + ", ts=" + timestamp));
            }
            return new AbstractBTree[]{btree};
        }
        IResourceMetadata[] a = pmd.getResources();
        assert (a != null) : "No resources: name=" + name + ", pmd=" + pmd;
        AbstractBTree[] sources = new AbstractBTree[a.length];
        sources[0] = btree;
        for (int i = 1; i < a.length; ++i) {
            IRawStore store;
            IResourceMetadata resource = a[i];
            try {
                store = this.openStore(resource.getUUID());
            }
            catch (NoSuchStoreException ex) {
                throw new NoSuchStoreException("Could not load index: name=" + name + ", timestamp=" + timestamp + ", storeUUID=" + resource.getUUID() + ", storeFile=" + resource.getFile() + ", pmd=" + pmd + " : " + ex, ex);
            }
            long ts = timestamp == 0L || timestamp == -1L ? (store instanceof IndexSegmentStore ? ((IndexSegmentStore)store).getCheckpoint().commitTime : (resource.getCommitTime() == 0L ? ((AbstractJournal)store).getRootBlockView().getLastCommitTime() : resource.getCommitTime())) : timestamp;
            assert (ts != 0L);
            assert (ts != -1L);
            AbstractBTree ndx = this.getIndexOnStore(name, ts, store);
            if (ndx == null) {
                throw new RuntimeException("Could not load component index: name=" + name + ", timestamp=" + timestamp + ", resource=" + resource);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Added to view: " + resource));
            }
            sources[i] = ndx;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Opened index partition:  name=" + name + ", timestamp=" + timestamp));
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ILocalBTreeView getIndex(String name, long timestamp) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.indexCacheLock.readLock().lock();
        try {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block33: {
                                block34: {
                                    block32: {
                                        if (timestamp == -1L) {
                                            timestamp = this.getLiveJournal().getRootBlockView().getLastCommitTime();
                                        }
                                        nt = new NT(name, timestamp);
                                        lock = this.namedLock.acquireLock(nt);
                                        try {
                                            if (timestamp == -1L || (ndx = (ILocalBTreeView)this.indexCache.get(nt)) == null) break block32;
                                            if (IndexManager.log.isInfoEnabled()) {
                                                IndexManager.log.info((Object)("Cache hit: " + nt));
                                            }
                                            var7_7 = ndx;
                                            lock.unlock();
                                            return var7_7;
                                        }
                                        catch (Throwable var13_19) {
                                            lock.unlock();
                                            throw var13_19;
                                        }
                                    }
                                    isReadWriteTx = TimestampUtility.isReadWriteTx(timestamp);
                                    v0 = tx = isReadWriteTx != false ? this.getConcurrencyManager().getTransactionManager().getTx(timestamp) : null;
                                    if (!isReadWriteTx) break block33;
                                    if (tx != null) break block34;
                                    IndexManager.log.warn((Object)("Unknown transaction: name=" + name + ", tx=" + timestamp));
                                    var8_9 = null;
                                    lock.unlock();
                                    return var8_9;
                                }
                                if (tx.isActive()) break block33;
                                IndexManager.log.warn((Object)("Transaction not active: name=" + name + ", tx=" + timestamp + ", prepared=" + tx.isPrepared() + ", complete=" + tx.isComplete() + ", aborted=" + tx.isAborted()));
                                var8_10 = null;
                                lock.unlock();
                                return var8_10;
                            }
                            if (!isReadWriteTx || tx != null) break block35;
                            IndexManager.log.warn((Object)("No such transaction: name=" + name + ", tx=" + tx));
                            var8_11 = null;
                            lock.unlock();
                            return var8_11;
                        }
                        readOnly = TimestampUtility.isReadOnly(timestamp);
                        if (!isReadWriteTx) ** GOTO lbl60
                        isolatedIndex = tx.getIndex(name);
                        if (isolatedIndex != null) break block36;
                        IndexManager.log.warn((Object)("No such index: name=" + name + ", timestamp=" + TimestampUtility.toString(timestamp)));
                        var11_14 = null;
                        lock.unlock();
                        return var11_14;
                    }
                    tmp = isolatedIndex;
                    ** GOTO lbl95
lbl60:
                    // 1 sources

                    if (!readOnly) ** GOTO lbl77
                    if (timestamp == -1L && (reason = this.getIndexPartitionGone(name)) != null) {
                        throw new StaleLocatorException(name, reason);
                    }
                    sources = this.getIndexSources(name, timestamp);
                    if (sources != null) break block37;
                    IndexManager.log.warn((Object)("No such index: name=" + name + ", timestamp=" + TimestampUtility.toString(timestamp)));
                    var11_15 = null;
                    lock.unlock();
                    return var11_15;
                }
                if (!IndexManager.$assertionsDisabled && sources.length <= 0) {
                    throw new AssertionError();
                }
                if (!IndexManager.$assertionsDisabled && !sources[0].isReadOnly()) {
                    throw new AssertionError();
                }
                tmp = sources.length == 1 ? (BTree)sources[0] : new FusedView(sources);
                ** GOTO lbl95
lbl77:
                // 1 sources

                if (!IndexManager.$assertionsDisabled && timestamp != 0L) {
                    throw new AssertionError((Object)("timestamp=" + timestamp));
                }
                reason = this.getIndexPartitionGone(name);
                if (reason != null) {
                    throw new StaleLocatorException(name, reason);
                }
                if (this.isDisabledWrites(name)) {
                    throw new RuntimeException("Index writes disabled: " + name);
                }
                sources = this.getIndexSources(name, 0L);
                if (sources != null) break block38;
                IndexManager.log.warn((Object)("No such index: name=" + name + ", timestamp=" + TimestampUtility.toString(timestamp)));
                var12_18 = null;
                lock.unlock();
                return var12_18;
            }
            if (!IndexManager.$assertionsDisabled && sources[0].isReadOnly()) {
                throw new AssertionError();
            }
            tmp = sources.length == 1 ? (BTree)sources[0] : new FusedView(sources);
lbl95:
            // 3 sources

            if (timestamp != -1L && timestamp != 0L) {
                if (IndexManager.log.isInfoEnabled()) {
                    IndexManager.log.info((Object)("Adding to cache: " + nt));
                }
                this.indexCache.put(nt, tmp);
            }
            var10_13 = tmp;
            lock.unlock();
            return var10_13;
        }
        finally {
            this.indexCacheLock.readLock().unlock();
        }
    }

    public String listIndexPartitions(long timestamp) {
        if (timestamp == 0L || timestamp == -1L) {
            timestamp = this.getLiveJournal().getLastCommitTime();
        }
        StringBuilder sb = new StringBuilder();
        AbstractJournal journal = this.getJournal(timestamp);
        if (journal == null) {
            return "No journal: timestamp=" + timestamp;
        }
        sb.append("timestamp=" + timestamp + "\njournal=" + journal.getResourceMetadata());
        Iterator<String> itr = journal.indexNameScan(null, timestamp);
        while (itr.hasNext()) {
            String name = itr.next();
            BTree btree = (BTree)journal.getIndexLocal(name, timestamp);
            assert (btree != null) : name;
            IndexMetadata indexMetadata = btree.getIndexMetadata();
            LocalPartitionMetadata pmd = indexMetadata.getPartitionMetadata();
            sb.append("\nname=" + name + ", checkpoint=" + btree.getCheckpoint() + ", pmd=" + pmd);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult buildIndexSegment(String indexPartitionName, ILocalBTreeView src, boolean compactingMerge, long commitTime, byte[] fromKey, byte[] toKey, Event parentEvent) throws Exception {
        if (indexPartitionName == null) {
            throw new IllegalArgumentException();
        }
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (parentEvent == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("name", indexPartitionName);
        m.put("merge", compactingMerge);
        m.put("#sources", src.getSourceCount());
        long sumSegBytes = 0L;
        for (AbstractBTree tmp : src.getSources()) {
            if (!(tmp instanceof IndexSegment)) continue;
            sumSegBytes += ((IndexSegment)tmp).getStore().size();
        }
        m.put("MB(in)", fpf.format((double)sumSegBytes / 1048576.0));
        m.put("#build", this.concurrentBuildTaskCount.get() + 1);
        m.put("#merge", this.concurrentMergeTaskCount.get() + 1);
        Event e = parentEvent.newSubEvent((Object)EventType.IndexSegmentBuild, m).start();
        File outFile = null;
        try {
            SegmentMetadata segmentMetadata;
            IndexSegmentBuilder builder;
            IndexMetadata indexMetadata;
            try {
                indexMetadata = src.getIndexMetadata();
                outFile = this.getIndexSegmentFile(indexMetadata);
                builder = IndexSegmentBuilder.newInstance(src, outFile, this.tmpDir, compactingMerge, commitTime, fromKey, toKey);
                try {
                    this.buildTasks.put(outFile, builder);
                    if (compactingMerge) {
                        this.concurrentMergeTaskCount.incrementAndGet();
                    } else {
                        this.concurrentBuildTaskCount.incrementAndGet();
                    }
                    builder.call();
                }
                finally {
                    this.buildTasks.remove(outFile);
                    if (compactingMerge) {
                        this.concurrentMergeTaskCount.decrementAndGet();
                    } else {
                        this.concurrentBuildTaskCount.decrementAndGet();
                    }
                }
                long nbytes = builder.getCheckpoint().length;
                float mbPerSec = builder.mbPerSec;
                e.addDetail("filename", outFile);
                e.addDetail("expectedNodeCount", builder.plan.nnodes);
                e.addDetail("expectedLeafCount", builder.plan.nleaves);
                e.addDetail("expectedRangeCount", builder.plan.nentries);
                e.addDetail("actualNodeCount", builder.getCheckpoint().nnodes);
                e.addDetail("actualLeafCount", builder.getCheckpoint().nleaves);
                e.addDetail("actualRangeCount", builder.getCheckpoint().nentries);
                e.addDetail("commitTime", commitTime);
                e.addDetail("elapsed", builder.elapsed);
                e.addDetail("MB(out)", fpf.format((double)nbytes / 1048576.0));
                e.addDetail("MB/s", fpf.format(mbPerSec));
                segmentMetadata = new SegmentMetadata(outFile, builder.segmentUUID, commitTime);
                this.retentionSetAdd(segmentMetadata.getUUID());
                this.addResource(segmentMetadata, outFile);
            }
            catch (Throwable t) {
                if (outFile != null && outFile.exists()) {
                    try {
                        outFile.delete();
                    }
                    catch (Throwable t2) {
                        log.warn((Object)t2.getLocalizedMessage(), t2);
                    }
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
            try {
                BuildResult tmp = new BuildResult(indexPartitionName, compactingMerge, src.getSources(), indexMetadata, segmentMetadata, builder);
                if (log.isInfoEnabled()) {
                    log.info((Object)("built index segment: " + tmp));
                }
                BuildResult t2 = tmp;
                return t2;
            }
            catch (Throwable t) {
                try {
                    this.retentionSetRemove(segmentMetadata.getUUID());
                }
                catch (Throwable t2) {
                    log.warn((Object)t2.getLocalizedMessage(), t2);
                }
                try {
                    this.deleteResource(segmentMetadata.getUUID(), false);
                }
                catch (Throwable t2) {
                    log.warn((Object)t2.getLocalizedMessage(), t2);
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException(t);
            }
        }
        finally {
            e.end();
        }
    }

    @Override
    public BTreeCounters getIndexCounters(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        BTreeCounters t = this.indexCounters.get(name);
        if (t == null) {
            t = new BTreeCounters();
            BTreeCounters oldval = this.indexCounters.putIfAbsent(name, t);
            if (oldval != null) {
                t = oldval;
            } else if (log.isInfoEnabled()) {
                log.info((Object)("New counters: indexPartitionName=" + name));
            }
        }
        assert (t != null);
        return t;
    }

    protected synchronized Map<String, BTreeCounters> markAndGetDelta() {
        HashMap<String, BTreeCounters> newMark = new HashMap<String, BTreeCounters>();
        HashMap<String, BTreeCounters> delta = new HashMap<String, BTreeCounters>();
        for (Map.Entry<String, BTreeCounters> entry : this.indexCounters.entrySet()) {
            String name = entry.getKey();
            BTreeCounters current = entry.getValue();
            BTreeCounters prior = this.mark.get(name);
            if (prior == null) {
                delta.put(name, current);
                if (log.isInfoEnabled()) {
                    log.info((Object)("First time: " + name));
                }
            } else {
                delta.put(name, current.subtract(prior));
                if (log.isInfoEnabled()) {
                    log.info((Object)("Computed delta: " + name));
                }
            }
            newMark.put(name, current);
        }
        this.mark = newMark;
        return delta;
    }

    public CounterSet getIndexCounters() {
        CounterSet tmp = new CounterSet();
        for (Map.Entry<String, BTreeCounters> entry : this.indexCounters.entrySet()) {
            String name = entry.getKey();
            BTreeCounters btreeCounters = entry.getValue();
            assert (btreeCounters != null) : "name=" + name;
            int indexOf = name.lastIndexOf(35);
            String path = indexOf != -1 ? name.substring(0, indexOf) + "/" + name : name;
            CounterSet t = tmp.makePath(path);
            t.attach(btreeCounters.getCounters());
        }
        return tmp;
    }

    public static class IndexSegmentStats {
        public long leafCount;
        public long leafByteCount;
    }

    public static interface IIndexManagerCounters {
        public static final String Indices = "indices";
        public static final String StaleLocatorCacheCapacity = "Stale Locator Cache Capacity";
        public static final String StaleLocatorCacheSize = "Stale Locator Cache Size";
        public static final String StaleLocators = "Stale Locators";
        public static final String IndexCount = "Index Count";
        public static final String IndexCacheCapacity = "Index Cache Capacity";
        public static final String IndexCacheSize = "Index Cache Size";
        public static final String IndexSegmentCacheCapacity = "Index Segment Cache Capacity";
        public static final String IndexSegmentCacheSize = "Index Segment Cache Size";
        public static final String IndexSegmentOpenLeafCount = "Index Segment Open Leaf Count";
        public static final String IndexSegmentOpenLeafByteCount = "Index Segment Open Leaf Byte Count";
    }

    public static interface Options
    extends StoreManager.Options {
        public static final String INDEX_CACHE_CAPACITY = IndexManager.class.getName() + ".indexCacheCapacity";
        public static final String DEFAULT_INDEX_CACHE_CAPACITY = "20";
        public static final String INDEX_CACHE_TIMEOUT = IndexManager.class.getName() + ".indexCacheTimeout";
        public static final String DEFAULT_INDEX_CACHE_TIMEOUT = "60000";
        public static final String INDEX_SEGMENT_CACHE_CAPACITY = IndexManager.class.getName() + ".indexSegmentCacheCapacity";
        public static final String DEFAULT_INDEX_SEGMENT_CACHE_CAPACITY = "60";
        public static final String INDEX_SEGMENT_CACHE_TIMEOUT = IndexManager.class.getName() + ".indexCacheTimeout";
        public static final String DEFAULT_INDEX_SEGMENT_CACHE_TIMEOUT = "60000";
    }
}

