/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.resources;

import com.bigdata.btree.BTree;
import com.bigdata.btree.ILocalBTreeView;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.ScatterSplitConfiguration;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.BatchLookup;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.AbstractTask;
import com.bigdata.journal.ConcurrencyManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.LocalPartitionMetadata;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.resources.AbstractPrepareTask;
import com.bigdata.resources.BuildResult;
import com.bigdata.resources.CompactingMergeTask;
import com.bigdata.resources.IncrementalBuildTask;
import com.bigdata.resources.JoinIndexPartitionTask;
import com.bigdata.resources.MoveTask;
import com.bigdata.resources.OverflowActionEnum;
import com.bigdata.resources.OverflowManager;
import com.bigdata.resources.OverflowMetadata;
import com.bigdata.resources.Priority;
import com.bigdata.resources.ResourceManager;
import com.bigdata.resources.ScatterSplitTask;
import com.bigdata.resources.Score;
import com.bigdata.resources.SplitIndexPartitionTask;
import com.bigdata.resources.SplitTailTask;
import com.bigdata.resources.StaleLocatorReason;
import com.bigdata.resources.ViewMetadata;
import com.bigdata.service.DataService;
import com.bigdata.service.Event;
import com.bigdata.service.EventResource;
import com.bigdata.service.EventType;
import com.bigdata.service.ILoadBalancerService;
import com.bigdata.service.MetadataService;
import com.bigdata.util.DaemonThreadFactory;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.LatchedExecutor;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class AsynchronousOverflowTask
implements Callable<Object> {
    protected static final Logger log = Logger.getLogger(AsynchronousOverflowTask.class);
    private final ResourceManager resourceManager;
    private final OverflowMetadata overflowMetadata;
    private final long lastCommitTime;
    private final Map<String, String> used = new TreeMap<String, String>();
    private static final List<AbstractTask> EMPTY_LIST = Collections.EMPTY_LIST;

    private boolean isUsed(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.used.containsKey(name);
    }

    protected void putUsed(String name, String action) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (action == null) {
            throw new IllegalArgumentException();
        }
        if (this.used.containsKey(name)) {
            throw new IllegalStateException("Already used: " + name);
        }
        this.used.put(name, action);
    }

    public AsynchronousOverflowTask(ResourceManager resourceManager, OverflowMetadata overflowMetadata) {
        if (resourceManager == null) {
            throw new IllegalArgumentException();
        }
        if (overflowMetadata == null) {
            throw new IllegalArgumentException();
        }
        this.resourceManager = resourceManager;
        this.overflowMetadata = overflowMetadata;
        this.lastCommitTime = overflowMetadata.lastCommitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Future<?>> scheduleAndAwaitTasks(boolean forceCompactingMerges) throws InterruptedException {
        LinkedList linkedList;
        Iterator<ViewMetadata> itr = this.overflowMetadata.views();
        PriorityBlockingQueue<Priority<ViewMetadata>> buildList = new PriorityBlockingQueue<Priority<ViewMetadata>>(this.overflowMetadata.getIndexCount());
        PriorityBlockingQueue<Priority<ViewMetadata>> mergeList = new PriorityBlockingQueue<Priority<ViewMetadata>>(this.overflowMetadata.getIndexCount());
        while (itr.hasNext()) {
            ViewMetadata vmd = itr.next();
            String name = vmd.name;
            if (this.overflowMetadata.isCopied(name)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("was  copied : " + vmd));
                }
            } else {
                buildList.add(new Priority<ViewMetadata>(vmd.buildPriority, vmd));
            }
            if (!(vmd.mergePriority > 0.0) && (!forceCompactingMerges || vmd.sourceCount <= 1)) continue;
            mergeList.add(new Priority<ViewMetadata>(vmd.mergePriority, vmd));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Scheduling tasks: buildList=" + buildList.size() + ", mergeList=" + mergeList.size()));
        }
        LinkedList<FutureTask<BuildResult>> mergeFutures = new LinkedList<FutureTask<BuildResult>>();
        LinkedList<FutureTask<BuildResult>> buildFutures = new LinkedList<FutureTask<BuildResult>>();
        try {
            ViewMetadata vmd;
            LatchedExecutor buildService = new LatchedExecutor(this.resourceManager.getFederation().getExecutorService(), this.resourceManager.buildServiceCorePoolSize);
            LatchedExecutor mergeService = new LatchedExecutor(this.resourceManager.getFederation().getExecutorService(), this.resourceManager.mergeServiceCorePoolSize);
            for (Priority linkedList2 : mergeList) {
                vmd = (ViewMetadata)linkedList2.v;
                if (!(vmd.mergePriority > 0.0) && !forceCompactingMerges) continue;
                if (forceCompactingMerges && OverflowActionEnum.Copy.equals((Object)vmd.getAction())) {
                    vmd.clearCopyAction();
                }
                FutureTask<BuildResult> futureTask = new FutureTask<BuildResult>(new AtomicCallable<BuildResult>(OverflowActionEnum.Merge, vmd, forceCompactingMerges, new CompactingMergeTask(vmd)));
                mergeFutures.add(futureTask);
                mergeService.execute(futureTask);
            }
            for (Priority priority : buildList) {
                vmd = (ViewMetadata)priority.v;
                if (forceCompactingMerges && !vmd.compactView) {
                    FutureTask<BuildResult> futureTask = new FutureTask<BuildResult>(new AtomicCallable<BuildResult>(OverflowActionEnum.Merge, vmd, forceCompactingMerges, new CompactingMergeTask(vmd)));
                    mergeFutures.add(futureTask);
                    mergeService.execute(futureTask);
                    continue;
                }
                FutureTask<BuildResult> futureTask = new FutureTask<BuildResult>(new AtomicCallable<BuildResult>(OverflowActionEnum.Build, vmd, forceCompactingMerges, new IncrementalBuildTask(vmd)));
                buildFutures.add(futureTask);
                buildService.execute(futureTask);
            }
            for (Future future : buildFutures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {}
            }
            for (Future future : mergeFutures) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {}
            }
            LinkedList allFutures = new LinkedList();
            allFutures.addAll(buildFutures);
            allFutures.addAll(mergeFutures);
            linkedList = allFutures;
        }
        catch (Throwable throwable) {
            for (Future f : buildFutures) {
                f.cancel(true);
            }
            for (Future f : mergeFutures) {
                f.cancel(true);
            }
            throw throwable;
        }
        for (Future future : buildFutures) {
            future.cancel(true);
        }
        for (Future future : mergeFutures) {
            future.cancel(true);
        }
        return linkedList;
    }

    protected List<AbstractTask> chooseScatterSplits() {
        LinkedList<AbstractTask> tasks = new LinkedList<AbstractTask>();
        Iterator<ViewMetadata> itr = this.overflowMetadata.views();
        UUID[] moveTargets = null;
        while (itr.hasNext()) {
            ViewMetadata vmd = itr.next();
            String name = vmd.name;
            if (this.isUsed(name) || this.overflowMetadata.isCopied(name)) continue;
            ScatterSplitConfiguration ssc = vmd.indexMetadata.getScatterSplitConfiguration();
            if (vmd.getIndexPartitionCount() != 1L || vmd.pmd.getSourcePartitionId() != -1 || !this.resourceManager.scatterSplitEnabled || !ssc.isEnabled() || !vmd.compactView || !(vmd.getPercentOfSplit() >= ssc.getPercentOfSplitThreshold())) continue;
            if (moveTargets == null) {
                UUID[] a = this.resourceManager.getFederation().getDataServiceUUIDs(ssc.getDataServiceCount());
                if (a == null || a.length == 1) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Will not scatter split - insufficient data services discovered.");
                    }
                    return tasks;
                }
                HashSet<UUID> tmp = new HashSet<UUID>(Arrays.asList(a));
                tmp.add(this.resourceManager.getDataServiceUUID());
                moveTargets = tmp.toArray(new UUID[tmp.size()]);
            }
            int nsplits = ssc.getIndexPartitionCount() == 0 ? 2 * moveTargets.length : ssc.getIndexPartitionCount();
            ScatterSplitTask task = new ScatterSplitTask(vmd, nsplits, moveTargets);
            tasks.add(task);
            this.overflowMetadata.setAction(vmd.name, OverflowActionEnum.ScatterSplit);
            this.putUsed(name, "willScatter(name=" + vmd + ")");
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("will scatter: " + vmd));
        }
        return tasks;
    }

    protected List<AbstractTask> chooseJoins() {
        if (!this.resourceManager.joinsEnabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)(OverflowManager.Options.JOINS_ENABLED + "=" + this.resourceManager.joinsEnabled));
            }
            return EMPTY_LIST;
        }
        LinkedList<AbstractTask> tasks = new LinkedList<AbstractTask>();
        if (log.isInfoEnabled()) {
            log.info((Object)("begin: lastCommitTime=" + this.lastCommitTime));
        }
        HashMap<String, BTree> undercapacityIndexPartitions = new HashMap<String, BTree>();
        int ndone = 0;
        int nskip = 0;
        int njoin = 0;
        int nignored = 0;
        assert (this.used.isEmpty()) : "There are " + this.used.size() + " used index partitions";
        Iterator<ViewMetadata> itr = this.overflowMetadata.views();
        while (itr.hasNext()) {
            ViewMetadata vmd = itr.next();
            String name = vmd.name;
            ILocalBTreeView view = vmd.getView();
            if (view == null) {
                throw new AssertionError((Object)("Index not found? : name=" + name + ", lastCommitTime=" + this.lastCommitTime));
            }
            LocalPartitionMetadata pmd = vmd.pmd;
            if (pmd.getSourcePartitionId() != -1) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping index: name=" + name + ", reason=moveInProgress"));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Considering join: name=" + name + ", rangeCount=" + vmd.getRangeCount() + ", pmd=" + pmd));
            }
            if (pmd.getRightSeparatorKey() != null && vmd.getPercentOfSplit() < 0.5) {
                String scaleOutIndexName = vmd.indexMetadata.getName();
                BTree tmp = (BTree)undercapacityIndexPartitions.get(scaleOutIndexName);
                if (tmp == null) {
                    tmp = BTree.createTransient(new IndexMetadata(UUID.randomUUID()));
                    undercapacityIndexPartitions.put(scaleOutIndexName, tmp);
                }
                tmp.insert(pmd.getLeftSeparatorKey(), SerializerUtil.serialize(pmd));
                if (log.isInfoEnabled()) {
                    log.info((Object)("join candidate: " + name));
                }
                ++njoin;
            } else {
                ++nignored;
            }
            ++ndone;
        }
        assert (ndone == nskip + njoin + nignored) : "ndone=" + ndone + ", nskip=" + nskip + ", njoin=" + njoin + ", nignored=" + nignored;
        Iterator itr2 = undercapacityIndexPartitions.entrySet().iterator();
        int ndone2 = 0;
        njoin = 0;
        int nmove = 0;
        assert (this.used.isEmpty()) : "There are " + this.used.size() + " used index partitions";
        UUID sourceDataService = this.resourceManager.getDataServiceUUID();
        while (itr2.hasNext()) {
            AbstractKeyArrayIndexProcedure.ResultBuffer resultBuffer;
            BTree tmp;
            Map.Entry entry = itr2.next();
            String scaleOutIndexName = (String)entry.getKey();
            if (log.isInfoEnabled()) {
                log.info((Object)("Considering join candidates: " + scaleOutIndexName));
            }
            if ((tmp = (BTree)entry.getValue()).getEntryCount() > Integer.MAX_VALUE) {
                log.error((Object)"Rediculous size for temp index.");
                continue;
            }
            int ncandidates = (int)tmp.getEntryCount();
            assert (ncandidates > 0) : "Expecting at least one candidate";
            ITupleIterator titr = tmp.rangeIterator();
            if (log.isInfoEnabled()) {
                log.info((Object)("Formulating rightSiblings query=" + scaleOutIndexName + ", #underutilized=" + ncandidates));
            }
            byte[][] keys = new byte[ncandidates][];
            LocalPartitionMetadata[] underUtilizedPartitions = new LocalPartitionMetadata[ncandidates];
            int i = 0;
            while (titr.hasNext()) {
                LocalPartitionMetadata pmd;
                ITuple tuple = titr.next();
                underUtilizedPartitions[i] = pmd = (LocalPartitionMetadata)SerializerUtil.deserialize(tuple.getValue());
                if (pmd.getRightSeparatorKey() == null) {
                    throw new AssertionError((Object)("The last index partition may not be a join candidate: name=" + scaleOutIndexName + ", " + pmd));
                }
                keys[i] = pmd.getRightSeparatorKey();
                ++i;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Looking for rightSiblings: name=" + scaleOutIndexName + ", #underutilized=" + ncandidates));
            }
            BatchLookup op = (BatchLookup)BatchLookup.BatchLookupConstructor.INSTANCE.newInstance(0, ncandidates, keys, null);
            try {
                resultBuffer = this.resourceManager.getFederation().getMetadataService().submit(TimestampUtility.asHistoricalRead(this.lastCommitTime), MetadataService.getMetadataIndexName(scaleOutIndexName), op).get();
            }
            catch (Exception e) {
                log.error((Object)("Could not locate rightSiblings: index=" + scaleOutIndexName), (Throwable)e);
                continue;
            }
            for (i = 0; i < ncandidates; ++i) {
                AbstractPrepareTask task;
                LocalPartitionMetadata pmd = underUtilizedPartitions[i];
                ViewMetadata vmd = this.overflowMetadata.getViewMetadata(DataService.getIndexPartitionName(scaleOutIndexName, pmd.getPartitionId()));
                PartitionLocator rightSiblingLocator = (PartitionLocator)SerializerUtil.deserialize(resultBuffer.getResult(i));
                UUID targetDataServiceUUID = rightSiblingLocator.getDataServiceUUID();
                Object[] resources = new String[]{DataService.getIndexPartitionName(scaleOutIndexName, pmd.getPartitionId()), DataService.getIndexPartitionName(scaleOutIndexName, rightSiblingLocator.getPartitionId())};
                if (sourceDataService.equals(targetDataServiceUUID)) {
                    if (this.isUsed(resources[0]) || this.isUsed(resources[1])) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Will JOIN: " + Arrays.toString(resources)));
                    }
                    ViewMetadata vmd2 = this.overflowMetadata.getViewMetadata(DataService.getIndexPartitionName(scaleOutIndexName, rightSiblingLocator.getPartitionId()));
                    task = new JoinIndexPartitionTask(this.resourceManager, this.lastCommitTime, (String[])resources, new ViewMetadata[]{vmd, vmd2});
                    tasks.add(task);
                    this.putUsed((String)resources[0], "willJoin(leftSibling=" + (String)resources[0] + ",rightSibling=" + (String)resources[1] + ")");
                    this.putUsed((String)resources[1], "willJoin(leftSibling=" + (String)resources[0] + ",rightSibling=" + (String)resources[1] + ")");
                    ++njoin;
                } else {
                    String targetDataServiceName;
                    if (this.isUsed(resources[0])) continue;
                    String sourceIndexName = DataService.getIndexPartitionName(scaleOutIndexName, pmd.getPartitionId());
                    task = new MoveTask(vmd, targetDataServiceUUID);
                    try {
                        targetDataServiceName = this.resourceManager.getFederation().getDataService(targetDataServiceUUID).getServiceName();
                    }
                    catch (Throwable t) {
                        targetDataServiceName = targetDataServiceUUID.toString();
                    }
                    tasks.add(task);
                    this.putUsed((String)resources[0], "willMoveToJoinWithRightSibling( " + sourceIndexName + " -> " + targetDataServiceName + ", leftSibling=" + (String)resources[0] + ", rightSibling=" + (String)resources[1] + ")");
                    ++nmove;
                }
                ++ndone2;
            }
        }
        assert (ndone2 == njoin + nmove);
        return tasks;
    }

    protected ILoadBalancerService getLoadBalancerService() {
        ILoadBalancerService loadBalancerService;
        try {
            loadBalancerService = this.resourceManager.getFederation().getLoadBalancerService();
        }
        catch (Exception ex) {
            log.warn((Object)"Could not discover the load balancer service", (Throwable)ex);
            return null;
        }
        if (loadBalancerService == null) {
            log.warn((Object)"Could not discover the load balancer service");
            return null;
        }
        return loadBalancerService;
    }

    protected boolean shouldMove(ILoadBalancerService loadBalancerService) {
        boolean highlyUtilizedService;
        if (loadBalancerService == null) {
            throw new IllegalArgumentException();
        }
        try {
            UUID serviceUUID = this.resourceManager.getDataServiceUUID();
            highlyUtilizedService = loadBalancerService.isHighlyUtilizedDataService(serviceUUID);
        }
        catch (Exception ex) {
            log.warn((Object)"Could not determine if this data service is highly utilized");
            return false;
        }
        if (!highlyUtilizedService) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Service is not highly utilized.");
            }
            return false;
        }
        OverflowManager.ResourceScores resourceScores = this.resourceManager.getResourceScores();
        boolean shouldMove = resourceScores.percentCPUTime >= this.resourceManager.movePercentCpuTimeThreshold || resourceScores.majorPageFaultsPerSec > 20.0 || resourceScores.dataDirBytesFree < 5.36870912E9 || resourceScores.dataDirBytesFree < 5.36870912E8;
        return shouldMove;
    }

    private List<AbstractTask> chooseMoves(ILoadBalancerService loadBalancerService) {
        ViewMetadata vmd;
        Object[] underUtilizedDataServiceUUIDs;
        if (this.resourceManager.maximumMovesPerTarget == 0) {
            return EMPTY_LIST;
        }
        int minActiveIndexPartitions = this.resourceManager.minimumActiveIndexPartitions;
        int nactive = this.overflowMetadata.getActiveCount();
        if (nactive <= minActiveIndexPartitions) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Preconditions for move not satisified: nactive=" + nactive + ", minActive=" + minActiveIndexPartitions));
            }
            return EMPTY_LIST;
        }
        int maxMovesPerTarget = this.resourceManager.maximumMovesPerTarget;
        UUID sourceServiceUUID = this.resourceManager.getDataServiceUUID();
        try {
            underUtilizedDataServiceUUIDs = loadBalancerService.getUnderUtilizedDataServices(0, 0, sourceServiceUUID);
        }
        catch (TimeoutException t) {
            log.warn((Object)t.getMessage());
            return EMPTY_LIST;
        }
        catch (InterruptedException t) {
            log.warn((Object)t.getMessage());
            return EMPTY_LIST;
        }
        catch (Throwable t) {
            log.error((Object)"Could not obtain target service UUIDs: ", t);
            return EMPTY_LIST;
        }
        if (underUtilizedDataServiceUUIDs == null || underUtilizedDataServiceUUIDs.length == 0) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Load balancer does not report any underutilized services.");
            }
            return EMPTY_LIST;
        }
        int nactiveSurplus = nactive - minActiveIndexPartitions;
        assert (nactiveSurplus > 0);
        assert (underUtilizedDataServiceUUIDs != null);
        int maxMoves = Math.min(this.resourceManager.maximumMoves, Math.min(nactiveSurplus, maxMovesPerTarget * underUtilizedDataServiceUUIDs.length));
        if (log.isInfoEnabled()) {
            log.info((Object)("Considering index partition moves: #targetServices=" + underUtilizedDataServiceUUIDs.length + ", maxMovesPerTarget=" + maxMovesPerTarget + ", nactive=" + nactive + ", maxMoves=" + maxMoves + ", sourceService=" + sourceServiceUUID + ", targetServices=" + Arrays.toString(underUtilizedDataServiceUUIDs)));
        }
        long maxRangeCount = 0L;
        LinkedList<Score> scores = new LinkedList<Score>();
        for (Score score : this.overflowMetadata.getScores()) {
            String name = score.name;
            if (this.isUsed(name)) continue;
            if (this.overflowMetadata.isCopied(name)) {
                this.putUsed(name, "wasCopied(name=" + name + ")");
                continue;
            }
            StaleLocatorReason reason = this.resourceManager.getIndexPartitionGone(score.name);
            if (reason != null) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping index: name=" + score.name + ", reason=" + (Object)((Object)reason)));
                continue;
            }
            ViewMetadata vmd2 = this.overflowMetadata.getViewMetadata(name);
            if (vmd2 == null) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping index: name=" + name + ", reason=dropped"));
                continue;
            }
            if (vmd2.pmd.getSourcePartitionId() != -1) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping index: name=" + name + ", reason=moveInProgress"));
                continue;
            }
            long rangeCount = vmd2.getRangeCount();
            if (vmd2.getPercentOfSplit() > this.resourceManager.maximumMovePercentOfSplit) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Skipping index: name=" + name + ", reason=shouldSplit"));
                continue;
            }
            scores.add(score);
            maxRangeCount = Math.max(maxRangeCount, rangeCount);
        }
        PriorityQueue<Priority<ViewMetadata>> moveQueue = new PriorityQueue<Priority<ViewMetadata>>();
        for (Score score : scores) {
            double movePriority;
            vmd = this.overflowMetadata.getViewMetadata(score.name);
            double moveMinScore = 0.1;
            boolean moveCandidate = score.drank >= 0.1;
            double d = movePriority = vmd.isTailSplit() ? score.drank / 0.1 : score.drank / vmd.getPercentOfSplit();
            if (log.isInfoEnabled()) {
                log.info((Object)(vmd.name + " : tailSplit=" + vmd.isTailSplit() + ", moveCandidate=" + moveCandidate + ", movePriority=" + movePriority + ", drank=" + score.drank + ", percentOfSplit=" + vmd.getPercentOfSplit() + " : " + vmd + " : " + score));
            }
            if (!moveCandidate) continue;
            moveQueue.add(new Priority<ViewMetadata>(movePriority, vmd));
        }
        int nmove = 0;
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>(maxMoves);
        while (nmove < maxMoves && !moveQueue.isEmpty()) {
            AbstractPrepareTask task;
            String targetDataServiceName;
            Object targetDataServiceUUID;
            vmd = (ViewMetadata)((Priority)moveQueue.poll()).v;
            if (log.isInfoEnabled()) {
                log.info((Object)("Considering move candidate: " + vmd));
            }
            if (sourceServiceUUID.equals(targetDataServiceUUID = underUtilizedDataServiceUUIDs[nmove % underUtilizedDataServiceUUIDs.length])) {
                log.error((Object)("LBS included the source data service in the set of possible targets: source=" + sourceServiceUUID + ", targets=" + Arrays.toString(underUtilizedDataServiceUUIDs)));
                continue;
            }
            try {
                targetDataServiceName = this.resourceManager.getFederation().getDataService((UUID)targetDataServiceUUID).getServiceName();
            }
            catch (Throwable t) {
                targetDataServiceName = ((UUID)targetDataServiceUUID).toString();
            }
            if (vmd.isTailSplit()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will tailSplit " + vmd.name + " and move the rightSibling to dataService=" + targetDataServiceName));
                }
                task = new SplitTailTask(vmd, (UUID)targetDataServiceUUID);
                tasks.add(task);
                this.putUsed(vmd.name, "willTailSplit + moveRightSibling(" + vmd.name + " -> " + targetDataServiceName + ") : " + vmd + " : " + this.overflowMetadata.getScore(vmd.name));
                ++nmove;
                continue;
            }
            if (vmd.getPercentOfSplit() > 0.5) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Will split " + vmd.name + " and move the smallest post-split index partition to dataService=" + targetDataServiceName));
                }
                task = new SplitIndexPartitionTask(vmd, (UUID)targetDataServiceUUID);
                tasks.add(task);
                this.putUsed(vmd.name, "willSplit+Move(" + vmd.name + " -> " + targetDataServiceName + ") : " + vmd + " : " + this.overflowMetadata.getScore(vmd.name));
                ++nmove;
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Will move " + vmd.name + " to dataService=" + targetDataServiceName));
            }
            task = new MoveTask(vmd, (UUID)targetDataServiceUUID);
            tasks.add(task);
            this.putUsed(vmd.name, "willMove(" + vmd.name + " -> " + targetDataServiceName + ") : " + vmd + " : " + this.overflowMetadata.getScore(vmd.name));
            ++nmove;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will move " + nmove + " index partitions based on utilization."));
        }
        return tasks;
    }

    protected List<AbstractTask> chooseTasks(boolean forceCompactingMerges) throws Exception {
        AbstractJournal oldJournal = this.resourceManager.getJournal(this.lastCommitTime);
        long oldJournalSize = oldJournal.size();
        if (log.isInfoEnabled()) {
            log.info((Object)("begin: lastCommitTime=" + this.lastCommitTime + ", compactingMerge=" + forceCompactingMerges + ", oldJournalSize=" + oldJournalSize));
        }
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>((int)oldJournal.getName2Addr().rangeCount());
        if (!forceCompactingMerges) {
            tasks.addAll(this.chooseScatterSplits());
            tasks.addAll(this.chooseJoins());
            ILoadBalancerService lbs = this.getLoadBalancerService();
            if (lbs != null && this.shouldMove(lbs)) {
                tasks.addAll(this.chooseMoves(lbs));
            }
        }
        tasks.addAll(this.chooseSplitBuildOrMerge(forceCompactingMerges));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.used.entrySet()) {
            sb.append("\n" + entry.getKey() + "\t = " + entry.getValue());
        }
        log.warn((Object)("\nlastCommitTime=" + this.lastCommitTime + ", compactingMerge=" + forceCompactingMerges + ", oldJournalSize=" + oldJournalSize + sb));
        return tasks;
    }

    protected List<AbstractTask> chooseSplitBuildOrMerge(boolean compactingMerge) {
        AbstractPrepareTask task;
        int ndone = 0;
        int nskip = 0;
        int nbuild = 0;
        int nmerge = 0;
        int nsplit = 0;
        LinkedList<AbstractTask> tasks = new LinkedList<AbstractTask>();
        Iterator<ViewMetadata> itr = this.overflowMetadata.views();
        PriorityQueue<Priority<ViewMetadata>> mergeQueue = new PriorityQueue<Priority<ViewMetadata>>(this.overflowMetadata.getIndexCount());
        while (itr.hasNext()) {
            ViewMetadata vmd = itr.next();
            String name = vmd.name;
            if (this.isUsed(name)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("was  handled: " + name));
                }
                ++nskip;
                ++ndone;
                continue;
            }
            if (this.overflowMetadata.isCopied(name)) {
                this.putUsed(name, "wasCopied(name=" + name + ")");
                if (log.isInfoEnabled()) {
                    log.info((Object)("was  copied : " + vmd));
                }
                ++nskip;
                ++ndone;
                continue;
            }
            if (compactingMerge || vmd.mandatoryMerge) {
                task = new CompactingMergeTask(vmd);
                tasks.add(task);
                this.overflowMetadata.setAction(vmd.name, OverflowActionEnum.Merge);
                this.putUsed(name, "willManditoryMerge(" + vmd + ")");
                if (log.isInfoEnabled()) {
                    log.info((Object)("will merge    : " + vmd));
                }
                ++nmerge;
                ++ndone;
                continue;
            }
            if (!compactingMerge && vmd.pmd.getSourcePartitionId() == -1 && vmd.isTailSplit()) {
                task = new SplitTailTask(vmd, null);
                tasks.add(task);
                this.overflowMetadata.setAction(vmd.name, OverflowActionEnum.TailSplit);
                this.putUsed(name, "tailSplit(name=" + vmd + ")");
                if (log.isInfoEnabled()) {
                    log.info((Object)("will tailSpl: " + vmd));
                }
                ++nsplit;
                ++ndone;
                continue;
            }
            if (vmd.pmd.getSourcePartitionId() == -1 && vmd.getPercentOfSplit() > 1.0) {
                task = new SplitIndexPartitionTask(vmd, (UUID)null);
                tasks.add(task);
                this.overflowMetadata.setAction(vmd.name, OverflowActionEnum.Split);
                this.putUsed(name, "willSplit(name=" + vmd + ")");
                if (log.isInfoEnabled()) {
                    log.info((Object)("will split  : " + vmd));
                }
                ++nsplit;
                ++ndone;
                continue;
            }
            mergeQueue.add(new Priority<ViewMetadata>(vmd.mergePriority, vmd));
        }
        while (!mergeQueue.isEmpty()) {
            Priority e = (Priority)mergeQueue.poll();
            ViewMetadata vmd = (ViewMetadata)e.v;
            if (nmerge < this.resourceManager.maximumOptionalMergesPerOverflow) {
                task = new CompactingMergeTask(vmd);
                tasks.add(task);
                this.overflowMetadata.setAction(vmd.name, OverflowActionEnum.Merge);
                this.putUsed(vmd.name, "willOptionalMerge(" + vmd + ")");
                if (log.isInfoEnabled()) {
                    log.info((Object)("will merge : " + vmd));
                }
                ++nmerge;
                ++ndone;
                continue;
            }
            task = new IncrementalBuildTask(vmd);
            tasks.add(task);
            this.overflowMetadata.setAction(vmd.name, OverflowActionEnum.Build);
            this.putUsed(vmd.name, "willBuild(" + vmd + ")");
            if (log.isInfoEnabled()) {
                log.info((Object)("will build: " + vmd));
            }
            ++nbuild;
            ++ndone;
        }
        if (ndone != nskip + nbuild + nmerge + nsplit) {
            log.warn((Object)("ndone=" + ndone + ", but : nskip=" + nskip + ", nbuild=" + nbuild + ", ncompact=" + nmerge + ", nsplit=" + nsplit));
        }
        if (ndone != this.used.size()) {
            log.warn((Object)("ndone=" + ndone + ", but #used=" + this.used.size()));
        }
        return tasks;
    }

    @Override
    public Object call() throws Exception {
        MDC.put((String)"taskname", (Object)"overflowService");
        if (this.resourceManager.overflowAllowed.get()) {
            throw new AssertionError();
        }
        long begin = System.currentTimeMillis();
        boolean forceCompactingMerges = this.resourceManager.compactingMerge.getAndSet(false);
        this.resourceManager.overflowCounters.asynchronousOverflowStartMillis.set(begin);
        Event e = new Event(this.resourceManager.getFederation(), new EventResource(), (Object)EventType.AsynchronousOverflow).addDetail("asynchronousOverflowCounter", this.resourceManager.overflowCounters.asynchronousOverflowCounter.get()).start();
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("\npre-condition views: overflowCounter=" + this.resourceManager.overflowCounters.asynchronousOverflowCounter.get() + "\n" + this.resourceManager.listIndexPartitions(TimestampUtility.asHistoricalRead(this.lastCommitTime))));
            }
            this.resourceManager.getClass();
            List<Future<?>> futures = this.scheduleAndAwaitTasks(forceCompactingMerges);
            for (Future<?> f : futures) {
                try {
                    f.get();
                }
                catch (CancellationException ex) {
                    log.error((Object)ex, (Throwable)ex);
                    this.resourceManager.overflowCounters.asynchronousOverflowTaskCancelledCounter.incrementAndGet();
                }
                catch (ExecutionException ex) {
                    if (this.isNormalShutdown(ex)) {
                        log.warn((Object)("Normal shutdown? : " + ex), (Throwable)ex);
                    } else {
                        log.error((Object)ex, (Throwable)ex);
                    }
                    this.resourceManager.overflowCounters.asynchronousOverflowTaskFailedCounter.incrementAndGet();
                }
            }
            long overflowCounter = this.resourceManager.overflowCounters.asynchronousOverflowCounter.incrementAndGet();
            log.warn((Object)("done: overflowCounter=" + overflowCounter + ", lastCommitTime=" + this.resourceManager.getLiveJournal().getLastCommitTime() + ", elapsed=" + (System.currentTimeMillis() - begin) + "ms"));
            if (log.isInfoEnabled()) {
                log.info((Object)("\npost-condition views: overflowCounter=" + this.resourceManager.overflowCounters.asynchronousOverflowCounter.get() + "\n" + this.resourceManager.listIndexPartitions(0L)));
            }
            Object var7_8 = null;
            return var7_8;
        }
        catch (Throwable t) {
            this.resourceManager.overflowCounters.asynchronousOverflowFailedCounter.incrementAndGet();
            if (this.isNormalShutdown(t)) {
                log.warn((Object)("Normal shutdown? : " + t));
            } else {
                log.error((Object)t, t);
            }
            throw new RuntimeException(t);
        }
        finally {
            e.end();
            if (!this.resourceManager.overflowAllowed.compareAndSet(false, true)) {
                throw new AssertionError();
            }
            this.resourceManager.overflowCounters.asynchronousOverflowMillis.addAndGet(e.getElapsed());
            this.overflowMetadata.clearViews();
        }
    }

    protected <T> void runTasks(List<AbstractTask<T>> tasks) throws InterruptedException {
        if (log.isInfoEnabled()) {
            log.info((Object)("begin : will run " + tasks.size() + " update tasks"));
        }
        if (this.resourceManager.overflowTasksConcurrent == 1) {
            this.runTasksInSingleThread(tasks);
        } else {
            this.runTasksConcurrent(tasks);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void runTasksInSingleThread(List<AbstractTask<T>> tasks) throws InterruptedException {
        ExecutorService executorService = Executors.newSingleThreadExecutor(DaemonThreadFactory.defaultThreadFactory());
        try {
            long nanos;
            long begin = System.nanoTime();
            long remaining = nanos = TimeUnit.MILLISECONDS.toNanos(this.resourceManager.overflowTimeout);
            Iterator<AbstractTask<T>> titr = tasks.iterator();
            int ndone = 0;
            while (titr.hasNext() && remaining > 0L) {
                boolean shouldOverflow;
                boolean bl = shouldOverflow = this.resourceManager.isOverflowEnabled() && this.resourceManager.shouldOverflow();
                if (shouldOverflow) {
                    if (this.resourceManager.overflowCancelledWhenJournalFull) break;
                    long elapsed = System.nanoTime() - begin;
                    log.warn((Object)("Overflow still running: elapsed=" + TimeUnit.NANOSECONDS.toMillis(elapsed)));
                }
                AbstractTask<T> task = titr.next();
                FutureTask<T> f = this.resourceManager.getConcurrencyManager().submit(task);
                this.getFutureForTask(f, task, remaining, TimeUnit.NANOSECONDS);
                remaining = nanos - (System.nanoTime() - begin);
                ++ndone;
            }
            log.warn((Object)("Completed " + ndone + " out of " + tasks.size() + " tasks"));
        }
        finally {
            executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void runTasksConcurrent(List<AbstractTask<T>> tasks) throws InterruptedException {
        assert (this.resourceManager.overflowTasksConcurrent >= 0);
        List<Future<T>> futures = this.resourceManager.getConcurrencyManager().invokeAll(tasks, this.resourceManager.overflowTimeout, TimeUnit.MILLISECONDS);
        Iterator<AbstractTask<T>> titr = tasks.iterator();
        for (Future<T> f : futures) {
            AbstractTask<T> task = titr.next();
            this.getFutureForTask(f, task, 0L, TimeUnit.NANOSECONDS);
        }
    }

    private void getFutureForTask(Future<? extends Object> f, AbstractTask task, long timeout, TimeUnit unit) {
        try {
            f.get(timeout, unit);
            long elapsed = TimeUnit.NANOSECONDS.toMillis(task.nanoTime_finishedWork - task.nanoTime_beginWork);
            if (log.isInfoEnabled()) {
                log.info((Object)("Task complete: elapsed=" + elapsed + ", task=" + task));
            }
        }
        catch (Throwable t) {
            long elapsed = TimeUnit.NANOSECONDS.toMillis(task.nanoTime_finishedWork - task.nanoTime_beginWork);
            if (t instanceof CancellationException) {
                log.warn((Object)("Task cancelled: elapsed=" + elapsed + ", task=" + task + " : " + t));
                this.resourceManager.overflowCounters.asynchronousOverflowTaskCancelledCounter.incrementAndGet();
            }
            if (this.isNormalShutdown(t)) {
                log.warn((Object)("Normal shutdown? : elapsed=" + elapsed + ", task=" + task + " : " + t));
            }
            this.resourceManager.overflowCounters.asynchronousOverflowTaskFailedCounter.incrementAndGet();
            log.error((Object)("Child task failed: elapsed=" + elapsed + ", task=" + task + " : " + t), t);
        }
    }

    private boolean isNormalShutdown(Throwable t) {
        return AsynchronousOverflowTask.isNormalShutdown(this.resourceManager, t);
    }

    protected static boolean isNormalShutdown(ResourceManager resourceManager, Throwable t) {
        if (Thread.interrupted()) {
            return true;
        }
        return !resourceManager.isRunning() || !resourceManager.getConcurrencyManager().isOpen() || InnerCause.isInnerCause((Throwable)t, InterruptedException.class) || InnerCause.isInnerCause((Throwable)t, ClosedByInterruptException.class) || InnerCause.isInnerCause((Throwable)t, ClosedChannelException.class) || InnerCause.isInnerCause((Throwable)t, AsynchronousCloseException.class);
    }

    private class AtomicCallable<T>
    implements Callable<T> {
        private final OverflowActionEnum action;
        private final ViewMetadata vmd;
        private final boolean forceCompactingMerge;
        private final AbstractTask<T> task;

        public AtomicCallable(OverflowActionEnum action, ViewMetadata vmd, boolean forceCompactingMerge, AbstractTask<T> task) {
            if (action == null) {
                throw new IllegalArgumentException();
            }
            if (vmd == null) {
                throw new IllegalArgumentException();
            }
            if (task == null) {
                throw new IllegalArgumentException();
            }
            this.action = action;
            this.vmd = vmd;
            this.forceCompactingMerge = forceCompactingMerge;
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            ReentrantLock lock = this.vmd.lock;
            lock.lock();
            try {
                if (this.vmd.getAction() != null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Dropping task: runningAs=" + (Object)((Object)this.vmd.getAction()) + ", plannedAction=" + (Object)((Object)this.action)));
                    }
                    T t = null;
                    return t;
                }
                this.vmd.setAction(this.action);
            }
            finally {
                lock.unlock();
            }
            if (this.action.equals((Object)OverflowActionEnum.Merge) && ((ConcurrencyManager)AsynchronousOverflowTask.this.resourceManager.getConcurrencyManager()).getJournalOverextended() > ((AsynchronousOverflowTask)AsynchronousOverflowTask.this).resourceManager.overflowThreshold) {
                return null;
            }
            return AsynchronousOverflowTask.this.resourceManager.getConcurrencyManager().submit(this.task).get();
        }
    }
}

