/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval;

import com.bigdata.journal.IIndexManager;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.rule.IProgram;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.IStep;
import com.bigdata.relation.rule.eval.AbstractStepTask;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.RuleLog;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.service.DataService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class QueryTask
extends AbstractStepTask {
    private static final long serialVersionUID = -1795376592525891934L;
    private final IBlockingBuffer<ISolution[]> buffer;

    public QueryTask(IStep step, IJoinNexusFactory joinNexusFactory, IBlockingBuffer<ISolution[]> buffer, IIndexManager indexManager, DataService dataService) {
        super(ActionEnum.Query, joinNexusFactory, step, indexManager, dataService);
        if (buffer == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = buffer;
    }

    @Override
    public RuleStats call() throws Exception {
        IJoinNexus joinNexus = this.joinNexusFactory.newInstance(this.indexManager);
        List<Callable<RuleStats>> tasks = this.newQueryTasks(this.step, joinNexus, this.buffer);
        try {
            RuleStats totals = this.runTasks(joinNexus, tasks);
            if (log.isDebugEnabled()) {
                log.debug((Object)"done - closing the blocking buffer");
            }
            this.buffer.close();
            RuleLog.log(totals);
            return totals;
        }
        catch (Throwable t) {
            try {
                log.error((Object)("Problem running query: " + t), t);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            this.buffer.abort(t);
            throw new RuntimeException(t);
        }
    }

    protected RuleStats runTasks(IJoinNexus joinNexus, List<Callable<RuleStats>> tasks) throws InterruptedException, ExecutionException {
        assert (tasks != null);
        assert (!tasks.isEmpty());
        RuleStats totals = tasks.size() == 1 ? this.runOne(joinNexus, this.step, tasks.get(0)) : (!joinNexus.forceSerialExecution() && !this.step.isRule() && ((IProgram)this.step).isParallel() ? this.runParallel(joinNexus, this.step, tasks) : this.runSequential(joinNexus, this.step, tasks));
        return totals;
    }

    protected List<Callable<RuleStats>> newQueryTasks(IStep step, IJoinNexus joinNexus, IBlockingBuffer<ISolution[]> buffer) {
        ArrayList<Callable<RuleStats>> tasks;
        if (log.isDebugEnabled()) {
            log.debug((Object)("step=" + step.getName()));
        }
        if (step.isRule()) {
            tasks = new ArrayList<Callable<RuleStats>>(1);
            IRule rule = (IRule)step;
            IStepTask task = joinNexus.getRuleTaskFactory(false, rule).newTask(rule, joinNexus, buffer);
            tasks.add(task);
        } else {
            IProgram program = (IProgram)step;
            boolean parallel = program.isParallel();
            tasks = new ArrayList(program.stepCount());
            Iterator<IStep> itr = program.steps();
            while (itr.hasNext()) {
                IRule rule = (IRule)itr.next();
                IStepTask task = joinNexus.getRuleTaskFactory(parallel, rule).newTask(rule, joinNexus, buffer);
                tasks.add(task);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + tasks.size() + " query tasks"));
        }
        return tasks;
    }
}

