/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.striterator.AbstractChunkedResolverator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;

public class BigdataStatementIteratorImpl
extends AbstractChunkedResolverator<ISPO, BigdataStatement, AbstractTripleStore>
implements BigdataStatementIterator {
    private static final Logger log = Logger.getLogger(BigdataStatementIteratorImpl.class);
    private final Map<IV, BigdataBNode> bnodes;

    public BigdataStatementIteratorImpl(AbstractTripleStore db, IChunkedOrderedIterator<ISPO> src) {
        this(db, null, src);
    }

    public BigdataStatementIteratorImpl(AbstractTripleStore db, Map<IV, BigdataBNode> bnodes, IChunkedOrderedIterator<ISPO> src) {
        super(db, src, new BlockingBuffer<F[]>(db.getChunkOfChunksCapacity(), db.getChunkCapacity(), db.getChunkTimeout(), TimeUnit.MILLISECONDS));
        this.bnodes = bnodes;
    }

    public BigdataStatementIteratorImpl start(ExecutorService service) {
        return (BigdataStatementIteratorImpl)super.start(service);
    }

    protected BigdataStatement[] resolveChunk(ISPO[] chunk) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("chunkSize=" + chunk.length));
        }
        LinkedHashSet ivs = new LinkedHashSet(chunk.length * ((AbstractTripleStore)this.state).getSPOKeyArity());
        for (ISPO spo : chunk) {
            IV s = spo.s();
            this.handleIV(s, ivs);
            this.handleIV(spo.p(), ivs);
            IV o = spo.o();
            this.handleIV(o, ivs);
            IV c = spo.c();
            if (c == null) continue;
            this.handleIV(c, ivs);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolving " + ivs.size() + " term identifiers"));
        }
        Map<IV<?, ?>, BigdataValue> terms = ((AbstractTripleStore)this.state).getLexiconRelation().getTerms(ivs);
        BigdataValueFactory valueFactory = ((AbstractTripleStore)this.state).getValueFactory();
        BigdataStatement[] stmts = new BigdataStatement[chunk.length];
        int i = 0;
        for (ISPO spo : chunk) {
            BigdataResource tmp;
            BigdataResource s = (BigdataResource)this.resolve(terms, spo.s());
            BigdataURI p = (BigdataURI)this.resolve(terms, spo.p());
            BigdataValue o = this.resolve(terms, spo.o());
            IV _c = spo.c();
            Object c = _c != null ? ((tmp = (BigdataResource)this.resolve(terms, _c)) instanceof BigdataURI && ((BigdataURI)tmp).equals(BD.NULL_GRAPH) ? null : tmp) : null;
            if (!spo.hasStatementType()) {
                log.error((Object)("statement with no type: " + valueFactory.createStatement(s, p, o, (Resource)c, null, spo.getUserFlag())));
            }
            BigdataStatement stmt = valueFactory.createStatement(s, p, o, (Resource)c, spo.getStatementType(), spo.getUserFlag());
            stmts[i++] = stmt;
        }
        return stmts;
    }

    private void handleIV(IV<?, ?> iv, Collection<IV<?, ?>> ids) {
        if (this.bnodes == null || !this.bnodes.containsKey(iv)) {
            ids.add(iv);
        }
    }

    private BigdataValue resolve(Map<IV<?, ?>, BigdataValue> terms, IV<?, ?> iv) {
        BigdataValue v = null;
        if (this.bnodes != null) {
            v = this.bnodes.get(iv);
        }
        if (v == null) {
            v = terms.get(iv);
        }
        return v;
    }
}

