/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.ISortKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.spo.ISPO;

public class SPOSortKeyBuilder
implements ISortKeyBuilder<ISPO> {
    private final int arity;
    private final IKeyBuilder keyBuilder;

    public SPOSortKeyBuilder(int arity) {
        assert (arity == 3 || arity == 4);
        this.arity = arity;
        this.keyBuilder = new KeyBuilder(8 * arity);
    }

    @Override
    public byte[] getSortKey(ISPO spo) {
        this.keyBuilder.reset();
        spo.s().encode(this.keyBuilder);
        spo.p().encode(this.keyBuilder);
        spo.o().encode(this.keyBuilder);
        if (this.arity == 4) {
            spo.c().encode(this.keyBuilder);
        }
        return this.keyBuilder.getKey();
    }
}

