/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.spo;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.raba.codec.EmptyRabaValueCoder;
import com.bigdata.rdf.inf.Justification;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class JustificationTupleSerializer
extends DefaultTupleSerializer<Justification, Justification> {
    private static final long serialVersionUID = -3930463865005938874L;
    private int N;
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public JustificationTupleSerializer() {
    }

    public JustificationTupleSerializer(int N) {
        super(new ASCIIKeyBuilderFactory(), JustificationTupleSerializer.getDefaultLeafKeysCoder(), EmptyRabaValueCoder.INSTANCE);
        if (N != 3 && N != 4) {
            throw new IllegalArgumentException();
        }
        this.N = N;
    }

    @Override
    public Justification deserialize(ITuple tuple) {
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        IV[] ivs = IVUtility.decodeAll(tuple.getKey());
        return new Justification(this.N, ivs);
    }

    @Override
    public Justification deserializeKey(ITuple tuple) {
        return this.deserialize(tuple);
    }

    @Override
    public byte[] serializeKey(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof Justification) {
            return Justification.getKey(this.getKeyBuilder(), (Justification)obj);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] serializeVal(Justification jst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
        this.N = in.readByte();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
        out.writeByte(this.N);
    }
}

