/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import org.apache.log4j.Logger;

public class ASTUnknownTermOptimizer
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTUnknownTermOptimizer.class);

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            ASTUnknownTermOptimizer.eliminateGroupsWithUnknownTerms(queryRoot, whereClause);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (int i = 0; i < namedSubqueries.size(); ++i) {
                NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)namedSubqueries.get(i);
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                ASTUnknownTermOptimizer.eliminateGroupsWithUnknownTerms(queryRoot, whereClause2);
            }
        }
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    private static void eliminateGroupsWithUnknownTerms(QueryRoot queryRoot, GroupNodeBase<IGroupMemberNode> op) {
        int i;
        for (i = 0; i < op.arity(); ++i) {
            BOp sp = op.get(i);
            if (!(sp instanceof StatementPatternNode)) continue;
            for (int j = 0; j < sp.arity(); ++j) {
                IV iv;
                BOp term = sp.get(j);
                if (!(term instanceof ConstantNode) || (iv = ((ConstantNode)term).getValue().getIV()) != null && !iv.isNullIV()) continue;
                ASTUnknownTermOptimizer.pruneGroup(queryRoot, op);
            }
        }
        for (i = 0; i < op.arity(); ++i) {
            BOp child = op.get(i);
            if (child instanceof GroupNodeBase) {
                GroupNodeBase childGroup = (GroupNodeBase)child;
                ASTUnknownTermOptimizer.eliminateGroupsWithUnknownTerms(queryRoot, childGroup);
                continue;
            }
            if (!(child instanceof QueryBase)) continue;
            QueryBase subquery = (QueryBase)child;
            GraphPatternGroup childGroup = subquery.getWhereClause();
            ASTUnknownTermOptimizer.eliminateGroupsWithUnknownTerms(queryRoot, childGroup);
        }
    }

    private static void pruneGroup(QueryRoot queryRoot, GroupNodeBase<IGroupMemberNode> op) {
        IGroupNode<IGroupMemberNode> parent = op.getParent();
        if (op.getParent() == null) {
            queryRoot.setWhereClause(new JoinGroupNode());
        } else if (parent instanceof UnionNode || op instanceof IJoinNode && ((IJoinNode)((Object)op)).isOptional()) {
            parent.removeChild(op);
        } else {
            ASTUnknownTermOptimizer.pruneGroup(queryRoot, (GroupNodeBase)parent);
        }
    }

    private static void removeEmptyChildGroups(GraphPatternGroup<?> op) {
        int n = op.arity();
        for (int i = 0; i < n; ++i) {
            BOp child = op.get(i);
            if (!(child instanceof GroupNodeBase) || ((GroupNodeBase)child).getContext() != null || child.arity() != 0) continue;
            op.removeArg(child);
            --n;
        }
    }
}

