/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.ModifiableBOpBase;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryNodeWithBindingSet;
import com.bigdata.rdf.sparql.ast.QueryOptimizerEnum;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.IEvaluationContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSparql11SubqueryOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.StaticOptimizer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ASTStaticJoinOptimizer
implements IASTOptimizer {
    public static final Logger log = Logger.getLogger(ASTStaticJoinOptimizer.class);

    private static IBindingSet getExogenousBindings(IBindingSet[] bindingSets) {
        if (bindingSets == null || bindingSets.length == 0) {
            return null;
        }
        return bindingSets[0];
    }

    @Override
    public QueryNodeWithBindingSet optimize(AST2BOpContext context, QueryNodeWithBindingSet input) {
        GraphPatternGroup whereClause;
        IQueryNode queryNode = input.getQueryNode();
        IBindingSet[] bindingSets = input.getBindingSets();
        if (!(queryNode instanceof QueryRoot)) {
            return new QueryNodeWithBindingSet(queryNode, bindingSets);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before:\n" + queryNode));
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        IBindingSet exogenousBindings = ASTStaticJoinOptimizer.getExogenousBindings(bindingSets);
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (NamedSubqueryRoot namedSubquery : namedSubqueries) {
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                this.optimize(context, exogenousBindings, queryRoot, new IJoinNode[0], whereClause2);
            }
        }
        if ((whereClause = queryRoot.getWhereClause()) != null) {
            this.optimize(context, exogenousBindings, queryRoot, new IJoinNode[0], whereClause);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after:\n" + queryNode));
        }
        return new QueryNodeWithBindingSet(queryNode, bindingSets);
    }

    static boolean isStaticOptimizer(IEvaluationContext context, JoinGroupNode joinGroup) {
        return QueryOptimizerEnum.Static.equals((Object)joinGroup.getQueryOptimizer());
    }

    private GroupNodeOptimizer<?> createGroupNodeOptimizer(AST2BOpContext ctx, IBindingSet exogenousBindings, QueryRoot queryRoot, IBindingProducerNode[] ancestry, GraphPatternGroup<?> op) {
        if (op instanceof JoinGroupNode) {
            return new JoinGroupNodeOptimizer(ctx, exogenousBindings, queryRoot, ancestry, (JoinGroupNode)op);
        }
        if (op instanceof UnionNode) {
            return new UnionNodeOptimizer(ctx, exogenousBindings, queryRoot, ancestry, (UnionNode)op);
        }
        throw new IllegalArgumentException("Unexpected subclass of GraphPatternGroup");
    }

    private void optimize(AST2BOpContext ctx, IBindingSet exogenousBindings, QueryRoot queryRoot, IBindingProducerNode[] ancestry, GraphPatternGroup<?> op) {
        this.createGroupNodeOptimizer(ctx, exogenousBindings, queryRoot, ancestry, op).optimizex();
    }

    private void optimizeJoinGroup(AST2BOpContext ctx, QueryRoot queryRoot, IBindingProducerNode[] ancestry, JoinGroupNode joinGroup) {
        List<IReorderableNode> nodes = joinGroup.getReorderableChildren();
        if (!nodes.isEmpty()) {
            int[] slots = new int[nodes.size()];
            int j = 0;
            for (int i = 0; i < joinGroup.arity() && j < nodes.size(); ++i) {
                if (joinGroup.get(i) != nodes.get(j)) continue;
                slots[j++] = i;
            }
            double optimistic = joinGroup.getProperty(Annotations.OPTIMISTIC, Annotations.DEFAULT_OPTIMISTIC);
            LinkedList<IReorderableNode> required = new LinkedList<IReorderableNode>();
            IReorderableNode runLast = null;
            for (IReorderableNode sp : nodes) {
                if (runLast == null && ((Boolean)sp.getProperty("runLast", false)).booleanValue()) {
                    runLast = sp;
                    continue;
                }
                required.add(sp);
            }
            StaticOptimizer opt = new StaticOptimizer(queryRoot, ctx, ancestry, required, optimistic);
            int[] order = opt.getOrder();
            int i = 0;
            for (int j2 = 0; j2 < required.size(); ++j2) {
                IReorderableNode sp = (IReorderableNode)required.get(order[j2]);
                joinGroup.setArg(slots[i++], sp);
            }
            if (runLast != null) {
                joinGroup.setArg(slots[i++], runLast);
            }
        }
    }

    private class UnionNodeOptimizer
    extends GroupNodeOptimizer<UnionNode> {
        final IBindingProducerNode[] ancestry;

        public UnionNodeOptimizer(AST2BOpContext ctx, IBindingSet exogenousBindings, QueryRoot queryRoot, IBindingProducerNode[] ancestry, UnionNode op) {
            super(ASTStaticJoinOptimizer.this, ctx, exogenousBindings, queryRoot, ancestry, (GraphPatternGroup)op);
            this.ancestry = ancestry;
        }

        @Override
        void afterOptimizingChild(BOp child) {
        }

        @Override
        IBindingProducerNode[] getAncestry() {
            return this.ancestry;
        }

        @Override
        void optimizeThisLevel() {
        }
    }

    private class JoinGroupNodeOptimizer
    extends GroupNodeOptimizer<JoinGroupNode> {
        final List<IBindingProducerNode> ancestry;

        public JoinGroupNodeOptimizer(AST2BOpContext ctx, IBindingSet exogenousBindings, QueryRoot queryRoot, IBindingProducerNode[] ancestry, JoinGroupNode joinGroup) {
            super(ASTStaticJoinOptimizer.this, ctx, exogenousBindings, queryRoot, ancestry, (GraphPatternGroup)joinGroup);
            this.ancestry = new LinkedList<IBindingProducerNode>(Arrays.asList(ancestry));
            this.addToAncestry(joinGroup.getServiceNodes(), "service node");
            this.addToAncestry(joinGroup.getNamedSubqueryIncludes(), "named subquery include");
        }

        private void addToAncestry(List<? extends IBindingProducerNode> moreAncestors, String dbgMessage) {
            for (IBindingProducerNode iBindingProducerNode : moreAncestors) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding a " + dbgMessage + " to ancestry:" + iBindingProducerNode));
                }
                this.ancestry.add(iBindingProducerNode);
            }
        }

        @Override
        void afterOptimizingChild(BOp child) {
            if (child instanceof IBindingProducerNode) {
                IJoinNode ijn;
                if (child instanceof IJoinNode && ((ijn = (IJoinNode)child).isOptional() || ijn.isMinus())) {
                    return;
                }
                this.ancestry.add((IBindingProducerNode)child);
            }
        }

        @Override
        IBindingProducerNode[] getAncestry() {
            return this.ancestry.toArray(new IBindingProducerNode[this.ancestry.size()]);
        }

        @Override
        void optimizeThisLevel() {
            if (ASTStaticJoinOptimizer.isStaticOptimizer(this.ctx, (JoinGroupNode)this.op)) {
                ASTStaticJoinOptimizer.this.optimizeJoinGroup(this.ctx, this.queryRoot, this.getAncestry(), (JoinGroupNode)this.op);
            }
        }
    }

    private static abstract class GroupNodeOptimizer<T extends GraphPatternGroup<?>> {
        final T op;
        final AST2BOpContext ctx;
        private final IBindingSet exogenousBindings;
        final QueryRoot queryRoot;
        final /* synthetic */ ASTStaticJoinOptimizer this$0;

        public GroupNodeOptimizer(AST2BOpContext ctx, IBindingSet exogenousBindings, QueryRoot queryRoot, IBindingProducerNode[] ancestry, T op) {
            this.this$0 = var1_1;
            this.op = op;
            this.ctx = ctx;
            this.exogenousBindings = exogenousBindings;
            this.queryRoot = queryRoot;
        }

        public void optimizex() {
            this.optimizeThisLevel();
            this.optimizeRecursively();
        }

        private void optimizeRecursively() {
            for (int i = 0; i < ((ModifiableBOpBase)this.op).arity(); ++i) {
                BOp child = ((ModifiableBOpBase)this.op).get(i);
                if (child instanceof GraphPatternGroup) {
                    GraphPatternGroup childGroup = (GraphPatternGroup)child;
                    this.this$0.optimize(this.ctx, this.exogenousBindings, this.queryRoot, this.getAncestry(), childGroup);
                } else if (child instanceof QueryBase) {
                    QueryBase subquery = (QueryBase)child;
                    GraphPatternGroup childGroup = subquery.getWhereClause();
                    Set<IVariable<?>> projectedVars = subquery.getProjectedVars(new LinkedHashSet());
                    IVariable[] variablesToKeep = BOpUtility.toArray(projectedVars.iterator());
                    IBindingSet tmp = this.exogenousBindings == null ? null : this.exogenousBindings.copy(variablesToKeep);
                    boolean voidAncestry = subquery instanceof SubqueryRoot && ASTSparql11SubqueryOptimizer.needsLifting((SubqueryRoot)subquery);
                    IBindingProducerNode[] ancestry = voidAncestry ? new IBindingProducerNode[]{} : this.getAncestry();
                    this.this$0.optimize(this.ctx, tmp, this.queryRoot, ancestry, childGroup);
                }
                this.afterOptimizingChild(child);
            }
        }

        abstract void afterOptimizingChild(BOp var1);

        abstract IBindingProducerNode[] getAncestry();

        abstract void optimizeThisLevel();
    }

    public static interface Annotations
    extends AST2BOpBase.Annotations {
        public static final String OPTIMISTIC = ASTStaticJoinOptimizer.class.getName() + ".optimistic";
        public static final Double DEFAULT_OPTIMISTIC = 1.0;
    }
}

