/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.hints;

import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.hints.AbstractIntQueryHint;
import com.bigdata.rdf.sparql.ast.hints.QueryHintException;
import com.bigdata.rdf.sparql.ast.hints.QueryHintScope;

final class RTOLimitQueryHint
extends AbstractIntQueryHint {
    public RTOLimitQueryHint() {
        super("RTO-limit", 100);
    }

    @Override
    public Integer validate(String value) {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Not an integer value: hint=" + this.getName() + ", value=" + value);
        }
        if (i <= 0) {
            throw new IllegalArgumentException("Must be positive: hint=" + this.getName() + ", value=" + value);
        }
        return i;
    }

    @Override
    public void handle(AST2BOpContext ctx, QueryRoot queryRoot, QueryHintScope scope, ASTBase op, Integer value) {
        switch (scope) {
            case Group: 
            case GroupAndSubGroups: 
            case Query: 
            case SubQuery: {
                if (op instanceof JoinGroupNode) {
                    this._setAnnotation(ctx, scope, op, this.getName(), value);
                }
                return;
            }
        }
        throw new QueryHintException(scope, op, this.getName(), value);
    }
}

