/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CompiledSolutionSetStats
implements ISolutionSetStats,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long nsolutions;
    private final Set<IVariable<?>> usedVars;
    private final Set<IVariable<?>> alwaysBound;
    private final Set<IVariable<?>> notAlwaysBound;
    private final Set<IVariable<?>> materialized;
    private final Map<IVariable<?>, IConstant<?>> constants;

    public CompiledSolutionSetStats(long nsolutions, Set<IVariable<?>> usedVars, Set<IVariable<?>> alwaysBound, Set<IVariable<?>> notAlwaysBound, Set<IVariable<?>> materialized, Map<IVariable<?>, IConstant<?>> constants) {
        this.nsolutions = nsolutions;
        this.usedVars = Collections.unmodifiableSet(usedVars);
        this.alwaysBound = Collections.unmodifiableSet(alwaysBound);
        this.notAlwaysBound = Collections.unmodifiableSet(notAlwaysBound);
        this.materialized = Collections.unmodifiableSet(materialized);
        this.constants = Collections.unmodifiableMap(constants);
    }

    @Override
    public long getSolutionSetSize() {
        return this.nsolutions;
    }

    @Override
    public Set<IVariable<?>> getUsedVars() {
        return this.usedVars;
    }

    @Override
    public Set<IVariable<?>> getAlwaysBound() {
        return this.alwaysBound;
    }

    @Override
    public Set<IVariable<?>> getNotAlwaysBound() {
        return this.notAlwaysBound;
    }

    @Override
    public Set<IVariable<?>> getMaterialized() {
        return this.materialized;
    }

    @Override
    public Map<IVariable<?>, IConstant<?>> getConstants() {
        return this.constants;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("{size=" + this.nsolutions);
        sb.append(",usedVars=" + this.usedVars);
        sb.append(",alwaysBound=" + this.alwaysBound);
        sb.append(",notAlwaysBound=" + this.notAlwaysBound);
        sb.append(",materialized=" + this.materialized);
        sb.append(",constants=" + this.constants);
        sb.append("}");
        return sb.toString();
    }
}

