/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.optimizers.StaticOptimizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArbitraryLengthPathNode
extends GroupMemberNodeBase<ArbitraryLengthPathNode>
implements IBindingProducerNode,
IReorderableNode {
    private static final transient Logger log = Logger.getLogger(ArbitraryLengthPathNode.class);
    private static final long serialVersionUID = 1L;

    public ArbitraryLengthPathNode(ArbitraryLengthPathNode op) {
        super(op);
    }

    public ArbitraryLengthPathNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        this.subgroup().setSubgroupOfALPNode(true);
    }

    public ArbitraryLengthPathNode(TermNode left, TermNode right, VarNode tVarLeft, VarNode tVarRight, PathNode.PathMod mod) {
        this(new BOp[]{new JoinGroupNode()}, NV.asMap(new NV(Annotations.LEFT_TERM, left), new NV(Annotations.RIGHT_TERM, right), new NV(Annotations.TRANSITIVITY_VAR_LEFT, tVarLeft), new NV(Annotations.TRANSITIVITY_VAR_RIGHT, tVarRight), new NV(Annotations.LOWER_BOUND, mod == PathNode.PathMod.ONE_OR_MORE ? 1L : 0L), new NV(Annotations.UPPER_BOUND, mod == PathNode.PathMod.ZERO_OR_ONE ? 1L : Long.MAX_VALUE)));
        LinkedHashSet<VarNode> dropVars = new LinkedHashSet<VarNode>();
        dropVars.add(tVarLeft);
        dropVars.add(tVarRight);
        this.setProperty(Annotations.DROP_VARS, dropVars);
    }

    public ArbitraryLengthPathNode(TermNode left, TermNode right, VarNode tVarLeft, VarNode tVarRight, long lowerBound, long upperBound) {
        this(new BOp[]{new JoinGroupNode()}, NV.asMap(new NV(Annotations.LEFT_TERM, left), new NV(Annotations.RIGHT_TERM, right), new NV(Annotations.TRANSITIVITY_VAR_LEFT, tVarLeft), new NV(Annotations.TRANSITIVITY_VAR_RIGHT, tVarRight), new NV(Annotations.DROP_VARS, new ArrayList()), new NV(Annotations.LOWER_BOUND, lowerBound), new NV(Annotations.UPPER_BOUND, upperBound)));
        LinkedHashSet<VarNode> dropVars = new LinkedHashSet<VarNode>();
        dropVars.add(tVarLeft);
        dropVars.add(tVarRight);
        this.setProperty(Annotations.DROP_VARS, dropVars);
    }

    public TermNode left() {
        return (TermNode)super.getRequiredProperty(Annotations.LEFT_TERM);
    }

    public TermNode right() {
        return (TermNode)super.getRequiredProperty(Annotations.RIGHT_TERM);
    }

    public VarNode tVarLeft() {
        return (VarNode)super.getRequiredProperty(Annotations.TRANSITIVITY_VAR_LEFT);
    }

    public VarNode tVarRight() {
        return (VarNode)super.getRequiredProperty(Annotations.TRANSITIVITY_VAR_RIGHT);
    }

    public long lowerBound() {
        return (Long)super.getRequiredProperty(Annotations.LOWER_BOUND);
    }

    public long upperBound() {
        return (Long)super.getRequiredProperty(Annotations.UPPER_BOUND);
    }

    public TermNode middle() {
        return (VarNode)super.getProperty(Annotations.MIDDLE_TERM);
    }

    public VarNode edgeVar() {
        return (VarNode)super.getProperty(Annotations.EDGE_VAR);
    }

    public void setEdgeVar(VarNode edgeVar, TermNode middle) {
        this.setProperty(Annotations.MIDDLE_TERM, middle);
        this.setProperty(Annotations.EDGE_VAR, edgeVar);
    }

    public void setDropVars(Set<VarNode> dropVars) {
        super.setProperty(Annotations.DROP_VARS, dropVars);
    }

    public void addDropVar(VarNode dropVar) {
        this.dropVars().add(dropVar);
    }

    public Set<VarNode> dropVars() {
        return (Set)super.getProperty(Annotations.DROP_VARS);
    }

    public JoinGroupNode subgroup() {
        return (JoinGroupNode)this.get(0);
    }

    public Set<IVariable<?>> getMaybeProducedBindings() {
        Set<IVariable<?>> producedBindings = this.getDefinitelyProducedBindings();
        for (StatementPatternNode sp : this.subgroup().getStatementPatterns()) {
            this.addProducedBinding(sp.s(), producedBindings);
            this.addProducedBinding(sp.p(), producedBindings);
            this.addProducedBinding(sp.o(), producedBindings);
            this.addProducedBinding(sp.c(), producedBindings);
        }
        return producedBindings;
    }

    public Set<IVariable<?>> getDefinitelyProducedBindings() {
        LinkedHashSet producedBindings = new LinkedHashSet();
        this.addVar(this.left(), producedBindings, true);
        this.addVar(this.right(), producedBindings, true);
        VarNode edgeVar = this.edgeVar();
        if (edgeVar != null) {
            this.addProducedBinding(edgeVar, producedBindings);
        }
        return producedBindings;
    }

    public Set<IVariable<?>> getUsedVars() {
        Set<IVariable<?>> used = this.getDefinitelyProducedBindings();
        for (StatementPatternNode sp : this.subgroup().getStatementPatterns()) {
            this.addUsedVar(sp.s(), used);
            this.addUsedVar(sp.p(), used);
            this.addUsedVar(sp.o(), used);
            this.addUsedVar(sp.c(), used);
            for (FilterNode filter : sp.getAttachedJoinFilters()) {
                Iterator<BOp> it = BOpUtility.preOrderIteratorWithAnnotations(filter);
                while (it.hasNext()) {
                    BOp bop = it.next();
                    if (!(bop instanceof TermNode)) continue;
                    this.addUsedVar((TermNode)bop, used);
                }
            }
        }
        for (FilterNode filter : this.subgroup().getChildren(FilterNode.class)) {
            Iterator<BOp> it = BOpUtility.preOrderIteratorWithAnnotations(filter);
            while (it.hasNext()) {
                BOp bop = it.next();
                if (!(bop instanceof TermNode)) continue;
                this.addUsedVar((TermNode)bop, used);
            }
        }
        return used;
    }

    private void addUsedVar(TermNode t, Set<IVariable<?>> vars) {
        this.addVar(t, vars, true);
    }

    private void addProducedBinding(TermNode t, Set<IVariable<?>> producedBindings) {
        this.addVar(t, producedBindings, false);
    }

    private void addVar(TermNode t, Set<IVariable<?>> producedBindings, boolean addAnonymous) {
        ConstantNode cNode;
        Constant c;
        IVariable var;
        if (t instanceof VarNode) {
            if (addAnonymous || !((VarNode)t).isAnonymous()) {
                producedBindings.add(((VarNode)t).getValueExpression());
            }
        } else if (t instanceof ConstantNode && (var = (c = (Constant)(cNode = (ConstantNode)t).getValueExpression()).getVar()) != null) {
            producedBindings.add(var);
        }
    }

    @Override
    public String toString(int indent) {
        String s = ArbitraryLengthPathNode.indent(indent);
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(s).append(this.getClass().getSimpleName());
        sb.append("(left=").append(this.left()).append(", right=").append(this.right()).append(") {");
        sb.append(this.subgroup().toString(indent + 1));
        sb.append("\n").append(s);
        sb.append("}");
        Long rangeCount = (Long)this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
        if (rangeCount != null) {
            sb.append(" AST2BOpBase.estimatedCardinality=");
            sb.append(this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY).toString());
        }
        return sb.toString();
    }

    @Override
    public boolean isReorderable() {
        return true;
    }

    @Override
    public long getEstimatedCardinality(StaticOptimizer opt) {
        long estCard;
        BOp pathExpr;
        long groupCard;
        JoinGroupNode group = this.subgroup();
        long zeroMatchAdjustment = 0L;
        if (this.lowerBound() == 0L) {
            int fixedCount = (this.left() instanceof VarNode ? 1 : 0) + (this.right() instanceof VarNode ? 1 : 0);
            switch (fixedCount) {
                case 0: {
                    zeroMatchAdjustment = this.left().getValue().equals(this.right().getValue()) ? 1L : 0L;
                    break;
                }
                case 1: {
                    zeroMatchAdjustment = 1L;
                    break;
                }
                case 2: {
                    zeroMatchAdjustment = 0x3FFFFFFFFFFFFFFFL;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("zma: " + zeroMatchAdjustment));
        }
        if ((groupCard = group.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY, Long.MAX_VALUE).longValue()) < Long.MAX_VALUE) {
            long result = groupCard + zeroMatchAdjustment;
            if (log.isDebugEnabled()) {
                log.debug((Object)("reported cardinality: " + result));
            }
            return result;
        }
        if (group.arity() == 1 && this.upperBound() >= 1L && this.upperBound() < Long.MAX_VALUE && (pathExpr = group.get(0)) != null && pathExpr.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY) != null && (estCard = ((Long)pathExpr.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY, (Object)Long.MAX_VALUE)).longValue()) < Long.MAX_VALUE) {
            return this.upperBound() * estCard + zeroMatchAdjustment;
        }
        long result = 0L;
        Iterator<BOp> it = BOpUtility.preOrderIteratorWithAnnotations(group);
        while (it.hasNext()) {
            BOp bop = it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("considering:\n" + bop));
            }
            if (!(bop instanceof StatementPatternNode)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"continuing");
                continue;
            }
            StatementPatternNode sp = (StatementPatternNode)bop;
            if (!sp.getQueryHintAsBoolean("alp.pathExpr", false)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"continuing");
                continue;
            }
            if (sp.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY) == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"continuing");
                continue;
            }
            long estCard2 = sp.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY, Long.MAX_VALUE);
            if (estCard2 == Long.MAX_VALUE) {
                result = Long.MAX_VALUE;
            }
            if (result == Long.MAX_VALUE) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"continuing");
                continue;
            }
            result += estCard2;
        }
        if (result > 0L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"found a path expression");
            }
            result += zeroMatchAdjustment;
            if (log.isDebugEnabled()) {
                log.debug((Object)("reported cardinality: " + result));
            }
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"could not find a path expr");
        }
        return 0x3FFFFFFFFFFFFFFFL;
    }

    @Override
    public Set<IVariable<?>> getRequiredBound(StaticAnalysis sa) {
        return new HashSet();
    }

    @Override
    public Set<IVariable<?>> getDesiredBound(StaticAnalysis sa) {
        return sa.getSpannedVariables(this, true, new HashSet());
    }

    public static interface Annotations
    extends GroupNodeBase.Annotations {
        public static final String LEFT_TERM = Annotations.class.getName() + ".leftTerm";
        public static final String RIGHT_TERM = Annotations.class.getName() + ".rightTerm";
        public static final String TRANSITIVITY_VAR_LEFT = Annotations.class.getName() + ".transitivityVarLeft";
        public static final String TRANSITIVITY_VAR_RIGHT = Annotations.class.getName() + ".transitivityVarRight";
        public static final String LOWER_BOUND = Annotations.class.getName() + ".lowerBound";
        public static final String UPPER_BOUND = Annotations.class.getName() + ".upperBound";
        public static final String MIDDLE_TERM = Annotations.class.getName() + ".middleTerm";
        public static final String EDGE_VAR = Annotations.class.getName() + ".edgeVar";
        public static final String DROP_VARS = Annotations.class.getName() + ".dropVars";
    }
}

