/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.engine.QueryLog;
import com.bigdata.bop.engine.StaticAnalysisStat;
import com.bigdata.bop.engine.StaticAnalysisStats;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.sparql.Bigdata2ASTSPARQLParser;
import com.bigdata.rdf.sail.sparql.ast.SimpleNode;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.HTMLBuilder;
import com.bigdata.rdf.sail.webapp.RESTServlet;
import com.bigdata.rdf.sail.webapp.RestApiGetContextsTask;
import com.bigdata.rdf.sail.webapp.SD;
import com.bigdata.rdf.sail.webapp.SparqlEndpointConfig;
import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.explainhints.ExplainHints;
import com.bigdata.rdf.sparql.ast.explainhints.IExplainHint;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IDataService;
import com.bigdata.service.ndx.ClientIndexView;
import com.bigdata.util.InnerCause;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class QueryServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(QueryServlet.class);
    static final transient String ATTR_QUERY = "query";
    static final transient String ATTR_TRUTH_MAINTENANCE = "suppressTruthMaintenance";
    static final transient String INCLUDE_INFERRED = "includeInferred";
    static final transient String ATTR_UPDATE = "update";
    static final transient String ATTR_ESTCARD = "ESTCARD";
    static final transient String ATTR_HASSTMT = "HASSTMT";
    static final transient String ATTR_GETSTMTS = "GETSTMTS";
    static final transient String ATTR_CONTEXTS = "CONTEXTS";
    static final transient String ATTR_SHARDS = "SHARDS";
    static final transient String ATTR_UUID = "uuid";
    static final transient String ATTR_TIMESTAMP = "timestamp";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(ATTR_UPDATE) != null) {
            this.doSparqlUpdate(req, resp);
        } else if (RESTServlet.hasMimeType(req, "application/sparql-update")) {
            this.doSparqlUpdate(req, resp);
        } else if (req.getParameter(ATTR_UUID) != null) {
            this.doUUID(req, resp);
        } else if (req.getParameter(ATTR_ESTCARD) != null) {
            this.doEstCard(req, resp);
        } else if (req.getParameter(ATTR_HASSTMT) != null) {
            this.doHasStmt(req, resp);
        } else if (req.getParameter(ATTR_GETSTMTS) != null) {
            this.doGetStmts(req, resp);
        } else if (req.getParameter(ATTR_CONTEXTS) != null) {
            this.doContexts(req, resp);
        } else {
            this.doSparqlQuery(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(ATTR_QUERY) != null) {
            this.doSparqlQuery(req, resp);
        } else if (req.getParameter(ATTR_UUID) != null) {
            this.doUUID(req, resp);
        } else if (req.getParameter(ATTR_ESTCARD) != null) {
            this.doEstCard(req, resp);
        } else if (req.getParameter(ATTR_HASSTMT) != null) {
            this.doHasStmt(req, resp);
        } else if (req.getParameter(ATTR_GETSTMTS) != null) {
            this.doGetStmts(req, resp);
        } else if (req.getParameter(ATTR_CONTEXTS) != null) {
            this.doContexts(req, resp);
        } else if (req.getParameter(ATTR_SHARDS) != null) {
            this.doShardReport(req, resp);
        } else {
            this.doServiceDescription(req, resp);
            return;
        }
    }

    private void doUUID(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        QueryServlet.buildAndCommitResponse(resp, 200, "text/plain", UUID.randomUUID().toString(), new NV[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServiceDescription(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long tx = this.getBigdataRDFContext().newTx(this.getTimestamp(req));
        try {
            AbstractTripleStore tripleStore = this.getBigdataRDFContext().getTripleStore(this.getNamespace(req), tx);
            if (tripleStore == null) {
                this.buildAndCommitNamespaceNotFoundResponse(req, resp);
                return;
            }
            String[] serviceURI = BigdataServlet.getServiceURIs(this.getServletContext(), req);
            LinkedHashModel g = new LinkedHashModel();
            SD sd = new SD((Graph)g, tripleStore, serviceURI);
            SparqlEndpointConfig config = this.getBigdataRDFContext().getConfig();
            sd.describeService(true, config.describeEachNamedGraph);
            QueryServlet.sendGraph(req, resp, (Graph)g);
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "");
        }
        finally {
            this.getBigdataRDFContext().abortTx(tx);
        }
    }

    private void doSparqlUpdate(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!QueryServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String updateStr = QueryServlet.getUpdateString(req);
        Map<String, Value> bindings = this.parseBindings(req, resp);
        if (bindings == null) {
            return;
        }
        if (updateStr == null) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", "Required parameter not found: update", new NV[0]);
            return;
        }
        try {
            String namespace = this.getNamespace(req);
            long timestamp = 0L;
            this.submitApiTask(new SparqlUpdateTask(req, resp, namespace, 0L, updateStr, bindings, this.getBigdataRDFContext())).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "SPARQL-UPDATE: updateStr=" + updateStr);
        }
    }

    void doSparqlQuery(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        String queryStr = QueryServlet.getQueryString(req);
        if (queryStr == null) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", "Not found: query", new NV[0]);
            return;
        }
        Map<String, Value> bindings = this.parseBindings(req, resp);
        if (bindings == null) {
            return;
        }
        boolean includeInferred = this.getBooleanValue(req, INCLUDE_INFERRED, true);
        try {
            String namespace = this.getNamespace(req);
            long timestamp = this.getTimestamp(req);
            this.submitApiTask(new SparqlQueryTask(req, resp, namespace, timestamp, queryStr, includeInferred, bindings, this.getBigdataRDFContext())).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "SPARQL-QUERY: queryStr=" + queryStr);
        }
    }

    private static String getQueryString(HttpServletRequest req) throws IOException {
        if (RESTServlet.hasMimeType(req, "application/sparql-query")) {
            return QueryServlet.readFully(req.getReader());
        }
        return req.getParameter(ATTR_QUERY) != null ? req.getParameter(ATTR_QUERY) : (String)req.getAttribute(ATTR_QUERY);
    }

    private static String getUpdateString(HttpServletRequest req) throws IOException {
        if (RESTServlet.hasMimeType(req, "application/sparql-update")) {
            return QueryServlet.readFully(req.getReader());
        }
        return req.getParameter(ATTR_UPDATE);
    }

    private static void explainQuery(String queryStr, BigdataRDFContext.AbstractQueryTask queryTask, FutureTask<Void> ft, Writer w) throws Exception {
        QueryRoot originalAST;
        SimpleNode parseTree;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Will build explanation");
        }
        UUID queryId2 = null;
        IRunningQuery q = null;
        while (!ft.isDone() && queryId2 == null) {
            try {
                ft.get(1L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                // empty catch block
            }
            if (queryTask.queryId2 == null) continue;
            queryId2 = queryTask.queryId2;
            break;
        }
        if (ft.isDone()) {
            ft.get();
            if (queryTask.queryId2 != null && (queryId2 = queryTask.queryId2) == null) {
                throw new AssertionError();
            }
        }
        assert (queryId2 != null);
        HTMLBuilder doc = new HTMLBuilder(queryTask.charset.name(), w);
        XMLBuilder.Node current = doc.root("html");
        BigdataRDFContext.addHtmlHeader(current, "UTF-8");
        current.node("h1", "Query");
        ASTContainer astContainer = queryTask.astContainer;
        String queryString = astContainer.getQueryString();
        if (queryString != null) {
            current.node("h2", "SPARQL");
            current.node("pre", queryString);
        }
        if ((parseTree = (SimpleNode)astContainer.getParseTree()) != null) {
            current.node("h2", "Parse Tree");
            current.node("pre", parseTree.dump(""));
        }
        if ((originalAST = astContainer.getOriginalAST()) != null) {
            current.node("h2", "Original AST");
            current.node("pre", originalAST.toString());
        }
        if (queryId2 != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving IRunningQuery: queryId2=" + queryId2));
            }
            IIndexManager indexManager = BigdataServlet.getIndexManager(queryTask.req.getServletContext());
            QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(indexManager);
            while (!ft.isDone() && q == null) {
                try {
                    ft.get(1L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    // empty catch block
                }
                try {
                    q = queryEngine.getRunningQuery(queryId2);
                }
                catch (RuntimeException ex) {
                    if (!InnerCause.isInnerCause((Throwable)ex, InterruptedException.class)) continue;
                }
            }
            if (q != null && log.isDebugEnabled()) {
                log.debug((Object)("Resolved IRunningQuery: query=" + q));
            }
        }
        if (q != null) {
            PipelineOp queryPlan;
            Iterator<BOp> it;
            current.node("h2", "Static Analysis Statistics");
            StaticAnalysisStats saStats = q.getStaticAnalysisStats();
            if (saStats == null) {
                current.node("p", "Static Analysis Statistics are not available.");
            } else {
                StaticAnalysisStat lStat;
                StaticAnalysisStat rStat;
                current = current.node("table");
                current = current.node("tr");
                current.node("th").text("object").close();
                current.node("th").text("category").close();
                current.node("th").text("elapsed [ms]").close();
                current.node("th").text("elapsed [us]").close();
                current.node("th").text("numCalls").close();
                current = current.close();
                StaticAnalysisStat pStat = saStats.getParserStat();
                if (pStat != null) {
                    current = current.node("tr");
                    current.node("td").text(pStat.getStatName()).close();
                    current.node("td").text("Parser").close();
                    current.node("td").text(String.valueOf(pStat.getElapsed() / 1000000L)).close();
                    current.node("td").text(String.valueOf(pStat.getElapsed() / 1000L)).close();
                    current.node("td").text(String.valueOf(pStat.getNrCalls())).close();
                    current = current.close();
                }
                if ((rStat = saStats.getResolveValuesStat()) != null) {
                    current = current.node("tr");
                    current.node("td").text(rStat.getStatName()).close();
                    current.node("td").text("Resolve Values").close();
                    current.node("td").text(String.valueOf(rStat.getElapsed() / 1000000L)).close();
                    current.node("td").text(String.valueOf(rStat.getElapsed() / 1000L)).close();
                    current.node("td").text(String.valueOf(rStat.getNrCalls())).close();
                    current = current.close();
                }
                if ((lStat = saStats.getOptimizerLoopStat()) != null) {
                    current = current.node("tr");
                    current.node("td").text(lStat.getStatName()).close();
                    current.node("td").text("Optimizers (all)").close();
                    current.node("td").text(String.valueOf(lStat.getElapsed() / 1000000L)).close();
                    current.node("td").text(String.valueOf(lStat.getElapsed() / 1000L)).close();
                    current.node("td").text(String.valueOf(lStat.getNrCalls())).close();
                    current = current.close();
                }
                Collection<StaticAnalysisStat> optimizerStats = saStats.getOptimizerStats();
                for (StaticAnalysisStat oStat : optimizerStats) {
                    current = current.node("tr");
                    current.node("td").text(oStat.getStatName()).close();
                    current.node("td").text("Optimizer").close();
                    current.node("td").text(String.valueOf(oStat.getElapsed() / 1000000L)).close();
                    current.node("td").text(String.valueOf(oStat.getElapsed() / 1000L)).close();
                    current.node("td").text(String.valueOf(oStat.getNrCalls())).close();
                    current = current.close();
                }
                rStat = saStats.getRangeCountStat();
                if (rStat != null) {
                    current = current.node("tr");
                    current.node("td").text(rStat.getStatName()).close();
                    current.node("td").text("Range Count").close();
                    current.node("td").text(String.valueOf(rStat.getElapsed() / 1000000L)).close();
                    current.node("td").text(String.valueOf(rStat.getElapsed() / 1000L)).close();
                    current.node("td").text(String.valueOf(rStat.getNrCalls())).close();
                    current = current.close();
                }
                current = current.close();
            }
            QueryRoot optimizedAST = astContainer.getOptimizedAST();
            IBindingSet[] bs = astContainer.getOptimizedASTBindingSets();
            if (optimizedAST != null) {
                current.node("h2", "Optimized AST");
                current.node("pre", optimizedAST.toString(0, bs));
            }
            if ((it = ExplainHints.explainHintAnnotatedBOpIterator(optimizedAST)).hasNext()) {
                current.node("h2", "Explain Hints");
                current = current.node("table");
                current = current.node("tr");
                current.node("th").text("#").close();
                current.node("th").text("type").close();
                current.node("th").text("severity").close();
                current.node("th").text("AST node").close();
                current.node("th").text("description").close();
                current = current.close();
                int ctr = 0;
                while (it.hasNext()) {
                    BOp bop = it.next();
                    ExplainHints explainHints = (ExplainHints)bop.getProperty("explainHints");
                    for (IExplainHint hint : explainHints) {
                        current = current.node("tr");
                        current.node("td").text(String.valueOf(ctr++)).close();
                        if (hint.getHelpLink() != null) {
                            current.node("td").node("a").attr("href", hint.getHelpLink()).text(hint.getExplainHintType()).close().close();
                        } else {
                            current.node("td").text(hint.getExplainHintType()).close();
                        }
                        current.node("td").text(hint.getExplainHintSeverity().toString()).close();
                        current.node("td").text(hint.getExplainHintNode().toString()).close();
                        current.node("td").text(hint.getExplainHintDescription()).close();
                        current = current.close();
                    }
                }
                current = current.close();
            }
            if ((queryPlan = astContainer.getQueryPlan()) != null) {
                current.node("h2", "Query Plan");
                current.node("pre", BOpUtility.toString(queryPlan));
            }
        }
        try {
            ft.get();
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw));
            String s = sw.getBuffer().toString();
            current.node("pre").text(s).close();
        }
        current.node("h2", "Query Evaluation Statistics");
        if (q == null) {
            current.node("p", "Statistics are not available (query already terminated).");
        } else {
            IRunningQuery[] children = ((AbstractRunningQuery)q).getChildren();
            long elapsedMillis = q.getElapsed();
            BOpStats stats = q.getStats().get(q.getQuery().getId());
            String solutionsOut = stats == null ? "N/A" : Long.toString(stats.unitsOut.get());
            String chunksOut = stats == null ? "N/A" : Long.toString(stats.chunksOut.get());
            current.node("p").text("solutions=" + solutionsOut).text(", chunks=" + chunksOut).text(", subqueries=" + children.length).text(", elapsed=" + elapsedMillis + "ms").text(q.isCancelled() ? ", CANCELLED." : ".").close();
            boolean clusterStats = q.getFederation() != null;
            boolean mutationStats = false;
            QueryLog.getTableXHTML(queryStr, q, children, w, false, 0, clusterStats, queryTask.explainDetails, false);
        }
        doc.closeAll(current);
    }

    private void doEstCard(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] c;
        Value o;
        URI p;
        Resource s;
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        boolean exact = this.getBooleanValue(req, "exact", false);
        try {
            s = EncodeDecodeValue.decodeResource((String)req.getParameter("s"));
            p = EncodeDecodeValue.decodeURI((String)req.getParameter("p"));
            o = EncodeDecodeValue.decodeValue((String)req.getParameter("o"));
            c = QueryServlet.decodeContexts(req, "c");
        }
        catch (IllegalArgumentException ex) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", ex.getLocalizedMessage(), new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("ESTCARD: access path: (exact=" + exact + ", s=" + s + ", p=" + p + ", o=" + o + ", c=" + Arrays.toString(c) + ")"));
        }
        try {
            this.submitApiTask(new EstCardTask(req, resp, this.getNamespace(req), this.getTimestamp(req), exact, s, p, o, (Resource[])c)).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "ESTCARD: access path: (exact=" + exact + ", s=" + s + ", p=" + p + ", o=" + o + ", c=" + Arrays.toString(c) + ")");
        }
    }

    private void doHasStmt(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] c;
        Value o;
        URI p;
        Resource s;
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        boolean includeInferred = this.getBooleanValue(req, INCLUDE_INFERRED, true);
        try {
            s = EncodeDecodeValue.decodeResource((String)req.getParameter("s"));
            p = EncodeDecodeValue.decodeURI((String)req.getParameter("p"));
            o = EncodeDecodeValue.decodeValue((String)req.getParameter("o"));
            c = QueryServlet.decodeContexts(req, "c");
        }
        catch (IllegalArgumentException ex) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", ex.getLocalizedMessage(), new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("HASSTMT: access path: (includeInferred=" + includeInferred + ", s=" + s + ", p=" + p + ", o=" + o + ", c=" + Arrays.toString(c) + ")"));
        }
        try {
            this.submitApiTask(new HasStmtTask(req, resp, this.getNamespace(req), this.getTimestamp(req), includeInferred, s, p, o, (Resource[])c)).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "HASSTMT: access path: (includeInferred=" + includeInferred + ", s=" + s + ", p=" + p + ", o=" + o + ", c=" + Arrays.toString(c) + ")");
        }
    }

    private void doGetStmts(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Enumeration mimeTypes;
        Object[] c;
        Value o;
        URI p;
        Resource s;
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        boolean includeInferred = this.getBooleanValue(req, INCLUDE_INFERRED, true);
        try {
            s = EncodeDecodeValue.decodeResource((String)req.getParameter("s"));
            p = EncodeDecodeValue.decodeURI((String)req.getParameter("p"));
            o = EncodeDecodeValue.decodeValue((String)req.getParameter("o"));
            c = QueryServlet.decodeContexts(req, "c");
            mimeTypes = req.getHeaders("Accept");
        }
        catch (IllegalArgumentException ex) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", ex.getLocalizedMessage(), new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("GETSTMTS: access path: (includeInferred=" + includeInferred + ", s=" + s + ", p=" + p + ", o=" + o + ", c=" + Arrays.toString(c) + ")"));
        }
        try {
            this.submitApiTask(new GetStmtsTask(req, resp, this.getNamespace(req), this.getTimestamp(req), includeInferred, s, p, o, (Resource[])c, mimeTypes)).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "GETSTMTS: access path: (includeInferred=" + includeInferred + ", s=" + s + ", p=" + p + ", o=" + o + ", c=" + Arrays.toString(c) + ")");
        }
    }

    private void doContexts(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        try {
            this.submitApiTask(new RestApiGetContextsTask(req, resp, this.getNamespace(req), this.getTimestamp(req))).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "GET-CONTEXTS");
        }
    }

    private void doShardReport(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Resource c;
        Value o;
        URI p;
        Resource s;
        if (!QueryServlet.isReadable(this.getServletContext(), req, resp)) {
            return;
        }
        if (!this.getBigdataRDFContext().isScaleOut()) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", "Not scale-out", new NV[0]);
            return;
        }
        boolean doRangeCount = true;
        try {
            s = EncodeDecodeValue.decodeResource((String)req.getParameter("s"));
            p = EncodeDecodeValue.decodeURI((String)req.getParameter("p"));
            o = EncodeDecodeValue.decodeValue((String)req.getParameter("o"));
            c = EncodeDecodeValue.decodeResource((String)req.getParameter("c"));
        }
        catch (IllegalArgumentException ex) {
            QueryServlet.buildAndCommitResponse(resp, 400, "text/plain", ex.getLocalizedMessage(), new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("SHARDS: access path: (s=" + s + ", p=" + p + ", o=" + o + ", c=" + c + ")"));
        }
        try {
            this.submitApiTask(new ShardsTask(req, resp, this.getNamespace(req), this.getTimestamp(req), s, p, o, c, true)).get();
        }
        catch (Throwable t) {
            QueryServlet.launderThrowable(t, resp, "SHARDS: access path: (s=" + s + ", p=" + p + ", o=" + o + ", c=" + c + ")");
        }
    }

    private static class ShardsTask
    extends AbstractRestApiTask<Void> {
        private final Resource s;
        private final URI p;
        private final Value o;
        private final Resource c;
        private final boolean doRangeCount;

        public ShardsTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, Resource s, URI p, Value o, Resource c, boolean doRangeCount) {
            super(req, resp, namespace, timestamp);
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
            this.doRangeCount = doRangeCount;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                AccessPath accessPath = (AccessPath)conn.getTripleStore().getAccessPath(this.s, this.p, this.o, this.c);
                ClientIndexView ndx = (ClientIndexView)accessPath.getIndex();
                String charset = "utf-8";
                this.resp.setContentType("text/html");
                this.resp.setCharacterEncoding("utf-8");
                PrintWriter w = this.resp.getWriter();
                try {
                    HTMLBuilder doc = new HTMLBuilder("utf-8", w);
                    XMLBuilder.Node current = doc.root("html");
                    BigdataRDFContext.addHtmlHeader(current, "utf-8");
                    IBigdataFederation fed = (IBigdataFederation)this.getIndexManager();
                    Iterator<PartitionLocator> itr = ndx.locatorScan(this.timestamp, accessPath.getFromKey(), accessPath.getToKey(), false);
                    int nlocators = 0;
                    TreeMap<String, AtomicInteger> hosts = new TreeMap<String, AtomicInteger>();
                    StringBuilder sb = new StringBuilder();
                    while (itr.hasNext()) {
                        PartitionLocator loc = itr.next();
                        IDataService ds = fed.getDataService(loc.getDataServiceUUID());
                        String hostname = ds == null ? "N/A" : ds.getHostname();
                        AtomicInteger nshards = (AtomicInteger)hosts.get(hostname);
                        if (nshards == null) {
                            nshards = new AtomicInteger();
                            hosts.put(hostname, nshards);
                        }
                        nshards.incrementAndGet();
                        sb.append("\nhost=" + hostname);
                        sb.append(", locator=" + loc);
                        ++nlocators;
                    }
                    long begin2 = System.currentTimeMillis();
                    long elapsed = begin2 - begin;
                    long rangeCount = this.doRangeCount ? accessPath.rangeCount(false) : -1L;
                    long elapsed2 = System.currentTimeMillis() - begin2;
                    current = current.node("H2", "summary");
                    current.node("p", "index=" + ndx.getIndexMetadata().getName() + ", locators=" + nlocators + ", hosts=" + hosts.size() + ", elapsed=" + elapsed + "ms");
                    if (this.doRangeCount) {
                        current.node("p", "rangeCount=" + rangeCount + ", elapsed=" + elapsed2 + "ms");
                    }
                    current.node("H2", "shards").node("pre", sb.toString());
                    sb.setLength(0);
                    for (Map.Entry e : hosts.entrySet()) {
                        sb.append("\nhost=" + (String)e.getKey());
                        sb.append(", #shards=" + e.getValue());
                    }
                    current.node("H2", "hosts").node("pre", sb.toString());
                    doc.closeAll(current);
                }
                finally {
                    ((Writer)w).flush();
                    ((Writer)w).close();
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class GetStmtsTask
    extends AbstractRestApiTask<Void> {
        private final Enumeration<String> mimeTypes;
        private final boolean includeInferred;
        private final Resource s;
        private final URI p;
        private final Value o;
        private final Resource[] c;

        public GetStmtsTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, boolean includeInferred, Resource s, URI p, Value o, Resource[] c, Enumeration<String> mimeTypes) {
            super(req, resp, namespace, timestamp);
            this.includeInferred = includeInferred;
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
            this.mimeTypes = mimeTypes;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                String mimeType = null;
                RDFFormat format = null;
                if (this.mimeTypes != null) {
                    block6: while (this.mimeTypes.hasMoreElements()) {
                        for (String mt : this.mimeTypes.nextElement().split(",")) {
                            mt = mt.trim();
                            RDFFormat fmt = (RDFFormat)RDFWriterRegistry.getInstance().getFileFormatForMIMEType(mt);
                            if ((!conn.getTripleStore().isQuads() || !mt.equals(RDFFormat.NQUADS.getDefaultMIMEType()) && !mt.equals(RDFFormat.TURTLE.getDefaultMIMEType())) && (conn.getTripleStore().isQuads() || fmt == null)) continue;
                            mimeType = mt;
                            format = fmt;
                            break block6;
                        }
                    }
                }
                if (format == null) {
                    mimeType = conn.getTripleStore().isQuads() ? RDFFormat.NQUADS.getDefaultMIMEType() : RDFFormat.NTRIPLES.getDefaultMIMEType();
                    format = (RDFFormat)RDFWriterRegistry.getInstance().getFileFormatForMIMEType(mimeType);
                }
                this.resp.setContentType(mimeType);
                ServletOutputStream os = this.resp.getOutputStream();
                RDFWriter w = ((RDFWriterFactory)RDFWriterRegistry.getInstance().get(format)).getWriter((OutputStream)os);
                RepositoryResult stmts = null;
                try {
                    w.startRDF();
                    stmts = conn.getStatements(this.s, this.p, this.o, this.includeInferred, this.c);
                    while (stmts.hasNext()) {
                        w.handleStatement((Statement)stmts.next());
                    }
                    w.endRDF();
                }
                finally {
                    if (stmts != null) {
                        stmts.close();
                    }
                    os.flush();
                    os.close();
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class HasStmtTask
    extends AbstractRestApiTask<Void> {
        private final boolean includeInferred;
        private final Resource s;
        private final URI p;
        private final Value o;
        private final Resource[] c;

        public HasStmtTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, boolean includeInferred, Resource s, URI p, Value o, Resource[] c) {
            super(req, resp, namespace, timestamp);
            this.includeInferred = includeInferred;
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                boolean found = conn.hasStatement(this.s, this.p, this.o, this.includeInferred, this.c == null ? new Resource[]{} : this.c);
                long elapsed = System.currentTimeMillis() - begin;
                BigdataRDFServlet.buildAndCommitBooleanResponse(this.resp, found, elapsed);
                Void void_ = null;
                return void_;
            }
        }
    }

    private static class EstCardTask
    extends AbstractRestApiTask<Void> {
        private final boolean exact;
        private final Resource s;
        private final URI p;
        private final Value o;
        private final Resource[] c;

        public EstCardTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, boolean exact, Resource s, URI p, Value o, Resource[] c) {
            super(req, resp, namespace, timestamp);
            this.exact = exact;
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                long rangeCount = 0L;
                if (this.c != null && this.c.length > 0) {
                    for (Resource r : this.c) {
                        rangeCount += conn.getTripleStore().getAccessPath(this.s, this.p, this.o, r).rangeCount(this.exact);
                    }
                } else {
                    rangeCount += conn.getTripleStore().getAccessPath(this.s, this.p, this.o, (Resource)null).rangeCount(this.exact);
                }
                long elapsed = System.currentTimeMillis() - begin;
                BigdataRDFServlet.buildAndCommitRangeCountResponse(this.resp, rangeCount, elapsed);
                Void void_ = null;
                return void_;
            }
        }
    }

    static class SparqlQueryTask
    extends AbstractRestApiTask<Void> {
        private final String queryStr;
        private final BigdataRDFContext context;
        private final boolean includeInferred;
        private final Map<String, Value> bindings;

        public SparqlQueryTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String queryStr, boolean includeInferred, Map<String, Value> bindings, BigdataRDFContext context) {
            super(req, resp, namespace, timestamp);
            if (queryStr == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.queryStr = queryStr;
            this.context = context;
            this.includeInferred = includeInferred;
            this.bindings = bindings;
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            String baseURI = BigdataRDFContext.getBaseURI(this.req, this.resp);
            ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseQuery2(this.queryStr, baseURI);
            try (BigdataSailRepositoryConnection conn = null;){
                conn = this.getQueryConnection();
                ServletOutputStream os = this.resp.getOutputStream();
                BigdataRDFContext.AbstractQueryTask queryTask = this.context.getQueryTask(conn, this.namespace, this.timestamp, this.queryStr, baseURI, astContainer, this.includeInferred, this.bindings, null, this.req, this.resp, (OutputStream)os);
                FutureTask<Void> ft = new FutureTask<Void>(queryTask);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Will run query: " + this.queryStr));
                }
                this.resp.setStatus(200);
                if (queryTask.explain) {
                    this.resp.setContentType("text/html");
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, queryTask.charset);
                    try {
                        this.context.queryService.execute(ft);
                        QueryServlet.explainQuery(this.queryStr, queryTask, ft, w);
                    }
                    finally {
                        ((Writer)w).flush();
                        ((Writer)w).close();
                        os.flush();
                        os.close();
                    }
                } else {
                    this.resp.setContentType(queryTask.mimeType);
                    if (queryTask.charset != null) {
                        this.resp.setCharacterEncoding(queryTask.charset.name());
                    }
                    if (BigdataRDFServlet.isAttachment(queryTask.mimeType)) {
                        this.resp.setHeader("Content-disposition", "attachment; filename=query" + queryTask.queryId + "." + queryTask.fileExt);
                    }
                    if (TimestampUtility.isCommitTime(queryTask.timestamp)) {
                        this.resp.addHeader("Cache-Control", "public");
                    }
                    this.context.queryService.execute(ft);
                    ft.get();
                }
                Void void_ = null;
                return void_;
            }
        }
    }

    static class SparqlUpdateTask
    extends AbstractRestApiTask<Void> {
        private final String updateStr;
        private final BigdataRDFContext context;
        private final Map<String, Value> bindings;

        public SparqlUpdateTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String updateStr, Map<String, Value> bindings, BigdataRDFContext context) {
            super(req, resp, namespace, timestamp);
            this.updateStr = updateStr;
            this.context = context;
            this.bindings = bindings;
        }

        @Override
        public final boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            String baseURI = this.req.getRequestURL().toString();
            ASTContainer astContainer = new Bigdata2ASTSPARQLParser().parseUpdate2(this.updateStr, baseURI);
            if (log.isDebugEnabled()) {
                log.debug((Object)astContainer.toString());
            }
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getConnection();
                BigdataRDFContext.UpdateTask updateTask = this.context.getUpdateTask(conn, this.namespace, this.timestamp, baseURI, this.bindings, astContainer, this.req, this.resp, (OutputStream)this.resp.getOutputStream());
                FutureTask<Void> ft = new FutureTask<Void>(updateTask);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Will run update: " + this.updateStr));
                }
                updateTask.updateFuture = ft;
                this.context.queryService.execute(ft);
                ft.get();
                success = true;
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "{namespace=" + this.getNamespace() + ",timestamp=" + this.getTimestamp() + ", updateStr=[" + this.updateStr + "]}";
        }
    }
}

