/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.journal.BasicSnapshotFactory;
import com.bigdata.journal.ISnapshotResult;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.util.NV;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class BackupServlet
extends BigdataRDFServlet {
    private static final Logger log = Logger.getLogger(BackupServlet.class);
    private static final boolean debug = log.isDebugEnabled();
    private static final long serialVersionUID = 5983619974621184746L;
    public static final String COMPRESS = "compress";
    public static final String FILE = "file";
    public static final String DEFAULT_FILE = "backup.jnl";
    public static final String BLOCK = "block";

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.doGet(req, res);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.processRequest(req, res);
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        boolean compress = false;
        boolean block = true;
        String file = DEFAULT_FILE;
        boolean hasError = false;
        StringBuffer errorMessage = new StringBuffer();
        String param = req.getParameter(COMPRESS);
        if (param != null) {
            compress = !"".equals(param) ? Boolean.parseBoolean(param) : true;
        }
        if ((param = req.getParameter(BLOCK)) != null && !"".equals(param)) {
            block = Boolean.parseBoolean(param);
        }
        if ((param = req.getParameter(FILE)) != null && !"".equals(param)) {
            file = param;
        }
        BasicSnapshotFactory snapfact = new BasicSnapshotFactory(file, compress);
        if (debug) {
            log.debug((Object)("Snapshot requested.  Writing backup to " + snapfact.getFile()));
        }
        log.warn((Object)("Snapshot requested.  Writing backup to " + snapfact.getFile()));
        Future<ISnapshotResult> f = ((Journal)this.getIndexManager()).snapshot(snapfact);
        if (block) {
            try {
                ISnapshotResult r = f.get();
                if (debug) {
                    log.debug((Object)("Snapshot completed at " + r.getFile().getAbsolutePath()));
                }
            }
            catch (InterruptedException e) {
                hasError = true;
                errorMessage.append(e.toString());
                log.warn((Object)e);
            }
            catch (ExecutionException e) {
                hasError = true;
                errorMessage.append(e.toString());
                log.warn((Object)e);
            }
        }
        if (hasError) {
            BackupServlet.buildAndCommitResponse(res, 500, "text/plain", errorMessage.toString() + "\n", new NV[0]);
        } else {
            BackupServlet.buildAndCommitResponse(res, 200, "text/plain", "Backup created at " + file + ".\n", new NV[0]);
        }
    }
}

