/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public class BigdataLiteralImpl
extends BigdataValueImpl
implements BigdataLiteral {
    private static final long serialVersionUID = 2301819664179569810L;
    private final String label;
    private final String language;
    private final BigdataURI datatype;

    BigdataLiteralImpl(BigdataValueFactory valueFactory, String label, String language, BigdataURI datatype) {
        super(valueFactory, null);
        if (label == null) {
            throw new IllegalArgumentException();
        }
        if (language != null && datatype != null) {
            throw new IllegalArgumentException();
        }
        this.label = label;
        this.language = language != null ? language.toLowerCase().intern() : null;
        this.datatype = datatype;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(this.label);
        sb.append('\"');
        if (this.language != null) {
            sb.append('@');
            sb.append(this.language);
        } else if (this.datatype != null) {
            sb.append("^^<");
            sb.append(this.datatype);
            sb.append('>');
        }
        return sb.toString();
    }

    public String stringValue() {
        return this.label;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getLanguage() {
        return this.language;
    }

    @Override
    public final BigdataURI getDatatype() {
        return this.datatype;
    }

    public final int hashCode() {
        return this.label.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Literal)) {
            return false;
        }
        return this.equals((Literal)o);
    }

    public final boolean equals(Literal o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof BigdataValue && this.isRealIV() && ((BigdataValue)o).isRealIV() && ((BigdataValue)o).getValueFactory() == this.getValueFactory()) {
            return this.getIV().equals(((BigdataValue)o).getIV());
        }
        if (!this.label.equals(o.getLabel())) {
            return false;
        }
        if (this.language != null) {
            return this.language.equalsIgnoreCase(o.getLanguage());
        }
        if (o.getLanguage() != null) {
            return false;
        }
        if (this.datatype != null) {
            return this.datatype.equals(o.getDatatype());
        }
        return o.getDatatype() == null;
    }

    public final boolean booleanValue() {
        return XMLDatatypeUtil.parseBoolean((String)this.label);
    }

    public final byte byteValue() {
        return XMLDatatypeUtil.parseByte((String)this.label);
    }

    public final short shortValue() {
        return XMLDatatypeUtil.parseShort((String)this.label);
    }

    public final int intValue() {
        return XMLDatatypeUtil.parseInt((String)this.label);
    }

    public final long longValue() {
        return XMLDatatypeUtil.parseLong((String)this.label);
    }

    public final float floatValue() {
        return XMLDatatypeUtil.parseFloat((String)this.label);
    }

    public final double doubleValue() {
        return XMLDatatypeUtil.parseDouble((String)this.label);
    }

    public final BigInteger integerValue() {
        return XMLDatatypeUtil.parseInteger((String)this.label);
    }

    public final BigDecimal decimalValue() {
        return XMLDatatypeUtil.parseDecimal((String)this.label);
    }

    public final XMLGregorianCalendar calendarValue() {
        return XMLDatatypeUtil.parseCalendar((String)this.label);
    }
}

