/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.lexicon.Id2TermWriteProc;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueSerializer;
import java.util.concurrent.Callable;
import org.openrdf.model.BNode;

public class ReverseIndexWriterTask
implements Callable<Long> {
    private final IIndex idTermIndex;
    private final BigdataValueSerializer<BigdataValue> ser;
    private final KVO<BigdataValue>[] a;
    private final int ndistinct;
    private final boolean storeBlankNodes;

    public ReverseIndexWriterTask(IIndex idTermIndex, BigdataValueFactory valueFactory, KVO<BigdataValue>[] a, int ndistinct, boolean storeBlankNodes) {
        if (idTermIndex == null) {
            throw new IllegalArgumentException();
        }
        if (valueFactory == null) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (ndistinct < 0 || ndistinct > a.length) {
            throw new IllegalArgumentException();
        }
        this.idTermIndex = idTermIndex;
        this.ser = valueFactory.getValueSerializer();
        this.a = a;
        this.ndistinct = ndistinct;
        this.storeBlankNodes = storeBlankNodes;
    }

    @Override
    public Long call() throws Exception {
        long _begin = System.currentTimeMillis();
        byte[][] keys = new byte[this.ndistinct][];
        byte[][] vals = new byte[this.ndistinct][];
        int nonBNodeCount = 0;
        IKeyBuilder keyBuilder = KeyBuilder.newInstance();
        int initialCapacity = 128;
        DataOutputBuffer out = new DataOutputBuffer(128);
        ByteArrayBuffer tmp = new ByteArrayBuffer(128);
        for (int i = 0; i < this.ndistinct; ++i) {
            BigdataValue x = (BigdataValue)this.a[i].obj;
            if (!this.storeBlankNodes && x instanceof BNode) continue;
            keys[nonBNodeCount] = x.getIV().encode(keyBuilder.reset()).getKey();
            vals[nonBNodeCount] = this.ser.serialize(x, out.reset(), tmp);
            ++nonBNodeCount;
        }
        if (nonBNodeCount > 0) {
            this.idTermIndex.submit(0, nonBNodeCount, keys, vals, Id2TermWriteProc.Id2TermWriteProcConstructor.INSTANCE, null);
        }
        return System.currentTimeMillis() - _begin;
    }
}

