/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import java.util.Map;
import org.apache.log4j.Logger;

public class IsMaterializedBOp
extends XSDBooleanIVValueExpression {
    private static final long serialVersionUID = -7552628930845996572L;
    private static final transient Logger log = Logger.getLogger(IsMaterializedBOp.class);

    public IsMaterializedBOp(IVariable<IV> x, boolean materialized) {
        this(new BOp[]{x}, NV.asMap(Annotations.MATERIALIZED, (Object)materialized));
    }

    public IsMaterializedBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
        if (this.getProperty(Annotations.MATERIALIZED) == null) {
            throw new IllegalArgumentException();
        }
    }

    public IsMaterializedBOp(IsMaterializedBOp op) {
        super(op);
    }

    @Override
    public boolean accept(IBindingSet bs) {
        boolean materialized = (Boolean)this.getRequiredProperty(Annotations.MATERIALIZED);
        IV iv = (IV)this.get(0).get(bs);
        if (log.isDebugEnabled()) {
            log.debug((Object)iv);
            if (iv != null) {
                log.debug((Object)("materialized?: " + iv.hasValue()));
            }
        }
        if (iv == null) {
            throw new SparqlTypeErrorException();
        }
        return iv.hasValue() == materialized || !iv.needsMaterialization();
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String MATERIALIZED = IsMaterializedBOp.class.getName() + ".materialized";
    }
}

