/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IPrefixedURIHandler;
import com.bigdata.rdf.internal.ISuffixedURIHandler;
import com.bigdata.rdf.internal.InlineLocalNameIntegerURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;

public class InlinePrefixedSuffixedFixedWidthIntegerURIHandler
extends InlineLocalNameIntegerURIHandler
implements IPrefixedURIHandler,
ISuffixedURIHandler {
    private String prefix = null;
    private String suffix = null;
    private int width = 0;

    public InlinePrefixedSuffixedFixedWidthIntegerURIHandler(String namespace, String prefix, String suffix, int width) {
        super(namespace);
        this.prefix = prefix;
        this.suffix = suffix;
        this.width = width;
    }

    public InlinePrefixedSuffixedFixedWidthIntegerURIHandler(String namespace, String prefix, String suffix, int width, int id) {
        super(namespace);
        this.prefix = prefix;
        this.suffix = suffix;
        this.width = width;
        this.packedId = id;
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        if (!localName.startsWith(this.prefix) || !localName.endsWith(this.suffix)) {
            return null;
        }
        String intValue = localName.substring(this.prefix.length(), localName.length() - this.suffix.length());
        return super.createInlineIV(this.getPackedValueString(intValue));
    }

    @Override
    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        String intStr = super.getLocalNameFromDelegate(delegate);
        int intVal = (int)this.getUnpackedValueFromString(intStr);
        return this.prefix + String.format("%0" + this.width + "d", intVal) + this.suffix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

