/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.InlineSignedIntegerURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;

public class InlineFixedWidthIntegerURIHandler
extends InlineSignedIntegerURIHandler {
    private int fixedWidth = 0;

    public InlineFixedWidthIntegerURIHandler(String namespace, int fixedWidth) {
        super(namespace);
        this.fixedWidth = fixedWidth;
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        if (localName == null) {
            return null;
        }
        String intValue = localName;
        return super.createInlineIV(intValue);
    }

    @Override
    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        String intStr = super.getLocalNameFromDelegate(delegate);
        int intVal = Integer.parseInt(intStr);
        String localName = String.format("%0" + this.fixedWidth + "d", intVal);
        return localName;
    }
}

