/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.StatementWriter;
import com.bigdata.rdf.inf.AbstractSPOBuffer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.striterator.ChunkedArrayIterator;

public class SPORetractionBuffer
extends AbstractSPOBuffer {
    private final AbstractTripleStore store;
    private final boolean computeClosureForStatementIdentifiers;
    protected final IChangeLog changeLog;

    public SPORetractionBuffer(AbstractTripleStore store, int capacity, boolean computeClosureForStatementIdentifiers) {
        this(store, capacity, computeClosureForStatementIdentifiers, null);
    }

    public SPORetractionBuffer(AbstractTripleStore store, int capacity, boolean computeClosureForStatementIdentifiers, IChangeLog changeLog) {
        super(store, null, capacity);
        if (store == null) {
            throw new IllegalArgumentException();
        }
        this.store = store;
        this.computeClosureForStatementIdentifiers = computeClosureForStatementIdentifiers;
        this.changeLog = changeLog;
    }

    @Override
    public int flush() {
        if (this.isEmpty()) {
            return 0;
        }
        long n = this.changeLog == null ? this.store.removeStatements(new ChunkedArrayIterator<ISPO>(this.numStmts, this.stmts, null), this.computeClosureForStatementIdentifiers) : StatementWriter.removeStatements(this.store, new ChunkedArrayIterator<ISPO>(this.numStmts, this.stmts, null), this.computeClosureForStatementIdentifiers, this.changeLog);
        this.numStmts = 0;
        return (int)Math.min(Integer.MAX_VALUE, n);
    }
}

